/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.helpers.providers;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.py.helpers.JupyterPyHelperProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/helpers/providers/WslPyHelperProvider;", "Lcom/intellij/jupyter/py/helpers/JupyterPyHelperProvider;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "serverRoot", "Ljava/nio/file/Path;", "getServerRoot", "()Ljava/nio/file/Path;", "getPaths", "", "getWslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "mapToWslManually", "", "path", "getWslMsId", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nWslPyHelperProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslPyHelperProvider.kt\ncom/intellij/jupyter/py/helpers/providers/WslPyHelperProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1586#3:76\n1661#3,3:77\n*S KotlinDebug\n*F\n+ 1 WslPyHelperProvider.kt\ncom/intellij/jupyter/py/helpers/providers/WslPyHelperProvider\n*L\n36#1:76\n36#1:77,3\n*E\n"})
public final class WslPyHelperProvider
implements JupyterPyHelperProvider {
    @Override
    public boolean isApplicable(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = JupyterPyHelperProvider.Companion.getSdk(file, project);
        return sdk != null && (sdk = PyStatisticToolsKt.getExecutionType((Sdk)sdk)) != null ? sdk.isWsl() : false;
    }

    @Override
    @NotNull
    public Path getServerRoot() {
        throw new IllegalStateException("Server root does not exist for WSL local mounts".toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Path> getPaths(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        void $this$mapTo$iv$iv;
        WSLDistribution wSLDistribution;
        String msId;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk = JupyterPyHelperProvider.Companion.getSdk(file, project);
        if (sdk == null) {
            throw new IllegalStateException("WslPyHelperProvider: Python SDK not found".toString());
        }
        Sdk sdk2 = sdk;
        String string = msId = this.getWslMsId(sdk2);
        if (string != null) {
            String it = string;
            boolean bl = false;
            wSLDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(it);
        } else {
            wSLDistribution = null;
        }
        WSLDistribution distribution = wSLDistribution;
        Iterable $this$map$iv = JupyterPyHelperProvider.Companion.getLocalPaths();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void localPath;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object object = distribution;
            if (object == null || (object = object.getWslPath((Path)localPath)) == null) {
                object = this.mapToWslManually((Path)localPath);
            }
            Object mappedString = object;
            collection.add(Paths.get((String)mappedString, new String[0]));
        }
        return (List)destination$iv$iv;
    }

    private final WSLDistribution getWslDistribution(Sdk sdk) {
        WSLDistribution wSLDistribution;
        WslPath wslPath;
        String string = sdk.getHomePath();
        if (string == null) {
            return null;
        }
        String homePath = string;
        WslPath wslPath2 = wslPath = WslPath.Companion.parseWindowsUncPath(homePath);
        if (wslPath2 != null) {
            WslPath it = wslPath2;
            boolean bl = false;
            wSLDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(it.getDistributionId());
        } else {
            wSLDistribution = null;
        }
        return wSLDistribution;
    }

    private final String mapToWslManually(Path path) {
        Object object;
        String string = FileUtil.toSystemIndependentName((String)((Object)path).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String systemIndependent = string;
        if (systemIndependent.length() >= 3 && systemIndependent.charAt(1) == ':') {
            char c = Character.toLowerCase(systemIndependent.charAt(0));
            String string2 = systemIndependent.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = "/mnt/" + c + string2;
        } else {
            object = systemIndependent;
        }
        return StringsKt.replaceFirst$default((String)object, (String)"\\", (String)"/", (boolean)false, (int)4, null);
    }

    private final String getWslMsId(Sdk sdk) {
        TargetEnvironmentConfiguration config;
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof PyTargetAwareAdditionalData && (config = ((PyTargetAwareAdditionalData)data).getTargetEnvironmentConfiguration()) instanceof WslTargetEnvironmentConfiguration) {
            WSLDistribution wSLDistribution = ((WslTargetEnvironmentConfiguration)config).getDistribution();
            return wSLDistribution != null ? wSLDistribution.getMsId() : null;
        }
        String string = sdk.getHomePath();
        if (string == null) {
            return null;
        }
        String homePath = string;
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath(homePath);
        return wslPath != null ? wslPath.getDistributionId() : null;
    }
}

