/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.intellij.lang.regexp.RegExpMatch;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CheckRegExpForm {
    private static final Logger LOG = Logger.getInstance(CheckRegExpForm.class);
    private static final Key<List<RegExpMatch>> LATEST_MATCHES = Key.create((String)"REG_EXP_LATEST_MATCHES");
    private static final Key<RegExpMatchResult> RESULT = Key.create((String)"REG_EXP_RESULT");
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private final EditorTextField myRegExp;
    private final EditorTextField mySampleText;
    private final JPanel myRootPanel;
    private final JBLabel myRegExpIcon;
    private final JBLabel mySampleIcon;
    private final List<RangeHighlighter> mySampleHighlights;
    private RangeHighlighter myRegExpHighlight;

    public CheckRegExpForm(final @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(0);
        }
        this.myRegExpIcon = new JBLabel();
        this.mySampleIcon = new JBLabel();
        this.mySampleHighlights = new SmartList();
        this.myRegExpHighlight = null;
        final Project project = regExpFile.getProject();
        LanguageTextField.DocumentCreator documentProvider = (value, language, project1) -> regExpFile.getViewProvider().getDocument();
        this.myRegExp = new LanguageTextField(regExpFile.getLanguage(), project, regExpFile.getText(), documentProvider, false){
            private final Disposable disposable;
            {
                super(arg0, arg1, arg2, arg3, arg4);
                this.disposable = Disposer.newDisposable();
            }

            protected void onEditorAdded(final @NotNull Editor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onEditorAdded(editor);
                editor.getCaretModel().addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int offset = editor.logicalPositionToOffset(event.getNewPosition());
                        CheckRegExpForm.this.highlightRegExpGroup(offset, regExpFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/lang/regexp/intention/CheckRegExpForm$1$1", "caretPositionChanged"));
                    }
                }, this.disposable);
            }

            public void removeNotify() {
                super.removeNotify();
                CheckRegExpForm.this.removeHighlights(HighlightManager.getInstance((Project)regExpFile.getProject()));
                Disposer.dispose((Disposable)this.disposable);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(Keys.CHECK_REG_EXP_EDITOR, (Object)Boolean.TRUE);
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                EditorEx editorEx = editor;
                if (editorEx == null) {
                    1.$$$reportNull$$$0(1);
                }
                return editorEx;
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 250) {
                    size.height = 250;
                }
                return size;
            }

            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onEditorAdded";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "updateBorder";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.myRegExp.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Editor editor = CheckRegExpForm.this.myRegExp.getEditor();
                if (editor == null) {
                    return;
                }
                int offset = editor.getCaretModel().getOffset();
                CheckRegExpForm.this.highlightRegExpGroup(offset, regExpFile);
            }
        });
        CheckRegExpForm.setupIcon(this.myRegExp, (JComponent)this.myRegExpIcon);
        String sampleText = PropertiesComponent.getInstance((Project)project).getValue(LAST_EDITED_REGEXP, RegExpBundle.message("checker.sample.text", new Object[0]));
        this.mySampleText = new EditorTextField(sampleText, project, (FileType)PlainTextFileType.INSTANCE){
            private final Disposable disposable;
            {
                super(arg0, arg1, arg2);
                this.disposable = Disposer.newDisposable();
            }

            protected void onEditorAdded(final @NotNull Editor editor) {
                if (editor == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.onEditorAdded(editor);
                editor.getCaretModel().addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int offset = editor.logicalPositionToOffset(event.getNewPosition());
                        CheckRegExpForm.this.highlightSampleGroup(offset, regExpFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/lang/regexp/intention/CheckRegExpForm$3$1", "caretPositionChanged"));
                    }
                }, this.disposable);
            }

            public void removeNotify() {
                super.removeNotify();
                CheckRegExpForm.this.removeHighlights(HighlightManager.getInstance((Project)regExpFile.getProject()));
                Disposer.dispose((Disposable)this.disposable);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                EditorEx editorEx = editor;
                if (editorEx == null) {
                    3.$$$reportNull$$$0(1);
                }
                return editorEx;
            }

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (size.height > 250) {
                    size.height = 250;
                }
                return size;
            }

            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    3.$$$reportNull$$$0(2);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onEditorAdded";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "updateBorder";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.mySampleText.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Editor editor = CheckRegExpForm.this.mySampleText.getEditor();
                if (editor == null) {
                    return;
                }
                int offset = editor.getCaretModel().getOffset();
                ApplicationManager.getApplication().invokeLater(() -> CheckRegExpForm.this.highlightSampleGroup(offset, regExpFile));
            }
        });
        CheckRegExpForm.setupIcon(this.mySampleText, (JComponent)this.mySampleIcon);
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUIScale.scale((int)250), this.myRegExp.getPreferredSize().width);
        this.myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new GridBagLayout()){
            private final Disposable disposable;
            private Alarm updater;
            {
                super(arg0);
                this.disposable = Disposer.newDisposable();
            }

            @Override
            public void addNotify() {
                super.addNotify();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)CheckRegExpForm.this.mySampleText, true);
                5.registerFocusShortcut((JComponent)CheckRegExpForm.this.myRegExp, "shift TAB", CheckRegExpForm.this.mySampleText);
                5.registerFocusShortcut((JComponent)CheckRegExpForm.this.myRegExp, "TAB", CheckRegExpForm.this.mySampleText);
                5.registerFocusShortcut((JComponent)CheckRegExpForm.this.mySampleText, "shift TAB", CheckRegExpForm.this.myRegExp);
                5.registerFocusShortcut((JComponent)CheckRegExpForm.this.mySampleText, "TAB", CheckRegExpForm.this.myRegExp);
                this.updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentListener documentListener = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.update();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$5$1", "documentChanged"));
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener(documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener(documentListener);
                this.update();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            private static void registerFocusShortcut(JComponent source, String shortcut, final EditorTextField target) {
                AnAction action = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        IdeFocusManager.findInstance().requestFocus((Component)target.getFocusTarget(), true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$5$2", "actionPerformed"));
                    }
                };
                action.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortcut}), source);
            }

            private void update() {
                CheckRegExpForm.this.myRootPanel.revalidate();
                Balloon balloon = JBPopupFactory.getInstance().getParentBalloonFor((Component)CheckRegExpForm.this.myRootPanel);
                if (balloon != null && !balloon.isDisposed()) {
                    balloon.revalidate();
                }
                this.updater.cancelAllRequests();
                if (!this.updater.isDisposed()) {
                    this.updater.addRequest(() -> {
                        RegExpMatchResult result = CheckRegExpForm.isMatchingText(regExpFile, CheckRegExpForm.this.myRegExp.getText(), CheckRegExpForm.this.mySampleText.getText());
                        regExpFile.putUserData(RESULT, (Object)result);
                        if (result != RegExpMatchResult.MATCHES && result != RegExpMatchResult.FOUND) {
                            CheckRegExpForm.setMatches(regExpFile, null);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> CheckRegExpForm.this.reportResult(result, regExpFile), ModalityState.any(), __ -> this.updater.isDisposed());
                    }, 0);
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)project).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insets((int)2, (int)5);
        c.gridx = 0;
        c.gridy = 0;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.regexp", new Object[0]), (JComponent)this.myRegExp), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)this.myRegExp, c);
        c.gridx = 0;
        ++c.gridy;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.sample", new Object[0]), (JComponent)this.mySampleText), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)this.mySampleText, c);
    }

    private void highlightSampleGroup(int offset, @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(1);
        }
        ReadAction.run(() -> {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
            this.removeHighlights(highlightManager);
            List<RegExpMatch> matches = CheckRegExpForm.getMatches(regExpFile);
            int index = CheckRegExpForm.indexOfGroupAtOffset(matches, offset);
            if (index > 0) {
                @Nullable RegExpGroup group = (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)regExpFile).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).get(index - 1);
                this.highlightRegExpGroup(group, highlightManager);
                this.highlightMatchGroup(highlightManager, matches, index);
            } else {
                this.highlightMatchGroup(highlightManager, matches, 0);
            }
        });
    }

    private void highlightRegExpGroup(int offset, @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(2);
        }
        ReadAction.run(() -> {
            RegExpGroup group = CheckRegExpForm.findCapturingGroupAtOffset(regExpFile, offset);
            HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
            this.removeHighlights(highlightManager);
            if (group != null) {
                int index = SyntaxTraverser.psiTraverser((PsiElement)regExpFile).filter(RegExpGroup.class).indexOf(e -> e == group) + 1;
                this.highlightRegExpGroup(group, highlightManager);
                this.highlightMatchGroup(highlightManager, CheckRegExpForm.getMatches(regExpFile), index);
            } else {
                this.highlightMatchGroup(highlightManager, CheckRegExpForm.getMatches(regExpFile), 0);
            }
        });
    }

    private static int indexOfGroupAtOffset(List<RegExpMatch> matches, int offset) {
        int index = -1;
        block0: for (RegExpMatch match : matches) {
            int count = match.count();
            for (int i = 0; i < count; ++i) {
                int start = match.start(i);
                if (start <= offset && match.end(i) >= offset) {
                    index = i;
                    continue;
                }
                if (start > offset) continue block0;
            }
        }
        return index;
    }

    private static RegExpGroup findCapturingGroupAtOffset(@NotNull PsiFile regExpFile, int offset) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(3);
        }
        RegExpGroup group = null;
        for (PsiElement element = regExpFile.findElementAt(offset); element != null; element = element.getParent()) {
            RegExpGroup g;
            if (!(element instanceof RegExpGroup) || !(g = (RegExpGroup)element).isCapturing()) continue;
            group = g;
            break;
        }
        return group;
    }

    private void highlightMatchGroup(HighlightManager highlightManager, List<RegExpMatch> matches, int group) {
        Editor editor = this.mySampleText.getEditor();
        if (editor == null) {
            return;
        }
        for (RegExpMatch match : matches) {
            int start = match.start(group);
            int end = match.end(group);
            if (start < 0 || end < 0 || group == 0 && start == 0 && end == this.mySampleText.getText().length()) continue;
            highlightManager.addRangeHighlight(editor, start, end, RegExpHighlighter.MATCHED_GROUPS, true, this.mySampleHighlights);
        }
    }

    private void highlightRegExpGroup(RegExpGroup group, HighlightManager highlightManager) {
        Editor editor = this.myRegExp.getEditor();
        if (editor == null) {
            return;
        }
        PsiElement[] array = new PsiElement[]{group};
        SmartList highlighter = new SmartList();
        highlightManager.addOccurrenceHighlights(editor, array, RegExpHighlighter.MATCHED_GROUPS, true, (Collection)highlighter);
        this.myRegExpHighlight = (RangeHighlighter)highlighter.getFirst();
    }

    private void removeHighlights(HighlightManager highlightManager) {
        Editor sampleEditor = this.mySampleText.getEditor();
        if (sampleEditor != null) {
            for (RangeHighlighter highlighter : this.mySampleHighlights) {
                highlightManager.removeSegmentHighlighter(sampleEditor, highlighter);
            }
            this.mySampleHighlights.clear();
        }
        Editor regExpEditor = this.myRegExp.getEditor();
        if (this.myRegExpHighlight != null && regExpEditor != null) {
            highlightManager.removeSegmentHighlighter(regExpEditor, this.myRegExpHighlight);
            this.myRegExpHighlight = null;
        }
    }

    private static JLabel createLabel(@NlsContexts.Label @NotNull String labelText, @NotNull JComponent component) {
        if (labelText == null) {
            CheckRegExpForm.$$$reportNull$$$0(4);
        }
        if (component == null) {
            CheckRegExpForm.$$$reportNull$$$0(5);
        }
        JLabel label = new JLabel(UIUtil.removeMnemonic((String)labelText));
        int index = UIUtil.getDisplayMnemonicIndex((String)labelText);
        if (index != -1) {
            label.setDisplayedMnemonic(labelText.charAt(index + 1));
            label.setDisplayedMnemonicIndex(index);
        }
        label.setLabelFor(component);
        return label;
    }

    private static void setupIcon(@NotNull EditorTextField field, @NotNull JComponent icon) {
        if (field == null) {
            CheckRegExpForm.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            CheckRegExpForm.$$$reportNull$$$0(7);
        }
        field.addSettingsProvider(editor -> {
            icon.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(22);
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setBackground(editor.getBackgroundColor());
            verticalScrollBar.add("JB_SCROLL_BAR_LEADING_COMPONENT", icon);
            verticalScrollBar.setOpaque(true);
        });
    }

    private void reportResult(RegExpMatchResult result, @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(8);
        }
        switch (result) {
            case NO_MATCH: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.no.match", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case MATCHES: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.matches", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                Editor editor = this.mySampleText.getEditor();
                if (editor == null) break;
                HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
                this.removeHighlights(highlightManager);
                break;
            }
            case FOUND: {
                List<RegExpMatch> matches = CheckRegExpForm.getMatches(regExpFile);
                Editor editor = this.mySampleText.getEditor();
                if (editor != null) {
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
                    this.removeHighlights(highlightManager);
                    this.highlightMatchGroup(highlightManager, matches, 0);
                }
                if (matches.size() > 1) {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found.multiple", matches.size()));
                } else {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found", new Object[0]));
                }
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case INCOMPLETE: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.more.input.expected", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case BAD_REGEXP: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.bad.pattern", new Object[0]));
                break;
            }
            case TIMEOUT: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.pattern.is.too.complex", new Object[0]));
            }
        }
    }

    private static void setIconAndTooltip(JBLabel label, Icon icon, @NlsContexts.Tooltip String tooltip) {
        label.setIcon(icon);
        label.setToolTipText(tooltip);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            CheckRegExpForm.$$$reportNull$$$0(9);
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            CheckRegExpForm.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RegExpMatch> getMatches(@NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(11);
        }
        List list = (List)ObjectUtils.notNull((Object)((List)regExpFile.getUserData(LATEST_MATCHES)), Collections.emptyList());
        if (list == null) {
            CheckRegExpForm.$$$reportNull$$$0(12);
        }
        return list;
    }

    public static void setMatches(@NotNull PsiFile regExpFile, @Nullable List<RegExpMatch> matches) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(13);
        }
        regExpFile.putUserData(LATEST_MATCHES, matches);
    }

    @TestOnly
    public static boolean isMatchingTextTest(@NotNull PsiFile regExpFile, @NotNull String sampleText) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(14);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(15);
        }
        return CheckRegExpForm.getMatchResult(regExpFile, sampleText) == RegExpMatchResult.MATCHES;
    }

    @TestOnly
    public static RegExpMatchResult getMatchResult(@NotNull PsiFile regExpFile, @NotNull String sampleText) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(16);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(17);
        }
        return CheckRegExpForm.isMatchingText(regExpFile, regExpFile.getText(), sampleText);
    }

    private static RegExpMatchResult isMatchingText(@NotNull PsiFile regExpFile, String regExpText, @NotNull String sampleText) {
        RegExpMatchResult result;
        Language regExpFileLanguage;
        RegExpMatcherProvider matcherProvider;
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(18);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(19);
        }
        if ((matcherProvider = (RegExpMatcherProvider)RegExpMatcherProvider.EP.forLanguage(regExpFileLanguage = regExpFile.getLanguage())) != null && (result = (RegExpMatchResult)((Object)ReadAction.compute(() -> {
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)regExpFile.getProject()).getInjectionHost((PsiElement)regExpFile);
            return host != null ? matcherProvider.matches(regExpText, regExpFile, (PsiElement)host, sampleText, 1000L) : null;
        }))) != null) {
            return result;
        }
        Integer patternFlags = (Integer)ReadAction.compute(() -> {
            int flags;
            block1: {
                RegExpModifierProvider provider;
                PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)regExpFile.getProject()).getInjectionHost((PsiElement)regExpFile);
                flags = 0;
                if (host == null) break block1;
                Iterator iterator = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                while (iterator.hasNext() && (flags = (provider = (RegExpModifierProvider)iterator.next()).getFlags((PsiElement)host, regExpFile)) <= 0) {
                }
            }
            return flags;
        });
        try {
            Matcher matcher = Pattern.compile(regExpText, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L));
            if (matcher.matches()) {
                CheckRegExpForm.setMatches(regExpFile, CheckRegExpForm.collectMatches(matcher));
                return RegExpMatchResult.MATCHES;
            }
            boolean hitEnd = matcher.hitEnd();
            matcher.reset();
            if (matcher.find()) {
                CheckRegExpForm.setMatches(regExpFile, CheckRegExpForm.collectMatches(matcher));
                return RegExpMatchResult.FOUND;
            }
            if (hitEnd) {
                return RegExpMatchResult.INCOMPLETE;
            }
            return RegExpMatchResult.NO_MATCH;
        }
        catch (ProcessCanceledException ignore) {
            return RegExpMatchResult.TIMEOUT;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return RegExpMatchResult.BAD_REGEXP;
        }
    }

    private static List<RegExpMatch> collectMatches(Matcher matcher) {
        SmartList matches = new SmartList();
        do {
            RegExpMatch match = new RegExpMatch();
            int count = matcher.groupCount();
            for (int i = 0; i <= count; ++i) {
                match.add(matcher.start(i), matcher.end(i));
            }
            matches.add(match);
        } while (matcher.find());
        return matches;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regExpFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightSampleGroup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlightRegExpGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCapturingGroupAtOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportResult";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMatches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMatches";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingTextTest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMatchResult";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12 -> new IllegalStateException(string);
        };
    }

    public static final class Keys {
        public static final Key<Boolean> CHECK_REG_EXP_EDITOR = Key.create((String)"CHECK_REG_EXP_EDITOR");
    }
}

