/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH&J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H&J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0014H\u0002J8\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0&2\u0006\u0010\"\u001a\u00020\u00142\u0010\b\u0002\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/intellij/micronaut/config/MnConfigFileContributor;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "findKey", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "findMatchingKeys", "", "prefix", "getKeyVariants", "Lcom/intellij/codeInsight/lookup/LookupElement;", "processConfigValues", "", "params", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "findConfigFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "getConfigFileSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "testScope", "collectConfigDirectories", "", "configDirectories", "", "visitedModules", "Companion", "intellij.micronaut"})
public abstract class MnConfigFileContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileType fileType;
    @NotNull
    private static final ExtensionPointName<MnConfigFileContributor> EP_NAME = ExtensionPointName.Companion.create("com.intellij.micronaut.configFileContributor");

    public MnConfigFileContributor(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @Nullable
    public abstract PsiElement findKey(@NotNull PsiFile var1, @NotNull String var2);

    @NotNull
    public abstract Collection<PsiElement> findMatchingKeys(@NotNull PsiFile var1, @NotNull String var2);

    @NotNull
    public abstract Collection<LookupElement> getKeyVariants(@NotNull PsiFile var1);

    public abstract boolean processConfigValues(@NotNull MnConfigValueSearcher.MnConfigValueSearchParams var1, @NotNull Processor<? super MnConfigValueSearcher.MnConfigValueResult> var2);

    @NotNull
    public final List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalSearchScope globalSearchScope = this.getConfigFileSearchScope(module, includeTests);
        if (globalSearchScope == null) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope configFileSearchScope = globalSearchScope;
        SmartList result = new SmartList();
        CommonProcessors.CollectProcessor<VirtualFile> processor2 = new CommonProcessors.CollectProcessor<VirtualFile>((SmartList<VirtualFile>)result){

            protected boolean accept(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProgressManager.checkCanceled();
                String string = file.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                return MnConfigUtilsKt.isMicronautConfigFileName(string);
            }
        };
        FileTypeIndex.processFiles((FileType)this.fileType, (Processor)((Processor)processor2), (GlobalSearchScope)configFileSearchScope);
        return (List)result;
    }

    private final GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        GlobalSearchScope globalSearchScope;
        if (module.isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return module.getModuleScope(testScope);
        }
        LinkedHashSet configDirectories = new LinkedHashSet();
        MnConfigFileContributor.collectConfigDirectories$default(this, module, configDirectories, testScope, null, 8, null);
        if (configDirectories.isEmpty()) {
            globalSearchScope = null;
        } else {
            VirtualFile[] virtualFileArray = configDirectories.toArray(VirtualFile.EMPTY_ARRAY);
            globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }
        return globalSearchScope;
    }

    private final void collectConfigDirectories(Module module, Set<VirtualFile> configDirectories, boolean testScope, Set<? super Module> visitedModules) {
        if (visitedModules.contains(module)) {
            return;
        }
        visitedModules.add((Module)module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"getInstance(...)");
        ModuleRootManager moduleRootManager2 = moduleRootManager;
        List list = moduleRootManager2.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        configDirectories.addAll(list);
        Module[] moduleArray = moduleRootManager2.getDependencies(testScope);
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getDependencies(...)");
        for (Module dependentModule : moduleArray) {
            Intrinsics.checkNotNull((Object)dependentModule);
            this.collectConfigDirectories(dependentModule, configDirectories, testScope, visitedModules);
        }
    }

    static /* synthetic */ void collectConfigDirectories$default(MnConfigFileContributor mnConfigFileContributor, Module module, Set set, boolean bl, Set set2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectConfigDirectories");
        }
        if ((n & 8) != 0) {
            set2 = new HashSet();
        }
        mnConfigFileContributor.collectConfigDirectories(module, set, bl, set2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/micronaut/config/MnConfigFileContributor$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "findConfigFiles", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "includeTests", "", "activeEnvironments", "", "", "getEnvironment", "configFileName", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnConfigFileContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnConfigFileContributor.kt\ncom/intellij/micronaut/config/MnConfigFileContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n777#2:143\n873#2,2:144\n1586#2:146\n1661#2,3:147\n*S KotlinDebug\n*F\n+ 1 MnConfigFileContributor.kt\ncom/intellij/micronaut/config/MnConfigFileContributor$Companion\n*L\n33#1:143\n33#1:144,2\n46#1:146\n46#1:147,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<MnConfigFileContributor> getEP_NAME() {
            return EP_NAME;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<VirtualFile, MnConfigFileContributor>> findConfigFiles(@NotNull Module module, boolean includeTests, @NotNull Set<String> activeEnvironments) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(activeEnvironments, (String)"activeEnvironments");
            SmartList result = new SmartList();
            List extensionList = this.getEP_NAME().getExtensionList();
            for (MnConfigFileContributor contributor : extensionList) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                VirtualFile it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = contributor.findConfigFiles(module, includeTests);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    String fileName;
                    it = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getNameWithoutExtension(), (String)"getNameWithoutExtension(...)");
                    if (Intrinsics.areEqual((Object)fileName, (Object)"application") || Intrinsics.areEqual((Object)fileName, (Object)"bootstrap")) {
                        bl = true;
                    } else if (fileName.length() <= 12 && fileName.length() <= 10) {
                        bl = false;
                    } else {
                        String environment = Companion.getEnvironment(fileName);
                        bl = activeEnvironments.contains(environment);
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List configFiles = (List)destination$iv$iv;
                $this$filter$iv = configFiles;
                SmartList smartList = result;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new Pair((Object)it, (Object)contributor));
                }
                smartList.addAll((Collection)((List)destination$iv$iv));
            }
            List activeEnvironmentsList = CollectionsKt.toList((Iterable)activeEnvironments);
            Collections.sort((List)result, (arg_0, arg_1) -> Companion.findConfigFiles$lambda$2(extensionList, activeEnvironmentsList, arg_0, arg_1));
            return (List)result;
        }

        private final String getEnvironment(String configFileName) {
            return StringsKt.startsWith$default((String)configFileName, (String)"application-", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)configFileName, (CharSequence)"application-") : (StringsKt.startsWith$default((String)configFileName, (String)"bootstrap-", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)configFileName, (CharSequence)"bootstrap-") : configFileName);
        }

        private static final int findConfigFiles$lambda$2(List $extensionList, List $activeEnvironmentsList, Pair p1, Pair p2) {
            String string = ((VirtualFile)p1.getFirst()).getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String fileName1 = string;
            String string2 = ((VirtualFile)p2.getFirst()).getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
            String fileName2 = string2;
            if (Intrinsics.areEqual((Object)fileName1, (Object)fileName2)) {
                return $extensionList.indexOf(p1.getSecond()) - $extensionList.indexOf(p2.getSecond());
            }
            if (Intrinsics.areEqual((Object)fileName1, (Object)"application")) {
                return 1;
            }
            if (Intrinsics.areEqual((Object)fileName2, (Object)"application")) {
                return -1;
            }
            if (StringsKt.startsWith$default((String)fileName1, (String)"application-", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)fileName2, (String)"application-", (boolean)false, (int)2, null)) {
                String env1 = Companion.getEnvironment(fileName1);
                String env2 = Companion.getEnvironment(fileName2);
                return $activeEnvironmentsList.indexOf(env2) - $activeEnvironmentsList.indexOf(env1);
            }
            if (StringsKt.startsWith$default((String)fileName1, (String)"application-", (boolean)false, (int)2, null)) {
                return 1;
            }
            if (StringsKt.startsWith$default((String)fileName2, (String)"application-", (boolean)false, (int)2, null)) {
                return -1;
            }
            if (Intrinsics.areEqual((Object)fileName1, (Object)"bootstrap")) {
                return 1;
            }
            if (Intrinsics.areEqual((Object)fileName2, (Object)"bootstrap")) {
                return -1;
            }
            String env1 = Companion.getEnvironment(fileName1);
            String env2 = Companion.getEnvironment(fileName2);
            return $activeEnvironmentsList.indexOf(env2) - $activeEnvironmentsList.indexOf(env1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

