/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.oas;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.oas.converters.MnOasConvertersKt;
import com.intellij.microservices.oas.OasExportUtilsKt;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.swagger.core.synthetic.OasSerializationUtilsKt;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/micronaut/oas/MicronautGenerateOASUrlInlayAction;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "urlPathInlayHint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "actionPerformed", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "urlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "mouseEvent", "Ljava/awt/event/MouseEvent;", "getMappingElement", "Lorg/jetbrains/uast/UElement;", "intellij.micronaut.oas"})
public final class MicronautGenerateOASUrlInlayAction
implements UrlPathInlayAction {
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Webreferences.Openapi;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Openapi");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("action.export.openapi.draft", new Object[0]);
    }

    public boolean isAvailable(@NotNull PsiFile file, @NotNull UrlPathInlayHint urlPathInlayHint) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"urlPathInlayHint");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!MicronautUtils.hasMicronautLibrary(module2)) {
            return false;
        }
        SmartPsiElementPointer smartPsiElementPointer = urlPathInlayHint.getAttachedTo();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null), PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass2), (String)"io.micronaut.http.annotation.Controller", (int)0) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass2), (Collection)CollectionsKt.listOf((Object)"io.micronaut.http.annotation.Controller"));
    }

    public void actionPerformed(@NotNull PsiFile file, @NotNull Editor editor, @NotNull UrlPathContext urlPathContext, @NotNull MouseEvent mouseEvent) {
        List<OpenApiSpecification> list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)urlPathContext, (String)"urlPathContext");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return;
        }
        Module module2 = module;
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTION_TRIGGERED_EVENT().log(module2.getProject(), (Object)"generate_openapi");
        UElement mappingUElement = this.getMappingElement(file, editor);
        if (mappingUElement instanceof UMethod) {
            list = CollectionsKt.listOf((Object)MnOasConvertersKt.getMethodOpenApiSpecification((UMethod)mappingUElement));
        } else if (mappingUElement instanceof UClass) {
            list = MnOasConvertersKt.getClassOpenApiSpecifications((UClass)mappingUElement);
        } else {
            return;
        }
        List openApiSpecifications = CollectionsKt.filterNotNull((Iterable)list);
        OpenApiSpecification openApiSpecification = OasExportUtilsKt.squashOpenApiSpecifications((List)openApiSpecifications);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OasSerializationUtilsKt.exportOasDraft((OpenApiSpecification)openApiSpecification, (Project)project);
    }

    private final UElement getMappingElement(PsiFile file, Editor editor) {
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        Class[] classArray = new Class[]{UMethod.class, UClass.class};
        return UastContextKt.getUastParentOfTypes$default((PsiElement)psiElement2, (Class[])classArray, (boolean)false, (int)2, null);
    }
}

