/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontFamilyDescriptor;
import com.intellij.util.ui.FontInfo;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFamilyService {
    private static final String MAIN_FALLBACK_SUB_FAMILY = "Regular";
    private static final String BOLD_FALLBACK_SUB_FAMILY = "Bold";

    public static boolean isServiceSupported() {
        return FontFamilyService.getInstance().isSupportedImpl();
    }

    @NotNull
    public static List<String> getAvailableFamilies() {
        List<String> list2 = FontFamilyService.getInstance().getAvailableFamiliesImpl();
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public static boolean isMonospaced(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(1);
        }
        return FontFamilyService.getInstance().isMonospacedImpl(family);
    }

    @NotNull
    public static @NotNull List<@NotNull String> getSubFamilies(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(2);
        }
        List<String> list2 = FontFamilyService.getInstance().getSubFamiliesImpl(family);
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public static String getRecommendedSubFamily(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(4);
        }
        String string = FontFamilyService.getInstance().getRecommendedSubFamilyImpl(family);
        if (string == null) {
            FontFamilyService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getRecommendedBoldSubFamily(@NotNull String family, @NotNull String mainSubFamily) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(6);
        }
        if (mainSubFamily == null) {
            FontFamilyService.$$$reportNull$$$0(7);
        }
        String string = FontFamilyService.getInstance().getRecommendedBoldSubFamilyImpl(family, mainSubFamily);
        if (string == null) {
            FontFamilyService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(9);
        }
        Font font = FontFamilyService.getInstance().getFontImpl(family, regularSubFamily, boldSubFamily, style);
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(10);
        }
        return font;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style, int size) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(11);
        }
        return FontFamilyService.getFont(family, regularSubFamily, boldSubFamily, style, (float)size);
    }

    @NotNull
    public static Font getFont(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style, float size) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(12);
        }
        Font font = FontFamilyService.getFont(family, regularSubFamily, boldSubFamily, style).deriveFont(size);
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(13);
        }
        return font;
    }

    @NotNull
    public static Font getFont(@NotNull String family, @NotNull String subFamily, int size) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(14);
        }
        if (subFamily == null) {
            FontFamilyService.$$$reportNull$$$0(15);
        }
        return FontFamilyService.getFont(family, subFamily, subFamily, 0, size);
    }

    @NotNull
    public static Font getFont(@NotNull String family, @NotNull String subFamily, float size) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(16);
        }
        if (subFamily == null) {
            FontFamilyService.$$$reportNull$$$0(17);
        }
        return FontFamilyService.getFont(family, subFamily, subFamily, 0, size);
    }

    @Nullable
    public static FontFamilyDescriptor getDescriptorByFont(@NotNull Font font) {
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(18);
        }
        return FontFamilyService.getInstance().getDescriptorByFontImpl(font);
    }

    @Nullable
    public static Font getFontByDescriptor(@NotNull FontFamilyDescriptor descriptor) {
        if (descriptor == null) {
            FontFamilyService.$$$reportNull$$$0(19);
        }
        return FontFamilyService.getInstance().getFontByDescriptorImpl(descriptor);
    }

    public static String @NotNull [] migrateFontSetting(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(20);
        }
        String[] stringArray = FontFamilyService.getInstance().migrateFontSettingImpl(family);
        if (stringArray == null) {
            FontFamilyService.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @NotNull
    private static FontFamilyService getInstance() {
        Application application = ApplicationManager.getApplication();
        FontFamilyService instance = application != null ? (FontFamilyService)application.getService(FontFamilyService.class) : null;
        FontFamilyService fontFamilyService = instance == null ? new FontFamilyService() : instance;
        if (fontFamilyService == null) {
            FontFamilyService.$$$reportNull$$$0(22);
        }
        return fontFamilyService;
    }

    protected boolean isSupportedImpl() {
        return false;
    }

    @NotNull
    protected List<String> getAvailableFamiliesImpl() {
        List<String> list2 = List.of(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH));
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(23);
        }
        return list2;
    }

    protected boolean isMonospacedImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(24);
        }
        return FontInfo.isMonospacedWithStyles((Font)new Font(family, 0, EditorFontsConstants.getDefaultEditorFontSize()));
    }

    @NotNull
    protected @NotNull List<@NotNull String> getSubFamiliesImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(25);
        }
        List<String> list2 = List.of(MAIN_FALLBACK_SUB_FAMILY, BOLD_FALLBACK_SUB_FAMILY);
        if (list2 == null) {
            FontFamilyService.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    protected String getRecommendedSubFamilyImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(27);
        }
        return MAIN_FALLBACK_SUB_FAMILY;
    }

    @NotNull
    protected String getRecommendedBoldSubFamilyImpl(@NotNull String family, @NotNull String mainSubFamily) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(28);
        }
        if (mainSubFamily == null) {
            FontFamilyService.$$$reportNull$$$0(29);
        }
        return BOLD_FALLBACK_SUB_FAMILY;
    }

    @NotNull
    protected Font getFontImpl(@NotNull String family, @Nullable String regularSubFamily, @Nullable String boldSubFamily, @JdkConstants.FontStyle int style) {
        Font font;
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(30);
        }
        if ((font = new Font(family, style, 1)).getFamily().equals("Dialog") && !FontFamilyService.isDialogFamily(family)) {
            return new Font(FontPreferences.DEFAULT_FONT_NAME, style, 1);
        }
        Font font2 = font;
        if (font2 == null) {
            FontFamilyService.$$$reportNull$$$0(31);
        }
        return font2;
    }

    private static boolean isDialogFamily(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(32);
        }
        if (family.equals("Dialog")) {
            return true;
        }
        return family.startsWith("Dialog") && family.charAt("Dialog".length()) == '.';
    }

    @Nullable
    protected FontFamilyDescriptor getDescriptorByFontImpl(@NotNull Font font) {
        if (font == null) {
            FontFamilyService.$$$reportNull$$$0(33);
        }
        return null;
    }

    @Nullable
    protected Font getFontByDescriptorImpl(@NotNull FontFamilyDescriptor descriptor) {
        if (descriptor == null) {
            FontFamilyService.$$$reportNull$$$0(34);
        }
        return null;
    }

    protected String @NotNull [] migrateFontSettingImpl(@NotNull String family) {
        if (family == null) {
            FontFamilyService.$$$reportNull$$$0(35);
        }
        String[] stringArray = new String[]{family, null, null};
        if (stringArray == null) {
            FontFamilyService.$$$reportNull$$$0(36);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 7, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20, 24, 25, 27, 28, 29, 30, 32, 33, 34, 35 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FontFamilyService";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainSubFamily";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subFamily";
                break;
            }
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFamilies";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FontFamilyService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFamilies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedSubFamily";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedBoldSubFamily";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateFontSetting";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFamiliesImpl";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFamiliesImpl";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontImpl";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateFontSettingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMonospaced";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubFamilies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedSubFamily";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedBoldSubFamily";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorByFont";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFontByDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "migrateFontSetting";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isMonospacedImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSubFamiliesImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedSubFamilyImpl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRecommendedBoldSubFamilyImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFontImpl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDialogFamily";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorByFontImpl";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFontByDescriptorImpl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "migrateFontSettingImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 7, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20, 24, 25, 27, 28, 29, 30, 32, 33, 34, 35 -> new IllegalArgumentException(string);
        };
    }
}

