/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesManualRunOnly;", "", "<init>", "()V", "communityRootFromWorkingDirectory", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "getCommunityRootFromWorkingDirectory$annotations", "getCommunityRootFromWorkingDirectory", "()Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
public final class BuildDependenciesManualRunOnly {
    @NotNull
    public static final BuildDependenciesManualRunOnly INSTANCE = new BuildDependenciesManualRunOnly();

    private BuildDependenciesManualRunOnly() {
    }

    @NotNull
    public static final BuildDependenciesCommunityRoot getCommunityRootFromWorkingDirectory() {
        Path workingDirectory;
        Path current = workingDirectory = Paths.get(System.getProperty("user.dir"), new String[0]);
        while (current.getParent() != null) {
            Object[] objectArray = new String[]{".", "community", "ultimate/community"};
            for (String pathCandidate : CollectionsKt.mutableListOf((Object[])objectArray)) {
                Path probeFile = current.resolve(pathCandidate).resolve("intellij.idea.community.main.iml").normalize();
                if (!Files.exists(probeFile, new LinkOption[0])) continue;
                Path path = probeFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                return new BuildDependenciesCommunityRoot(path);
            }
            current = current.getParent();
        }
        throw new IllegalStateException("IDEA Community root was not found from current working directory " + workingDirectory);
    }

    @JvmStatic
    public static /* synthetic */ void getCommunityRootFromWorkingDirectory$annotations() {
    }
}

