/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters.meters;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "<init>", "()V", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "Companion", "intellij.platform.diagnostic.telemetry.exporters"})
@SourceDebugExtension(value={"SMAP\nOpenTelemetryMetersJsonImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetryMetersJsonImporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1586#2:141\n1661#2,2:142\n1586#2:144\n1661#2,3:145\n1586#2:148\n1661#2,3:149\n1663#2:152\n*S KotlinDebug\n*F\n+ 1 OpenTelemetryMetersJsonImporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer\n*L\n115#1:141\n115#1:142,2\n123#1:144\n123#1:145,3\n124#1:148\n124#1:149,3\n115#1:152\n*E\n"})
public final class MetricDataDeserializer
extends JsonDeserializer<MetricData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Resource emptyResource = Resource.empty();
    private static final InstrumentationScopeInfo emptyInstrumentationScope = InstrumentationScopeInfo.empty();

    @NotNull
    public MetricData deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
        JsonNode node = (JsonNode)treeNode;
        String name = node.get("name").asText();
        String type = node.get("type").asText();
        String unit = node.get("unit").asText();
        String description = node.get("description").asText();
        JsonNode data = node.get("data");
        JsonNode points = data.get("points");
        Intrinsics.checkNotNull((Object)type);
        return switch (WhenMappings.$EnumSwitchMapping$0[MetricDataType.valueOf((String)type).ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)points);
                List longPoints = MetricDataDeserializer.Companion.getLongPointsData(points);
                Intrinsics.checkNotNull((Object)data);
                ImmutableSumData sumData = ImmutableSumData.create((boolean)MetricDataDeserializer.Companion.getIsMonotonic(data), (AggregationTemporality)MetricDataDeserializer.Companion.getAggregationTemporality(data), (Collection)longPoints);
                MetricData var10_20 = ImmutableMetricData.createLongSum((Resource)emptyResource, (InstrumentationScopeInfo)emptyInstrumentationScope, (String)name, (String)description, (String)unit, (SumData)((SumData)sumData));
                Intrinsics.checkNotNull((Object)var10_20);
                yield var10_20;
            }
            case 2 -> {
                Intrinsics.checkNotNull((Object)points);
                List doublePoints = MetricDataDeserializer.Companion.getDoublePointsData(points);
                Intrinsics.checkNotNull((Object)data);
                ImmutableSumData sumData = ImmutableSumData.create((boolean)MetricDataDeserializer.Companion.getIsMonotonic(data), (AggregationTemporality)MetricDataDeserializer.Companion.getAggregationTemporality(data), (Collection)doublePoints);
                MetricData var10_21 = ImmutableMetricData.createDoubleSum((Resource)emptyResource, (InstrumentationScopeInfo)emptyInstrumentationScope, (String)name, (String)description, (String)unit, (SumData)((SumData)sumData));
                Intrinsics.checkNotNull((Object)var10_21);
                yield var10_21;
            }
            case 3 -> {
                Intrinsics.checkNotNull((Object)points);
                List longPoints = MetricDataDeserializer.Companion.getLongPointsData(points);
                ImmutableGaugeData gaugeData = ImmutableGaugeData.create((Collection)longPoints);
                MetricData var10_22 = ImmutableMetricData.createLongGauge((Resource)emptyResource, (InstrumentationScopeInfo)emptyInstrumentationScope, (String)name, (String)description, (String)unit, (GaugeData)((GaugeData)gaugeData));
                Intrinsics.checkNotNull((Object)var10_22);
                yield var10_22;
            }
            case 4 -> {
                Intrinsics.checkNotNull((Object)points);
                List doublePoints = MetricDataDeserializer.Companion.getDoublePointsData(points);
                ImmutableGaugeData gaugeData = ImmutableGaugeData.create((Collection)doublePoints);
                MetricData var10_23 = ImmutableMetricData.createDoubleGauge((Resource)emptyResource, (InstrumentationScopeInfo)emptyInstrumentationScope, (String)name, (String)description, (String)unit, (GaugeData)((GaugeData)gaugeData));
                Intrinsics.checkNotNull((Object)var10_23);
                yield var10_23;
            }
            case 5 -> {
                String var10_24 = "Summary deserialization isn't supported yet";
                throw new NotImplementedError("An operation is not implemented: " + var10_24);
            }
            case 6 -> {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNull((Object)points);
                Iterable $this$map$iv = (Iterable)points;
                boolean $i$f$map = false;
                Iterable var14_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    Collection var40_53;
                    void $this$mapTo$iv$iv;
                    void dataPoint;
                    JsonNode var19_33 = (JsonNode)item$iv$iv;
                    Collection var44_58 = destination$iv$iv;
                    boolean $i$a$-map-MetricDataDeserializer$deserialize$pointsData$1 = false;
                    Intrinsics.checkNotNull((Object)dataPoint);
                    long startEpoch = MetricDataDeserializer.Companion.getStartEpoch((JsonNode)dataPoint);
                    long epoch = MetricDataDeserializer.Companion.getEpoch((JsonNode)dataPoint);
                    Attributes attributes = MetricDataDeserializer.Companion.getAttributes((JsonNode)dataPoint);
                    double max = dataPoint.get("max").asDouble(Double.POSITIVE_INFINITY);
                    double sum = dataPoint.get("sum").asDouble();
                    double min = dataPoint.get("min").asDouble(Double.NEGATIVE_INFINITY);
                    JsonNode v2 = dataPoint.get("counts");
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    Iterable $this$map$iv = (Iterable)v2;
                    boolean $i$f$map = false;
                    Iterable var34_45 = $this$map$iv;
                    Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsonNode var39_52 = (JsonNode)item$iv$iv;
                        var40_53 = destination$iv$iv;
                        boolean $i$a$-map-MetricDataDeserializer$deserialize$pointsData$1$counts$1 = false;
                        var40_53.add(it.asLong());
                    }
                    List counts = (List)destination$iv$iv;
                    JsonNode v3 = dataPoint.get("boundaries");
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
                    Iterable $this$map$iv = (Iterable)v3;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsonNode $i$a$-map-MetricDataDeserializer$deserialize$pointsData$1$counts$1 = (JsonNode)item$iv$iv;
                        var40_53 = destination$iv$iv;
                        boolean $i$a$-map-MetricDataDeserializer$deserialize$pointsData$1$boundaries$1 = false;
                        var40_53.add(it.asDouble());
                    }
                    List boundaries = (List)destination$iv$iv;
                    var44_58.add(ImmutableHistogramPointData.create((long)startEpoch, (long)epoch, (Attributes)attributes, (double)sum, (!(min == Double.NEGATIVE_INFINITY) ? 1 : 0) != 0, (double)min, (!(max == Double.POSITIVE_INFINITY) ? 1 : 0) != 0, (double)max, (List)boundaries, (List)counts));
                }
                List pointsData = (List)destination$iv$iv;
                Intrinsics.checkNotNull((Object)data);
                ImmutableHistogramData histogramData = ImmutableHistogramData.create((AggregationTemporality)MetricDataDeserializer.Companion.getAggregationTemporality(data), (Collection)pointsData);
                MetricData var10_25 = ImmutableMetricData.createDoubleHistogram((Resource)emptyResource, (InstrumentationScopeInfo)emptyInstrumentationScope, (String)name, (String)description, (String)unit, (HistogramData)((HistogramData)histogramData));
                Intrinsics.checkNotNull((Object)var10_25);
                yield var10_25;
            }
            case 7 -> {
                String var10_26 = "Exponential histogram isn't supported yet";
                throw new NotImplementedError("An operation is not implemented: " + var10_26);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer$Companion;", "", "<init>", "()V", "emptyResource", "Lio/opentelemetry/sdk/resources/Resource;", "kotlin.jvm.PlatformType", "emptyInstrumentationScope", "Lio/opentelemetry/sdk/common/InstrumentationScopeInfo;", "getIsMonotonic", "", "dataNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "getStartEpoch", "", "dataPointNode", "getEpoch", "getValue", "getAttributes", "Lio/opentelemetry/api/common/Attributes;", "getLongPointsData", "", "Lio/opentelemetry/sdk/metrics/data/LongPointData;", "pointsNode", "getDoublePointsData", "Lio/opentelemetry/sdk/metrics/data/DoublePointData;", "intellij.platform.diagnostic.telemetry.exporters"})
    @SourceDebugExtension(value={"SMAP\nOpenTelemetryMetersJsonImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetryMetersJsonImporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1915#2,2:141\n1586#2:143\n1661#2,3:144\n1586#2:147\n1661#2,3:148\n*S KotlinDebug\n*F\n+ 1 OpenTelemetryMetersJsonImporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/MetricDataDeserializer$Companion\n*L\n53#1:141,2\n56#1:143\n56#1:144,3\n65#1:147\n65#1:148,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getIsMonotonic(JsonNode dataNode) {
            return dataNode.get("monotonic").asBoolean(false);
        }

        private final AggregationTemporality getAggregationTemporality(JsonNode dataNode) {
            String string = dataNode.get("aggregationTemporality").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            return AggregationTemporality.valueOf((String)string);
        }

        private final long getStartEpoch(JsonNode dataPointNode) {
            return dataPointNode.get("startEpochNanos").asLong();
        }

        private final long getEpoch(JsonNode dataPointNode) {
            return dataPointNode.get("epochNanos").asLong();
        }

        private final JsonNode getValue(JsonNode dataPointNode) {
            JsonNode jsonNode = dataPointNode.get("value");
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"get(...)");
            return jsonNode;
        }

        private final Attributes getAttributes(JsonNode dataPointNode) {
            AttributesBuilder attributesBuilder;
            AttributesBuilder $this$getAttributes_u24lambda_u240 = attributesBuilder = Attributes.builder();
            boolean bl = false;
            Set set = dataPointNode.get("attributes").properties();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                $this$getAttributes_u24lambda_u240.put(((String)it.getKey()).toString(), ((JsonNode)it.getValue()).toString());
            }
            Attributes attributes = attributesBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"build(...)");
            return attributes;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LongPointData> getLongPointsData(JsonNode pointsNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)pointsNode;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dataPoint;
                JsonNode jsonNode = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)dataPoint);
                long startEpoch = Companion.getStartEpoch((JsonNode)dataPoint);
                long epoch = Companion.getEpoch((JsonNode)dataPoint);
                JsonNode value = Companion.getValue((JsonNode)dataPoint);
                Attributes attributes = Companion.getAttributes((JsonNode)dataPoint);
                collection.add(ImmutableLongPointData.create((long)startEpoch, (long)epoch, (Attributes)attributes, (long)value.asLong()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoublePointData> getDoublePointsData(JsonNode pointsNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)pointsNode;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dataPoint;
                JsonNode jsonNode = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)dataPoint);
                long startEpoch = Companion.getStartEpoch((JsonNode)dataPoint);
                long epoch = Companion.getEpoch((JsonNode)dataPoint);
                JsonNode value = Companion.getValue((JsonNode)dataPoint);
                Attributes attributes = Companion.getAttributes((JsonNode)dataPoint);
                collection.add(ImmutableDoublePointData.create((long)startEpoch, (long)epoch, (Attributes)attributes, (double)value.asDouble()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricDataType.values().length];
            try {
                nArray[MetricDataType.LONG_SUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_SUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.LONG_GAUGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_GAUGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.SUMMARY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.HISTOGRAM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.EXPONENTIAL_HISTOGRAM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

