/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.platform.vcs.impl.shared.changes.ChangeListsViewModel;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesViewDnDSupport;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDnDSupport;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "createDragStartBean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "info", "Lcom/intellij/ide/dnd/DnDActionInfo;", "canHandleDropEvent", "", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "dropNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "drop", "", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public class ChangesViewDnDSupport
extends ChangesTreeDnDSupport {
    public ChangesViewDnDSupport(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        super(tree);
    }

    @Override
    @Nullable
    protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info.isMove()) {
            List list = VcsTreeModelData.selected((JTree)((Object)this.myTree)).iterateUserObjects(Change.class).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List changes = list;
            List list2 = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myTree), ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
            List unversionedFiles = list2;
            List list3 = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myTree), ChangesBrowserNode.IGNORED_FILES_TAG).iterateUserObjects(FilePath.class).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"toList(...)");
            List ignoredFiles = list3;
            if (!(changes.isEmpty() && unversionedFiles.isEmpty() && ignoredFiles.isEmpty())) {
                return new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)((Object)this.myTree), changes, unversionedFiles, ignoredFiles));
            }
        }
        return null;
    }

    @Override
    protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @Nullable ChangesBrowserNode<?> dropNode) {
        Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ChangeListDragBean && dropNode != null) {
            ((ChangeListDragBean)attached).setTargetNode(dropNode);
            return ((ChangeListDragBean)attached).getSourceComponent() == this.myTree && dropNode.canAcceptDrop((ChangeListDragBean)attached);
        }
        return false;
    }

    public void drop(@NotNull DnDEvent aEvent) {
        ChangesBrowserNode changesBrowserNode;
        Intrinsics.checkNotNullParameter((Object)aEvent, (String)"aEvent");
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ChangeListDragBean && (changesBrowserNode = ((ChangeListDragBean)attached).getTargetNode()) != null) {
            Project project = this.myTree.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            changesBrowserNode.acceptDrop(ChangeListsViewModel.Companion.getInstance(project), (ChangeListDragBean)attached);
        }
    }
}

