/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedLineIndentProvider;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedLineIndentProvider;", "<init>", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "doGetLineIndent", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "isSuitableFor", "", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownListIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListIndentProvider.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListIndentProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,53:1\n66#2,2:54\n*S KotlinDebug\n*F\n+ 1 MarkdownListIndentProvider.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListIndentProvider\n*L\n43#1:54,2\n*E\n"})
public final class MarkdownListIndentProvider
extends FormatterBasedLineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor2, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getAdjustListIndentation()) {
            return null;
        }
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor2);
        MarkdownFile markdownFile = psiFile instanceof MarkdownFile ? (MarkdownFile)psiFile : null;
        if (markdownFile == null) {
            return null;
        }
        MarkdownFile file = markdownFile;
        String string = this.doGetLineIndent(editor2, file, offset);
        if (string == null) {
            string = super.getLineIndent(project, editor2, language, offset);
        }
        return string;
    }

    private final String doGetLineIndent(Editor editor2, MarkdownFile file, int offset) {
        MarkdownBlockQuote blockQuote;
        if (Intrinsics.areEqual((Object)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY), (Object)true)) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int prevLine = document2.getLineNumber(offset) - 1;
        MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAtLineSafely((PsiFile)file, prevLine, document2);
        if (markdownListItem == null && (markdownListItem = ListUtils.INSTANCE.getListItemAtLineSafely((PsiFile)file, prevLine - 1, document2)) == null) {
            return null;
        }
        MarkdownListItem listItem = markdownListItem;
        PsiElement psiElement = MarkdownPsiUtil.INSTANCE.findNonWhiteSpacePrevSibling((PsiFile)file, offset);
        if (psiElement != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            v3 = (MarkdownBlockQuote)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownBlockQuote.class, (boolean)true);
        } else {
            v3 = blockQuote = null;
        }
        if (blockQuote != null && PsiTreeUtilKt.isAncestor$default((PsiElement)((PsiElement)listItem), (PsiElement)((PsiElement)blockQuote), (boolean)false, (int)2, null)) {
            return null;
        }
        return "";
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof MarkdownLanguage;
    }
}

