/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.ExtensionsExternalFilesPathManager;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithDownloadableFiles;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ$\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\r\u001a\u00020\u0005J\u001d\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettingsUtil;", "", "<init>", "()V", "downloadExtensionFiles", "", "extension", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "downloadExtension", "enableAfterDownload", "belongsToTheProject", "path", "Ljava/nio/file/Path;", "belongsToTheProject$intellij_markdown", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMarkdownSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownSettingsUtil.kt\norg/intellij/plugins/markdown/settings/MarkdownSettingsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1642#2,10:72\n1915#2:82\n1916#2:85\n1652#2:86\n1#3:83\n1#3:84\n*S KotlinDebug\n*F\n+ 1 MarkdownSettingsUtil.kt\norg/intellij/plugins/markdown/settings/MarkdownSettingsUtil\n*L\n28#1:72,10\n28#1:82\n28#1:85\n28#1:86\n28#1:84\n*E\n"})
public final class MarkdownSettingsUtil {
    @NotNull
    public static final MarkdownSettingsUtil INSTANCE = new MarkdownSettingsUtil();

    private MarkdownSettingsUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean downloadExtensionFiles(@NotNull MarkdownExtensionWithDownloadableFiles extension, @Nullable Project project, @Nullable JComponent parentComponent) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        DownloadableFileService downloader = DownloadableFileService.getInstance();
        Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> $this$mapNotNull$iv = extension.getFilesToDownload();
        boolean $i$f$mapNotNull = false;
        Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DownloadableFileDescription downloadableFileDescription;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownExtensionWithDownloadableFiles.FileEntry entry = (MarkdownExtensionWithDownloadableFiles.FileEntry)element$iv$iv;
            boolean bl2 = false;
            if (entry.getLink().get() != null) {
                String it;
                boolean bl3 = false;
                downloadableFileDescription = downloader.createFileDescription(it, entry.getFilePath());
            } else {
                downloadableFileDescription = null;
            }
            if (downloadableFileDescription == null) continue;
            DownloadableFileDescription it$iv$iv = downloadableFileDescription;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List descriptions = (List)destination$iv$iv;
        ExtensionsExternalFilesPathManager.Companion.getInstance().cleanupExternalFiles(extension);
        Path directory = ExtensionsExternalFilesPathManager.Companion.obtainExternalFilesDirectoryPath(extension);
        FileDownloader fileDownloader = downloader.createDownloader(descriptions, "Downloading Extension Files");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        FileDownloader actualDownloader = fileDownloader;
        List files = actualDownloader.downloadFilesWithProgress(((Object)directory.toAbsolutePath()).toString(), project, parentComponent);
        return files != null;
    }

    public static /* synthetic */ boolean downloadExtensionFiles$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithDownloadableFiles markdownExtensionWithDownloadableFiles, Project project, JComponent jComponent, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            jComponent = null;
        }
        return markdownSettingsUtil.downloadExtensionFiles(markdownExtensionWithDownloadableFiles, project, jComponent);
    }

    public final boolean downloadExtension(@NotNull MarkdownExtensionWithDownloadableFiles extension, @Nullable Project project, boolean enableAfterDownload) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (extension.downloadFiles(project)) {
            if (enableAfterDownload) {
                MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().put(extension.getId(), true);
                ((MarkdownExtensionsSettings.ChangeListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(MarkdownExtensionsSettings.ChangeListener.TOPIC)).extensionsSettingsChanged(false);
            }
            String string = MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = MarkdownBundle.message("markdown.settings.download.extension.notification.success.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MarkdownNotifications.INSTANCE.showInfo(project, "markdown.extensions.download.success", string, string2);
            return true;
        }
        String string = MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string3 = MarkdownBundle.message("markdown.settings.download.extension.notification.failure.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        MarkdownNotifications.INSTANCE.showError(project, "markdown.extensions.download.failed", string, string3);
        return false;
    }

    public static /* synthetic */ boolean downloadExtension$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithDownloadableFiles markdownExtensionWithDownloadableFiles, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return markdownSettingsUtil.downloadExtension(markdownExtensionWithDownloadableFiles, project, bl);
    }

    @RequiresReadLock
    public final boolean belongsToTheProject$intellij_markdown(@NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return ProjectFileIndex.getInstance((Project)project).isInProjectOrExcluded(file);
    }
}

