/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl;

import com.intellij.openapi.project.Project;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.DfaLocalSession;
import com.intellij.rml.dfa.DfaSessionProvider;
import com.intellij.rml.dfa.DfaSummarySession;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.SinglePassAnalysisDescription;
import com.intellij.rml.dfa.impl.AnalysisRunner;
import com.intellij.rml.dfa.impl.DfaDebugExtension;
import com.intellij.rml.dfa.impl.DfaLocalSessionImpl;
import com.intellij.rml.dfa.impl.DfaSummarySessionImpl;
import com.intellij.rml.dfa.impl.DummyAnalysisRunner;
import com.intellij.rml.dfa.impl.legacy.AnalysisRunnerImpl;
import com.intellij.rml.dfa.utils.RMLOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/impl/DfaSessionProviderImpl;", "Lcom/intellij/rml/dfa/DfaSessionProvider;", "<init>", "()V", "createSession", "Lcom/intellij/rml/dfa/DfaLocalSession;", "analysisDescription", "Lcom/intellij/rml/dfa/RMLAnalysisDescription;", "project", "Lcom/intellij/openapi/project/Project;", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "createSummarySession", "Lcom/intellij/rml/dfa/DfaSummarySession;", "intellij.rml.dfa.impl"})
public final class DfaSessionProviderImpl
implements DfaSessionProvider {
    @NotNull
    public DfaLocalSession createSession(@NotNull RMLAnalysisDescription analysisDescription, @Nullable Project project, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)analysisDescription, (String)"analysisDescription");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(analysisDescription instanceof SinglePassAnalysisDescription)) {
            throw new DfaInternalException("Analysis description must be SinglePassAnalysisDescription");
        }
        AnalysisRunner runner = project != null ? (AnalysisRunner)new AnalysisRunnerImpl(project) : (AnalysisRunner)new DummyAnalysisRunner();
        DfaLocalSessionImpl session = new DfaLocalSessionImpl(analysisDescription, options, runner);
        session.start();
        if (project != null) {
            DfaDebugExtension.Companion.onLocalSessionCreation(session, project);
        }
        return session;
    }

    @NotNull
    public DfaSummarySession createSummarySession(@NotNull RMLAnalysisDescription analysisDescription, @Nullable Project project, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)analysisDescription, (String)"analysisDescription");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (analysisDescription instanceof SinglePassAnalysisDescription) {
            throw new DfaInternalException("Analysis description must not be SinglePassAnalysisDescription");
        }
        AnalysisRunner runner = project != null ? (AnalysisRunner)new AnalysisRunnerImpl(project) : (AnalysisRunner)new DummyAnalysisRunner();
        DfaSummarySessionImpl session = new DfaSummarySessionImpl(analysisDescription, options, runner);
        if (project != null) {
            DfaDebugExtension.Companion.onSummarySessionCreation(session, project);
        }
        return session;
    }
}

