/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.relations.plain;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.impl.bdd.BddManager;
import com.intellij.rml.dfa.impl.bdd.BddNode;
import com.intellij.rml.dfa.impl.bdd.Predicate;
import com.intellij.rml.dfa.impl.domains.AttributesInfo;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.plain.PlainRelationsManager;
import com.intellij.rml.dfa.impl.symtable.MutableSymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.symtable.SymbolTableWithDependencies;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.impl.utils.SortedArrayHelper;
import com.intellij.rml.dfa.utils.Cancellation;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\u0018\u0000 }2\u00020\u0001:\u0002|}B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u001f\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0004\b\t\u0010\u000eB)\b\u0011\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0011J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J%\u0010!\u001a\u00020\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010#\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\u00020\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010'J'\u0010(\u001a\u00020)2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010+\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00072\u0006\u0010/\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u00100J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0007H\u0016\u00a2\u0006\u0002\u00101J)\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u00070\u00072\u0006\u0010/\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u00106J \u00107\u001a\u0002082\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<H\u0016J!\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u00070\u00072\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020?H\u0016J\u0010\u0010A\u001a\u00020\u00012\u0006\u0010B\u001a\u00020.H\u0016J\u0010\u0010C\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010H\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010I\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010J\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010K\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010L\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010L\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010N\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016J'\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0002\u00a2\u0006\u0004\bR\u0010SJ \u0010T\u001a\u00020\u00012\u0006\u0010U\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016J \u0010T\u001a\u00020\u00012\u0006\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016J#\u0010V\u001a\u00020\u00012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010D\u001a\u00020EH\u0016\u00a2\u0006\u0002\u0010WJ:\u0010X\u001a\u00020\u00012\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020Z2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u0002052\u0006\u0010\\\u001a\u00020\u00102\u0006\u0010D\u001a\u00020EH\u0016J \u0010]\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010^\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0016J \u0010]\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\b2\u0006\u0010D\u001a\u00020EH\u0016J+\u0010]\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u00012\u000e\u0010_\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010D\u001a\u00020E\u00a2\u0006\u0002\u0010`J \u0010a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010b\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0016J*\u0010c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010e0d2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010f\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J(\u0010i\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\b2\u0006\u0010j\u001a\u00020\u001c2\u0006\u0010k\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0016J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001c0d2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010m\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020ZH\u0016J\u0011\u0010n\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u0001H\u0096\u0002J\u0014\u0010n\u001a\u00020\u00102\b\u0010o\u001a\u0004\u0018\u00010pH\u0096\u0082\u0004J\n\u0010q\u001a\u00020\u001cH\u0096\u0080\u0004J\u0018\u0010r\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00012\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010s\u001a\u00020\u0010H\u0016J\b\u0010t\u001a\u000208H\u0016J\u0010\u0010u\u001a\u0002082\u0006\u0010v\u001a\u00020wH\u0016J\b\u0010x\u001a\u00020pH\u0016J\u0010\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation;", "Lcom/intellij/rml/dfa/impl/relations/IRelation;", "relationsManager", "Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;", "root", "Lcom/intellij/rml/dfa/impl/bdd/BddNode;", "domains", "", "Lcom/intellij/rml/dfa/impl/domains/Domain;", "<init>", "(Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;I[Lcom/intellij/rml/dfa/impl/domains/Domain;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "manager", "types", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "(Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;[Lcom/intellij/rml/dfa/impl/domains/DomainType;)V", "full", "", "(Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;[Lcom/intellij/rml/dfa/impl/domains/Domain;Z)V", "getRoot-CmkRj6U", "()I", "I", "[Lcom/intellij/rml/dfa/impl/domains/Domain;", "bddManager", "Lcom/intellij/rml/dfa/impl/bdd/BddManager;", "getDomains", "()[Lcom/intellij/rml/dfa/impl/domains/Domain;", "getDomain", "index", "", "getDomainTypes", "()[Lcom/intellij/rml/dfa/impl/domains/DomainType;", "getDomainType", "getClone", "extendDomains", "newDomains", "debugInfo", "", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Ljava/lang/String;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "reorderDomains", "([Lcom/intellij/rml/dfa/impl/domains/Domain;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "getDomainsInfo", "Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation$DomainsInfo;", "dom", "shortContextDomain", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Z)Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation$DomainsInfo;", "getAllTuples", "", "numOfTuples", "(I)[[I", "()[[I", "getAttributes", "Lcom/intellij/rml/dfa/attributes/Attribute;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "(ILcom/intellij/rml/dfa/impl/symtable/SymbolTable;)[[Lcom/intellij/rml/dfa/attributes/Attribute;", "copyAttributes", "", "relationName", "sourceTable", "destTable", "Lcom/intellij/rml/dfa/impl/symtable/MutableSymbolTable;", "(Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;)[[Lcom/intellij/rml/dfa/attributes/Attribute;", "getNumOfTuples", "", "getNumOfBDDNodes", "addTuple", "values", "complement", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "intersect", "relation", "unsafeIntersect", "unite", "unsafeUnite", "subtract", "exists", "domain", "select", "renameSafe", "oldDomain", "newDomain", "renameSafe-aRgiuf0", "(Lcom/intellij/rml/dfa/impl/domains/Domain;Lcom/intellij/rml/dfa/impl/domains/Domain;Lcom/intellij/rml/dfa/utils/Cancellation;)I", "rename", "domainIndex", "fastRename", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Lcom/intellij/rml/dfa/utils/Cancellation;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "migrate", "sourceManager", "Lcom/intellij/rml/dfa/impl/relations/IRelationsManager;", "destManager", "relationMode", "relprod", "indexInLeft", "doms", "(Lcom/intellij/rml/dfa/impl/relations/IRelation;[Lcom/intellij/rml/dfa/impl/domains/Domain;Lcom/intellij/rml/dfa/utils/Cancellation;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "project", "attribute", "disjoin", "", "Lkotlin/Pair;", "generateCondition", "Lcom/intellij/rml/dfa/impl/bdd/Predicate;", "transitiveClosure", "addOrder", "startingFrom", "max", "getVarsDependencies", "makeMutableRelation", "equals", "other", "", "hashCode", "contains", "isEmpty", "kill", "save", "stream", "Ljava/io/DataOutput;", "debugView", "throwException", "", "message", "DomainsInfo", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nPlainRelation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainRelation.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,594:1\n11705#2:595\n12052#2,2:596\n12054#2:604\n11705#2:620\n12052#2,3:621\n3938#2:624\n4474#2,2:625\n1586#3:598\n1661#3,3:599\n1586#3:605\n1661#3,3:606\n1786#3,3:609\n1586#3:612\n1661#3,3:613\n1586#3:616\n1661#3,3:617\n1586#3:627\n1661#3,3:628\n37#4,2:602\n*S KotlinDebug\n*F\n+ 1 PlainRelation.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelation\n*L\n125#1:595\n125#1:596,2\n125#1:604\n352#1:620\n352#1:621,3\n356#1:624\n356#1:625,2\n125#1:598\n125#1:599,3\n388#1:605\n388#1:606,3\n390#1:609,3\n391#1:612\n391#1:613,3\n442#1:616\n442#1:617,3\n358#1:627\n358#1:628,3\n131#1:602,2\n*E\n"})
public final class PlainRelation
implements IRelation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlainRelationsManager relationsManager;
    private final int root;
    @NotNull
    private final Domain[] domains;
    @NotNull
    private final BddManager bddManager;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Attribute completeSetAttribute;
    @NotNull
    private static final Attribute unlimitedSetAttribute;

    private PlainRelation(PlainRelationsManager relationsManager, int root, Domain[] domains) {
        Intrinsics.checkNotNullParameter((Object)relationsManager, (String)"relationsManager");
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        this.relationsManager = relationsManager;
        this.root = root;
        this.domains = domains;
        this.bddManager = this.relationsManager.getBDDManager();
    }

    public final int getRoot-CmkRj6U() {
        return this.root;
    }

    public PlainRelation(@NotNull PlainRelationsManager manager, @NotNull DomainType[] types) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Domain[] domainArray = DomainType.getCorrespondingDomains(types);
        Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"getCorrespondingDomains(...)");
        this(manager, domainArray, false, 4, null);
    }

    @JvmOverloads
    public PlainRelation(@NotNull PlainRelationsManager manager, @NotNull Domain[] domains, boolean full) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        this(manager, full ? BddNode.Companion.getOne-CmkRj6U() : BddNode.Companion.getZero-CmkRj6U(), domains, null);
    }

    public /* synthetic */ PlainRelation(PlainRelationsManager plainRelationsManager, Domain[] domainArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(plainRelationsManager, domainArray, bl);
    }

    @Override
    @NotNull
    public Domain[] getDomains() {
        return this.domains;
    }

    @Override
    @NotNull
    public Domain getDomain(int index) {
        return this.domains[index];
    }

    @Override
    @NotNull
    public DomainType[] getDomainTypes() {
        int n = 0;
        int n2 = this.domains.length;
        DomainType[] domainTypeArray = new DomainType[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)this.domains[n3].getType(), (String)"getType(...)");
        }
        return domainTypeArray;
    }

    @Override
    @NotNull
    public DomainType getDomainType(int index) {
        DomainType domainType = this.domains[index].getType();
        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
        return domainType;
    }

    @Override
    @NotNull
    public IRelation getClone() {
        return new PlainRelation(this.relationsManager, this.root, this.domains, null);
    }

    @Override
    @NotNull
    public IRelation extendDomains(@NotNull Domain[] newDomains, @Nullable String debugInfo) {
        Intrinsics.checkNotNullParameter((Object)newDomains, (String)"newDomains");
        if (!ArrayHelper.isSuperset(this.domains, newDomains)) {
            String string = Arrays.toString(this.domains);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = Arrays.toString(newDomains);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String errorMsg = "Extend domain failed: " + debugInfo + ", old domains: " + string + ", new domains: " + string2;
            LOG.warn(errorMsg);
            this.throwException(errorMsg);
            throw new KotlinNothingValueException();
        }
        return new PlainRelation(this.relationsManager, this.root, newDomains, null);
    }

    @Override
    @NotNull
    public IRelation reorderDomains(@NotNull Domain[] newDomains) {
        Intrinsics.checkNotNullParameter((Object)newDomains, (String)"newDomains");
        if (!ArrayHelper.setEqual(this.domains, newDomains)) {
            String string = Messages.getString(PlainRelation.class.getName() + "-0");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return new PlainRelation(this.relationsManager, this.root, newDomains, null);
    }

    private final DomainsInfo getDomainsInfo(Domain[] dom, boolean shortContextDomain) {
        int[] perm = SortedArrayHelper.getAscendingPermutation(dom);
        int[] domStarts = new int[dom.length];
        int[] domLengths = new int[dom.length];
        int[] limits = new int[dom.length];
        int n = dom.length;
        for (int i = 0; i < n; ++i) {
            DomainType type = dom[perm[i]].getType();
            SymbolTable symbolTable = this.relationsManager.getSymbolTable$intellij_rml_dfa_impl();
            Intrinsics.checkNotNull((Object)type);
            AttributesInfo info = symbolTable.getAttributesInfo(type);
            if (shortContextDomain && type.isContextType()) {
                List<Integer> dependentVars = this.getVarsDependencies(perm[i]);
                Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)dependentVars);
                int min = n2 != null ? n2 : 0;
                Integer n3 = (Integer)CollectionsKt.maxOrNull((Iterable)dependentVars);
                int max = n3 != null ? n3 : -1;
                domStarts[i] = dom[perm[i]].getFirstVar() + min;
                domLengths[i] = max - min + 1;
            } else {
                domStarts[i] = dom[perm[i]].getFirstVar();
                domLengths[i] = info.getBitLength();
            }
            limits[i] = info.getNumOfAttributes();
        }
        Intrinsics.checkNotNull((Object)perm);
        return new DomainsInfo(domStarts, domLengths, perm, limits);
    }

    static /* synthetic */ DomainsInfo getDomainsInfo$default(PlainRelation plainRelation, Domain[] domainArray, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            domainArray = plainRelation.domains;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return plainRelation.getDomainsInfo(domainArray, bl);
    }

    @Override
    @NotNull
    public int[][] getAllTuples(int numOfTuples) {
        DomainsInfo domainsInfo = this.getDomainsInfo(this.domains, numOfTuples != -1);
        int[] domStarts = domainsInfo.component1();
        int[] domLengths = domainsInfo.component2();
        int[] perm = domainsInfo.component3();
        int[] limits = domainsInfo.component4();
        int[][] result = BddNode.getNTuples-impl(this.root, this.bddManager, domStarts, domLengths, limits, numOfTuples);
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            int[] aResult = result[i];
            SortedArrayHelper.applyInversePerm(aResult, perm);
        }
        return result;
    }

    @Override
    @NotNull
    public int[][] getAllTuples() {
        return this.getAllTuples(-1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Attribute[][] getAttributes(int numOfTuples, @NotNull SymbolTable symbolTable) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        int[][] tuples = this.getAllTuples(numOfTuples);
        Object $this$map$iv = (Object[])tuples;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void $this$toTypedArray$iv2;
            void $this$mapTo$iv$iv2;
            void it;
            int[] nArray = (int[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = ArraysKt.withIndex((int[])it);
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Attribute attribute;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                int domainIndex = indexedValue.component1();
                int attr = ((Number)indexedValue.component2()).intValue();
                switch (attr) {
                    case -1: {
                        attribute = completeSetAttribute;
                        break;
                    }
                    case -2: {
                        attribute = unlimitedSetAttribute;
                        break;
                    }
                    default: {
                        DomainType domainType = this.domains[domainIndex].getType();
                        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
                        attribute = symbolTable.getAttribute(domainType, attr);
                    }
                }
                collection2.add(attribute);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            collection.add(thisCollection$iv.toArray(new Attribute[0]));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return (Attribute[][])thisCollection$iv.toArray((T[])new Attribute[0][]);
    }

    @Override
    public void copyAttributes(@NotNull String relationName, @NotNull SymbolTable sourceTable, @NotNull MutableSymbolTable destTable) {
        Intrinsics.checkNotNullParameter((Object)relationName, (String)"relationName");
        Intrinsics.checkNotNullParameter((Object)sourceTable, (String)"sourceTable");
        Intrinsics.checkNotNullParameter((Object)destTable, (String)"destTable");
        DomainsInfo domainsInfo = PlainRelation.getDomainsInfo$default(this, null, false, 3, null);
        int[] domStarts = domainsInfo.component1();
        int[] domLengths = domainsInfo.component2();
        int[] perm = domainsInfo.component3();
        int[] limits = domainsInfo.component4();
        int[][] result = BddNode.getPossibleTuples-impl(this.root, this.bddManager, domStarts, domLengths, limits);
        int n = perm.length;
        for (int i = 0; i < n; ++i) {
            DomainType type = this.domains[perm[i]].getType();
            for (int attr : result[i]) {
                Intrinsics.checkNotNull((Object)type);
                destTable.addAttribute(sourceTable.getAttribute(type, attr), type, "Migrated from", sourceTable + " (" + relationName + ")");
            }
        }
    }

    @Override
    @NotNull
    public Attribute[][] getAttributes(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        return this.getAttributes(-1, symbolTable);
    }

    @Override
    public long getNumOfTuples() {
        DomainsInfo domainsInfo = PlainRelation.getDomainsInfo$default(this, null, false, 3, null);
        int[] domStarts = domainsInfo.component1();
        int[] domLengths = domainsInfo.component2();
        int[] limits = domainsInfo.component4();
        return BddNode.getNumOfTuples-impl(this.root, this.bddManager, domStarts, domLengths, limits);
    }

    @Override
    public long getNumOfBDDNodes() {
        return BddNode.countReachableNodes-impl(this.root, this.bddManager);
    }

    @Override
    @NotNull
    public IRelation addTuple(@NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DomainsInfo domainsInfo = PlainRelation.getDomainsInfo$default(this, null, false, 3, null);
        int[] domStarts = domainsInfo.component1();
        int[] domLengths = domainsInfo.component2();
        int[] perm = domainsInfo.component3();
        SortedArrayHelper.applyPerm(values, perm);
        return new PlainRelation(this.relationsManager, BddNode.addTuple-eQ8CBRE(this.root, this.bddManager, domStarts, domLengths, values), this.domains, null);
    }

    @Override
    @NotNull
    public IRelation complement(@NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        return new PlainRelation(this.relationsManager, BddNode.complement-tT6QPSE(this.root, this.bddManager, cancellation), this.domains, null);
    }

    @Override
    @NotNull
    public IRelation intersect(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            String string = Messages.getString(PlainRelation.class.getName() + "-1");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return new PlainRelation(this.relationsManager, BddNode.intersect-EV6QKKk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation), this.domains, null);
    }

    @Override
    @NotNull
    public IRelation unsafeIntersect(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int n = BddNode.intersect-EV6QKKk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation);
        Domain[] domainArray = ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class);
        Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"uniteArrays(...)");
        return new PlainRelation(this.relationsManager, n, domainArray, null);
    }

    @Override
    @NotNull
    public IRelation unite(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            String string = Messages.getString(PlainRelation.class.getName() + "-2");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return new PlainRelation(this.relationsManager, BddNode.unite-EV6QKKk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation), this.domains, null);
    }

    @Override
    @NotNull
    public IRelation unsafeUnite(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int n = BddNode.unite-EV6QKKk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation);
        Domain[] domainArray = ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class);
        Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"uniteArrays(...)");
        return new PlainRelation(this.relationsManager, n, domainArray, null);
    }

    @Override
    @NotNull
    public IRelation subtract(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int n = BddNode.subtract-EV6QKKk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation);
        Domain[] domainArray = ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class);
        Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"uniteArrays(...)");
        return new PlainRelation(this.relationsManager, n, domainArray, null);
    }

    @Override
    @NotNull
    public IRelation exists(int index, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Domain domain = this.domains[index];
        Domain[] newDomains = ArrayHelper.deleteElement(this.domains, index, Domain.class);
        int n = BddNode.exists-eQ8CBRE(this.root, this.bddManager, domain.getFirstVar(), this.relationsManager.getBitLength(domain), cancellation);
        Intrinsics.checkNotNull((Object)newDomains);
        return new PlainRelation(this.relationsManager, n, newDomains, null);
    }

    @Override
    @NotNull
    public IRelation exists(@NotNull Domain domain, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int index = ArraysKt.indexOf((Object[])this.domains, (Object)domain);
        if (index == -1) {
            String string = Messages.getString(PlainRelation.class.getName() + "-3");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return this.exists(index, cancellation);
    }

    @Override
    @NotNull
    public IRelation select(@NotNull Domain domain, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        IRelation result = this;
        for (Domain curDomain : this.domains) {
            if (Intrinsics.areEqual((Object)curDomain, (Object)domain)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)result.exists(curDomain, cancellation), (String)"exists(...)");
        }
        return result;
    }

    private final int renameSafe-aRgiuf0(Domain oldDomain, Domain newDomain, Cancellation cancellation) {
        int result = this.root;
        IntRange range = RangesKt.until((int)0, (int)this.relationsManager.getBitLength(oldDomain));
        IntProgression iterationRange = oldDomain.compareTo(newDomain) > 0 ? (IntProgression)range : RangesKt.reversed((IntProgression)((IntProgression)range));
        int i = iterationRange.getFirst();
        int n = iterationRange.getLast();
        int n2 = iterationRange.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                int pair = BddNode.Companion.makeEquals-aRgiuf0(this.bddManager, oldDomain.getFirstVar() + i, newDomain.getFirstVar() + i);
                result = BddNode.intersect-EV6QKKk(result, this.bddManager, pair, cancellation);
                result = BddNode.exists-aRgiuf0(result, this.bddManager, oldDomain.getFirstVar() + i, cancellation);
                if (i == n) break;
                i += n2;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public IRelation rename(int domainIndex, @NotNull Domain newDomain, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)newDomain, (String)"newDomain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Domain oldDomain = this.domains[domainIndex];
        if (!Intrinsics.areEqual((Object)oldDomain.getType(), (Object)newDomain.getType())) {
            String string = Messages.getString(PlainRelation.class.getName() + "-4");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        if (Intrinsics.areEqual((Object)oldDomain, (Object)newDomain)) {
            return this.getClone();
        }
        Domain[] newDomains = (Domain[])this.domains.clone();
        newDomains[domainIndex] = newDomain;
        int firstVar = oldDomain.getFirstVar() + this.relationsManager.getBitLength(oldDomain);
        int length = newDomain.getFirstVar() + this.relationsManager.getBitLength(newDomain) - oldDomain.getFirstVar() - this.relationsManager.getBitLength(oldDomain);
        if (oldDomain.getFirstVar() > newDomain.getFirstVar()) {
            firstVar = newDomain.getFirstVar();
            length = oldDomain.getFirstVar() - newDomain.getFirstVar();
        }
        if (BddNode.testVars-impl(this.root, this.bddManager, firstVar, length)) {
            return new PlainRelation(this.relationsManager, this.renameSafe-aRgiuf0(oldDomain, newDomain, cancellation), newDomains, null);
        }
        return new PlainRelation(this.relationsManager, BddNode.rename-cO8FTMI(this.root, this.bddManager, oldDomain.getFirstVar(), this.relationsManager.getBitLength(oldDomain), newDomain.getFirstVar() - oldDomain.getFirstVar(), cancellation), newDomains, null);
    }

    @Override
    @NotNull
    public IRelation rename(@NotNull Domain oldDomain, @NotNull Domain newDomain, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)oldDomain, (String)"oldDomain");
        Intrinsics.checkNotNullParameter((Object)newDomain, (String)"newDomain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int index = ArraysKt.indexOf((Object[])this.domains, (Object)oldDomain);
        if (index == -1) {
            String string = Messages.getString(PlainRelation.class.getName() + "-5");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return this.rename(index, newDomain, cancellation);
    }

    @Override
    @NotNull
    public IRelation fastRename(@NotNull Domain[] newDomains, @NotNull Cancellation cancellation) {
        int i;
        Intrinsics.checkNotNullParameter((Object)newDomains, (String)"newDomains");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (this.domains.length != newDomains.length) {
            String string = Messages.getString(PlainRelation.class.getName() + "-6");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        int n = this.domains.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Intrinsics.areEqual((Object)this.domains[i2].getType(), (Object)newDomains[i2].getType())) continue;
            String string = Messages.getString(PlainRelation.class.getName() + "-6");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        IRelation result = this.getClone();
        boolean[] safeRename = new boolean[this.domains.length];
        int n2 = this.domains.length;
        block1: for (i = 0; i < n2; ++i) {
            int j;
            HashSet<Domain> set = new HashSet<Domain>();
            safeRename[i] = false;
            Domain newDomain = newDomains[i];
            int n3 = this.domains.length;
            for (j = 0; j < n3; ++j) {
                if (i == j) continue;
                IRelation iRelation = result;
                Intrinsics.checkNotNull((Object)iRelation, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelation");
                Domain oldDomain = ((PlainRelation)iRelation).domains[j];
                if (oldDomain.getType() == newDomain.getType()) {
                    set.add(oldDomain);
                }
                if (!Intrinsics.areEqual((Object)oldDomain, (Object)newDomain)) continue;
                safeRename[i] = true;
            }
            if (safeRename[i]) {
                Collections.addAll((Collection)set, Arrays.copyOf(newDomains, newDomains.length));
                j = 0;
                while (true) {
                    Domain domain;
                    if (!set.contains(domain = newDomain.getType().getDomain(j))) {
                        IRelation oldResult = result;
                        Intrinsics.checkNotNullExpressionValue((Object)result.rename(i, domain, cancellation), (String)"rename(...)");
                        oldResult.kill();
                        continue block1;
                    }
                    ++j;
                }
            }
            IRelation oldResult = result;
            Intrinsics.checkNotNullExpressionValue((Object)result.rename(i, newDomains[i], cancellation), (String)"rename(...)");
            oldResult.kill();
        }
        n2 = this.domains.length;
        for (i = 0; i < n2; ++i) {
            if (!safeRename[i]) continue;
            IRelation oldResult = result;
            Intrinsics.checkNotNullExpressionValue((Object)result.rename(i, newDomains[i], cancellation), (String)"rename(...)");
            oldResult.kill();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IRelation migrate(@Nullable IRelationsManager sourceManager, @NotNull IRelationsManager destManager, @NotNull SymbolTable sourceTable, @NotNull SymbolTable destTable, boolean relationMode, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)destManager, (String)"destManager");
        Intrinsics.checkNotNullParameter((Object)sourceTable, (String)"sourceTable");
        Intrinsics.checkNotNullParameter((Object)destTable, (String)"destTable");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (relationMode) {
            PlainRelation mapped = sourceManager != null ? PlainRelation.migrate$mapAttributes(this, destTable, sourceTable, cancellation, this, sourceManager) : this;
            PlainRelation migrated = PlainRelation.migrate$migrate(this, sourceTable, destTable, destManager, cancellation, mapped);
            return PlainRelation.migrate$mapAttributes(this, destTable, sourceTable, cancellation, migrated, migrated.relationsManager);
        }
        IRelation result = null;
        result = destManager.makeEmptyRelation(this.getDomainTypes());
        Attribute[][] attributeArray = this.getAttributes(sourceTable);
        int n = ((Object[])attributeArray).length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Iterable $this$all$iv;
            List mappedAttrs;
            Object object;
            Object item$iv$iv;
            Iterator iterator;
            Object $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            block7: {
                Object[] attrs = attributeArray[i];
                $this$map$iv = ArraysKt.withIndex((Object[])attrs);
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    object = (IndexedValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    int idx = object.component1();
                    Attribute attr = (Attribute)object.component2();
                    DomainType domainType = result.getDomainType(idx);
                    Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getDomainType(...)");
                    String string = attr.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    collection.add(destTable.getAttributeIntOrNull(domainType, string));
                }
                mappedAttrs = (List)destination$iv$iv;
                $this$all$iv = mappedAttrs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    $this$mapTo$iv$iv = $this$all$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        Integer it = (Integer)element$iv;
                        boolean bl3 = false;
                        if (it != null) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            $this$all$iv = mappedAttrs;
            IRelation iRelation = result;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                item$iv$iv = iterator.next();
                object = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                void v3 = it;
                Intrinsics.checkNotNull((Object)v3);
                collection.add(v3.intValue());
            }
            result = iRelation.addTuple(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
        }
        IRelation iRelation = result;
        Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"element");
        return iRelation;
    }

    @Override
    @NotNull
    public IRelation relprod(@NotNull IRelation relation, int indexInLeft, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int firstVar = this.domains[indexInLeft].getFirstVar();
        int length = this.relationsManager.getBitLength(this.domains[indexInLeft]);
        Domain[] newDomains = ArrayHelper.uniteArrays(this.domains, ((PlainRelation)relation).domains, Domain.class);
        newDomains = ArrayHelper.deleteElement(newDomains, this.domains[indexInLeft], Domain.class);
        int n = BddNode.relprod-Lx_0IS8(this.root, this.bddManager, ((PlainRelation)relation).root, firstVar, length, cancellation);
        Domain[] domainArray = newDomains;
        Intrinsics.checkNotNull((Object)domainArray);
        return new PlainRelation(this.relationsManager, n, domainArray, null);
    }

    @Override
    @NotNull
    public IRelation relprod(@NotNull IRelation relation, @NotNull Domain domain, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int index = ArraysKt.indexOf((Object[])this.domains, (Object)domain);
        if (index == -1) {
            String string = Messages.getString(PlainRelation.class.getName() + "-7");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return this.relprod(relation, index, cancellation);
    }

    @NotNull
    public final IRelation relprod(@NotNull IRelation relation, @NotNull Domain[] doms, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)doms, (String)"doms");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        IRelation iRelation = this.unsafeIntersect(relation, cancellation);
        Intrinsics.checkNotNull((Object)iRelation, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelation");
        PlainRelation result = (PlainRelation)iRelation;
        for (Domain dom : doms) {
            int index = ArraysKt.indexOf((Object[])result.domains, (Object)dom);
            if (index == -1) {
                String string = Messages.getString(PlainRelation.class.getName() + "-8");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                this.throwException(string);
                throw new KotlinNothingValueException();
            }
            IRelation oldResult = result;
            IRelation iRelation2 = result.exists(index, cancellation);
            Intrinsics.checkNotNull((Object)iRelation2, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelation");
            result = (PlainRelation)iRelation2;
            oldResult.kill();
        }
        return result;
    }

    @Override
    @NotNull
    public IRelation project(int index, int attribute, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        IRelation deletedDomain = this.relationsManager.makeSingleTuple(this.domains[index], attribute);
        IRelation result = this.relprod(deletedDomain, index, cancellation);
        deletedDomain.kill();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<IRelation, IRelation>> disjoin(int index, @NotNull Cancellation cancellation) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        for (Domain domain : this.domains) {
            if (domain.compareTo(this.domains[index]) <= 0) continue;
            String string = Messages.getString(PlainRelation.class.getName() + "-12");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        int firstVar = this.domains[index].getFirstVar();
        int length = this.relationsManager.getBitLength(this.domains[index]);
        Iterable $this$map$iv = BddNode.disjoin-impl(this.root, this.bddManager, firstVar);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            int n = ((BddNode)item$iv$iv).unbox-impl();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n2 = BddNode.relprod-Lx_0IS8(this.root, this.bddManager, (int)node, firstVar, length, cancellation);
            Domain[] domainArray = ArrayHelper.deleteElement(this.domains, index, Domain.class);
            Intrinsics.checkNotNullExpressionValue((Object)domainArray, (String)"deleteElement(...)");
            Domain[] domainArray2 = new Domain[]{this.domains[index]};
            collection.add(new Pair((Object)new PlainRelation(this.relationsManager, n2, domainArray, null), (Object)new PlainRelation(this.relationsManager, (int)node, domainArray2, null).getClone()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Predicate generateCondition() {
        return BddNode.generateCondition-impl(this.root, this.bddManager);
    }

    @Override
    @NotNull
    public IRelation transitiveClosure(@NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (this.domains.length != 2 || !Intrinsics.areEqual((Object)this.domains[0].getType(), (Object)this.domains[1].getType())) {
            String string = Messages.getString(PlainRelation.class.getName() + "-9");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        SymbolTable symbolTable = this.relationsManager.getSymbolTable$intellij_rml_dfa_impl();
        DomainType domainType = this.domains[0].getType();
        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
        int n = symbolTable.getAttributesInfo(domainType).getNumOfAttributes();
        IRelation result = this.getClone();
        for (int k = 0; k < n; ++k) {
            cancellation.checkCancelled();
            IRelation proj1 = result.project(1, k, cancellation);
            IRelation proj2 = result.project(0, k, cancellation);
            IRelation work = proj1.unsafeIntersect(proj2, cancellation);
            IRelation oldResult = result;
            Intrinsics.checkNotNullExpressionValue((Object)result.unite(work, cancellation), (String)"unite(...)");
            proj1.kill();
            proj2.kill();
            work.kill();
            oldResult.kill();
        }
        return result;
    }

    @Override
    @NotNull
    public IRelation addOrder(@NotNull Domain domain, int startingFrom, int max, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Domain orderDomain = domain.getType().getSpecialLastDomain();
        Object object = new Domain[]{orderDomain};
        Domain[] newDomains = ArrayHelper.uniteArrays(this.domains, object, Domain.class);
        Intrinsics.checkNotNull((Object)newDomains);
        object = PlainRelation.getDomainsInfo$default(this, newDomains, false, 2, null);
        int[] domStarts = ((DomainsInfo)object).component1();
        int[] domLengths = ((DomainsInfo)object).component2();
        PlainRelation ordered = new PlainRelation(this.relationsManager, BddNode.addOrder-cO8FTMI(this.root, this.bddManager, domStarts, domLengths, startingFrom, max), newDomains, null);
        Intrinsics.checkNotNull((Object)orderDomain);
        IRelation result = ordered.rename(orderDomain, domain, cancellation);
        ordered.kill();
        return result;
    }

    @Override
    @NotNull
    public List<Integer> getVarsDependencies(int index) {
        List result = new ArrayList();
        int bitLength = this.relationsManager.getBitLength(this.domains[index]);
        for (int i = 0; i < bitLength; ++i) {
            if (!BddNode.testVars-impl(this.root, this.bddManager, this.domains[index].getFirstVar() + i, 1)) continue;
            result.add(i);
        }
        return result;
    }

    @Override
    @NotNull
    public IRelation makeMutableRelation(@NotNull IRelationsManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new PlainRelation((PlainRelationsManager)manager, this.root, this.domains, null);
    }

    @Override
    public boolean equals(@NotNull IRelation relation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            String string = Messages.getString(PlainRelation.class.getName() + "-10");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return BddNode.equals-impl0(this.root, ((PlainRelation)relation).root);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PlainRelation && this.equals((IRelation)other);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{BddNode.box-impl(this.root)};
        int result = Objects.hash(objectArray);
        result = 31 * result + Arrays.hashCode(this.domains);
        return result;
    }

    @Override
    public boolean contains(@NotNull IRelation relation, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (!ArrayHelper.equals(this.domains, ((PlainRelation)relation).domains)) {
            String string = Messages.getString(PlainRelation.class.getName() + "-11");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            this.throwException(string);
            throw new KotlinNothingValueException();
        }
        return BddNode.superset-JZV_jlk(this.root, this.bddManager, ((PlainRelation)relation).root, cancellation);
    }

    @Override
    public boolean isEmpty() {
        return BddNode.equals-impl0(this.root, BddNode.Companion.getZero-CmkRj6U());
    }

    @Override
    public void kill() {
    }

    @Override
    public void save(@NotNull DataOutput stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeInt(this.domains.length);
        for (Domain domain : this.domains) {
            domain.save(stream);
        }
        stream.writeInt(this.root);
    }

    @Override
    @NotNull
    public Object debugView() {
        return this.relationsManager.getBDDManager().debugView-z9lS3pQ$intellij_rml_dfa_impl(this.root);
    }

    private final Void throwException(String message) {
        throw new DfaInternalException(this.bddManager.toString(), message);
    }

    @JvmOverloads
    public PlainRelation(@NotNull PlainRelationsManager manager, @NotNull Domain[] domains) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        this(manager, domains, false, 4, null);
    }

    private static final PlainRelation migrate$migrate(PlainRelation this$0, SymbolTable $sourceTable, SymbolTable $destTable, IRelationsManager $destManager, Cancellation $cancellation, PlainRelation relation) {
        DomainsInfo domainsInfo = PlainRelation.getDomainsInfo$default(this$0, null, false, 3, null);
        int[] domStarts = domainsInfo.component1();
        int[] domLengths = domainsInfo.component2();
        int[] perm = domainsInfo.component3();
        int[] domLengthDeltas = new int[this$0.domains.length];
        int n = this$0.domains.length;
        for (int i = 0; i < n; ++i) {
            DomainType type = this$0.domains[perm[i]].getType();
            Intrinsics.checkNotNull((Object)type);
            AttributesInfo sourceInfo = $sourceTable.getAttributesInfo(type);
            AttributesInfo destInfo = $destTable.getAttributesInfo(type);
            domLengthDeltas[i] = destInfo.getBitLength() - sourceInfo.getBitLength();
            if ($destTable instanceof SymbolTableWithDependencies || domLengthDeltas[i] == 0) continue;
            this$0.throwException("Extending domains in non-local mode");
            throw new KotlinNothingValueException();
        }
        int n2 = relation.root;
        BddManager bddManager = relation.bddManager;
        BddManager bddManager2 = $destManager.getBDDManager();
        Intrinsics.checkNotNullExpressionValue((Object)bddManager2, (String)"getBDDManager(...)");
        int migratedNode = BddNode.migrate-MFH0gb4(n2, bddManager, bddManager2, domStarts, domLengths, domLengthDeltas, $cancellation);
        Intrinsics.checkNotNull((Object)$destManager, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelationsManager");
        return new PlainRelation((PlainRelationsManager)$destManager, migratedNode, this$0.domains, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final PlainRelation migrate$mapAttributes(PlainRelation this$0, SymbolTable $destTable, SymbolTable $sourceTable, Cancellation $cancellation, PlainRelation relation, IRelationsManager relationsManager) {
        Collection collection;
        void $this$mapTo$iv$iv;
        IRelation result = relation.makeMutableRelation(relationsManager);
        Domain[] $this$map$iv = this$0.domains;
        boolean $i$f$map = false;
        Domain[] domainArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_26 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            int n2 = 0;
            collection.add(it.getType());
        }
        for (DomainType domainType : CollectionsKt.toSet((Iterable)((List)destination$iv$iv))) {
            Domain srcDomain;
            void $this$mapTo$iv$iv2;
            int n3;
            Iterator element$iv$iv2;
            void $this$filterTo$iv$iv;
            IRelation mapRelation;
            SymbolTableWithDependencies symbolTableWithDependencies = $destTable instanceof SymbolTableWithDependencies ? (SymbolTableWithDependencies)$destTable : null;
            if (symbolTableWithDependencies != null) {
                Intrinsics.checkNotNull((Object)domainType);
                v1 = symbolTableWithDependencies.getAttributesMap($sourceTable, domainType);
            } else {
                v1 = mapRelation = null;
            }
            if (domainType.isIntegerType() || mapRelation == null || !Intrinsics.areEqual((Object)((PlainRelation)mapRelation).relationsManager, (Object)relationsManager)) continue;
            Domain[] $this$filter$iv = relation.domains;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
                void it = element$iv$iv2;
                n3 = 0;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)domainType)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List srcDomains = (List)destination$iv$iv2;
            int destDomainsStartIndex = domainType.getDomainOrder((Domain)CollectionsKt.maxOrThrow((Iterable)srcDomains)) + 1;
            Iterable $this$map$iv2 = (Iterable)CollectionsKt.getIndices((Collection)srcDomains);
            boolean $i$f$map2 = false;
            Iterable $i$f$filterTo22 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            element$iv$iv2 = $this$mapTo$iv$iv2.iterator();
            while (element$iv$iv2.hasNext()) {
                void it;
                int item$iv$iv;
                n3 = item$iv$iv = ((IntIterator)element$iv$iv2).nextInt();
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(domainType.getDomain(destDomainsStartIndex + it));
            }
            List destDomains = (List)destination$iv$iv3;
            for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)srcDomains))) {
                int index = indexedValue.component1();
                srcDomain = (Domain)indexedValue.component2();
                if (index > 0 && ((Domain)srcDomains.get(index - 1)).compareTo((Domain)srcDomains.get(index)) > 0) {
                    this$0.throwException("Domains are not sorted");
                    throw new KotlinNothingValueException();
                }
                Domain destDomain = (Domain)destDomains.get(index);
                PlainRelation plainRelation = (PlainRelation)mapRelation;
                Intrinsics.checkNotNull((Object)destDomain);
                IRelation mapper = plainRelation.rename(1, destDomain, $cancellation).rename(0, srcDomain, $cancellation);
                IRelation iRelation = result.relprod(mapper, srcDomain, $cancellation);
                Intrinsics.checkNotNull((Object)iRelation, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelation");
                result = (PlainRelation)iRelation;
            }
            object = ((Iterable)srcDomains).iterator();
            n = 0;
            while (object.hasNext()) {
                int index = n++;
                srcDomain = (Domain)object.next();
                Intrinsics.checkNotNullExpressionValue((Object)result.rename((Domain)destDomains.get(index), srcDomain, $cancellation), (String)"rename(...)");
            }
        }
        IRelation iRelation = result.reorderDomains(relation.domains);
        Intrinsics.checkNotNull((Object)iRelation, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.relations.plain.PlainRelation");
        return (PlainRelation)iRelation;
    }

    public /* synthetic */ PlainRelation(PlainRelationsManager relationsManager, int root, Domain[] domains, DefaultConstructorMarker $constructor_marker) {
        this(relationsManager, root, domains);
    }

    static {
        Logger logger = Logger.getInstance(PlainRelation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        completeSetAttribute = new Attribute("*");
        unlimitedSetAttribute = new Attribute("--*--");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "completeSetAttribute", "Lcom/intellij/rml/dfa/attributes/Attribute;", "getCompleteSetAttribute", "()Lcom/intellij/rml/dfa/attributes/Attribute;", "unlimitedSetAttribute", "getUnlimitedSetAttribute", "load", "Lcom/intellij/rml/dfa/impl/relations/IImmutableRelation;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "relationsManager", "Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;", "stream", "Ljava/io/DataInput;", "intellij.rml.dfa.impl"})
    @SourceDebugExtension(value={"SMAP\nPlainRelation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainRelation.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,594:1\n1586#2:595\n1661#2,3:596\n37#3,2:599\n*S KotlinDebug\n*F\n+ 1 PlainRelation.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelation$Companion\n*L\n588#1:595\n588#1:596,3\n588#1:599,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Attribute getCompleteSetAttribute() {
            return completeSetAttribute;
        }

        @NotNull
        public final Attribute getUnlimitedSetAttribute() {
            return unlimitedSetAttribute;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IImmutableRelation load(@NotNull DomainTypeManager typeManager, @NotNull PlainRelationsManager relationsManager, @NotNull DataInput stream) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
            Intrinsics.checkNotNullParameter((Object)relationsManager, (String)"relationsManager");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int domainsCnt = stream.readInt();
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)domainsCnt);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Domain.load(typeManager, stream));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Domain[] domains = thisCollection$iv.toArray(new Domain[0]);
            int root = BddNode.constructor-impl(stream.readInt());
            return new PlainRelation(relationsManager, root, domains, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation$DomainsInfo;", "", "domStarts", "", "domLengths", "perm", "limits", "<init>", "([I[I[I[I)V", "getDomStarts", "()[I", "getDomLengths", "getPerm", "getLimits", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rml.dfa.impl"})
    private static final class DomainsInfo {
        @NotNull
        private final int[] domStarts;
        @NotNull
        private final int[] domLengths;
        @NotNull
        private final int[] perm;
        @NotNull
        private final int[] limits;

        public DomainsInfo(@NotNull int[] domStarts, @NotNull int[] domLengths, @NotNull int[] perm, @NotNull int[] limits) {
            Intrinsics.checkNotNullParameter((Object)domStarts, (String)"domStarts");
            Intrinsics.checkNotNullParameter((Object)domLengths, (String)"domLengths");
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
            this.domStarts = domStarts;
            this.domLengths = domLengths;
            this.perm = perm;
            this.limits = limits;
        }

        @NotNull
        public final int[] getDomStarts() {
            return this.domStarts;
        }

        @NotNull
        public final int[] getDomLengths() {
            return this.domLengths;
        }

        @NotNull
        public final int[] getPerm() {
            return this.perm;
        }

        @NotNull
        public final int[] getLimits() {
            return this.limits;
        }

        @NotNull
        public final int[] component1() {
            return this.domStarts;
        }

        @NotNull
        public final int[] component2() {
            return this.domLengths;
        }

        @NotNull
        public final int[] component3() {
            return this.perm;
        }

        @NotNull
        public final int[] component4() {
            return this.limits;
        }

        @NotNull
        public final DomainsInfo copy(@NotNull int[] domStarts, @NotNull int[] domLengths, @NotNull int[] perm, @NotNull int[] limits) {
            Intrinsics.checkNotNullParameter((Object)domStarts, (String)"domStarts");
            Intrinsics.checkNotNullParameter((Object)domLengths, (String)"domLengths");
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
            return new DomainsInfo(domStarts, domLengths, perm, limits);
        }

        public static /* synthetic */ DomainsInfo copy$default(DomainsInfo domainsInfo, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, Object object) {
            if ((n & 1) != 0) {
                nArray = domainsInfo.domStarts;
            }
            if ((n & 2) != 0) {
                nArray2 = domainsInfo.domLengths;
            }
            if ((n & 4) != 0) {
                nArray3 = domainsInfo.perm;
            }
            if ((n & 8) != 0) {
                nArray4 = domainsInfo.limits;
            }
            return domainsInfo.copy(nArray, nArray2, nArray3, nArray4);
        }

        @NotNull
        public String toString() {
            return "DomainsInfo(domStarts=" + Arrays.toString(this.domStarts) + ", domLengths=" + Arrays.toString(this.domLengths) + ", perm=" + Arrays.toString(this.perm) + ", limits=" + Arrays.toString(this.limits) + ")";
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.domStarts);
            result = result * 31 + Arrays.hashCode(this.domLengths);
            result = result * 31 + Arrays.hashCode(this.perm);
            result = result * 31 + Arrays.hashCode(this.limits);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DomainsInfo)) {
                return false;
            }
            DomainsInfo domainsInfo = (DomainsInfo)other;
            if (!Intrinsics.areEqual((Object)this.domStarts, (Object)domainsInfo.domStarts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.domLengths, (Object)domainsInfo.domLengths)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.perm, (Object)domainsInfo.perm)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.limits, (Object)domainsInfo.limits);
        }
    }
}

