/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/rml/dfa/impl/transform/EmptyBlocksFilterStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "<init>", "()V", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "name", "", "getName", "()Ljava/lang/String;", "intellij.rml.dfa.impl"})
public final class EmptyBlocksFilterStage
implements IrTransformStage {
    @NotNull
    private final String name;

    public EmptyBlocksFilterStage() {
        this.name = "Filter empty blocks";
    }

    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        IrCfg cfg2 = ((IrFunctionDecl)decl).getBody();
        MultiMap incomingNodes = new MultiMap();
        MultiMap outgoingNodes = new MultiMap();
        for (Map.Entry entry : cfg2.getJumps().entrySet()) {
            IrCFGBlock source = (IrCFGBlock)entry.getKey();
            IrJump jump = (IrJump)entry.getValue();
            for (IrCFGBlock target : jump.getTargets()) {
                incomingNodes.putValue((Object)target, (Object)source);
                outgoingNodes.putValue((Object)source, (Object)target);
            }
        }
        Set newBlocks = CollectionsKt.toMutableSet((Iterable)cfg2.getBlocks());
        Map newJumps2 = MapsKt.toMutableMap((Map)cfg2.getJumps());
        for (IrCFGBlock block : CollectionsKt.toList((Iterable)cfg2.getBlocks())) {
            IrJump irJump;
            if (!((Collection)block.getInstructions()).isEmpty() || outgoingNodes.get((Object)block).size() != 1 || incomingNodes.get((Object)block).size() != 1) continue;
            Collection collection = outgoingNodes.get((Object)block);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            IrCFGBlock next = (IrCFGBlock)CollectionsKt.first((Iterable)collection);
            Collection collection2 = incomingNodes.get((Object)block);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
            IrCFGBlock prev = (IrCFGBlock)CollectionsKt.first((Iterable)collection2);
            IrJump jump = (IrJump)newJumps2.get(prev);
            if (outgoingNodes.get((Object)prev).size() > 1 && incomingNodes.get((Object)next).size() > 1) continue;
            ((Collection)newBlocks).remove(block);
            newJumps2.remove(block);
            if (jump instanceof IrConditionalJump) {
                IrConditionalJump irConditionalJump;
                if (Intrinsics.areEqual((Object)((IrConditionalJump)jump).getTrueBranch(), (Object)block)) {
                    IrCondition irCondition = ((IrConditionalJump)jump).getCondition();
                    Intrinsics.checkNotNull((Object)next);
                    irConditionalJump = new IrConditionalJump(irCondition, next, ((IrConditionalJump)jump).getFalseBranch());
                } else {
                    IrCondition irCondition = ((IrConditionalJump)jump).getCondition();
                    IrCFGBlock irCFGBlock = ((IrConditionalJump)jump).getTrueBranch();
                    Intrinsics.checkNotNull((Object)next);
                    irConditionalJump = new IrConditionalJump(irCondition, irCFGBlock, next);
                }
                irJump = (IrJump)irConditionalJump;
            } else {
                Intrinsics.checkNotNull((Object)next);
                irJump = (IrJump)new IrUnconditionalJump(next);
            }
            newJumps2.put(prev, irJump);
            Collection collection3 = incomingNodes.get((Object)next);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"get(...)");
            collection3.remove(block);
            Collection collection4 = incomingNodes.get((Object)next);
            Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"get(...)");
            collection4.add(prev);
            Collection collection5 = outgoingNodes.get((Object)prev);
            Intrinsics.checkNotNullExpressionValue((Object)collection5, (String)"get(...)");
            collection5.remove(block);
            Collection collection6 = outgoingNodes.get((Object)prev);
            Intrinsics.checkNotNullExpressionValue((Object)collection6, (String)"get(...)");
            collection6.add(next);
        }
        return (IrTopLevelDecl)((IrFunctionDecl)decl).modifyCfg(new IrCfg(newBlocks, newJumps2, cfg2.getStartBlock(), cfg2.getExitBlock()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }
}

