/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.transform;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.rml.dfa.impl.transform.IrTransformStage;
import com.intellij.rml.dfa.impl.transform.PathSensitiveCfgProcessorImplKt;
import com.intellij.rml.dfa.impl.transform.ReadWriteCollector;
import com.intellij.rml.dfa.impl.transform.ReadsWriteBranches;
import com.intellij.rml.dfa.ir.ast.IrCloner;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.cfg.IrCFGBlock;
import com.intellij.rml.dfa.ir.cfg.IrCfg;
import com.intellij.rml.dfa.ir.cfg.IrConditionalJump;
import com.intellij.rml.dfa.ir.cfg.IrJump;
import com.intellij.rml.dfa.ir.cfg.IrUnconditionalJump;
import com.intellij.rml.dfa.transform.PathSensitiveCfgDescription;
import com.intellij.rml.dfa.utils.Cancellation;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/rml/dfa/impl/transform/PathSensitivityStage;", "Lcom/intellij/rml/dfa/impl/transform/IrTransformStage;", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "<init>", "(Lcom/intellij/rml/dfa/utils/Cancellation;)V", "getCancellation", "()Lcom/intellij/rml/dfa/utils/Cancellation;", "conditionalJump", "", "Lkotlin/Pair;", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "transform", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "decl", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "name", "", "getName", "()Ljava/lang/String;", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nPathSensitivityStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathSensitivityStage.kt\ncom/intellij/rml/dfa/impl/transform/PathSensitivityStage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n466#3:84\n415#3:85\n1266#4,4:86\n*S KotlinDebug\n*F\n+ 1 PathSensitivityStage.kt\ncom/intellij/rml/dfa/impl/transform/PathSensitivityStage\n*L\n72#1:84\n72#1:85\n72#1:86,4\n*E\n"})
public final class PathSensitivityStage
implements IrTransformStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cancellation cancellation;
    @NotNull
    private final List<Pair<IrCFGBlock, IrCFGBlock>> conditionalJump;
    @NotNull
    private final String name;
    @NotNull
    private static final Key<Map<IrCFGBlock, Integer>> PATH_MAPPING;
    @NotNull
    private static final Logger LOG;

    public PathSensitivityStage(@NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        this.cancellation = cancellation;
        this.conditionalJump = new ArrayList();
        this.name = "Path sensitive stage";
    }

    @NotNull
    public final Cancellation getCancellation() {
        return this.cancellation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrTopLevelDecl transform(@NotNull IrTopLevelDecl decl, @NotNull RMLOptions options) {
        Map map2;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object originalJump;
        Map map3;
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!(decl instanceof IrFunctionDecl)) {
            return decl;
        }
        ReadWriteCollector collector = new ReadWriteCollector(options);
        ReadsWriteBranches readWrites = collector.collectReadsWrites((IrFunctionDecl)decl);
        for (Map.Entry entry : ((IrFunctionDecl)decl).getBody().getJumps().entrySet()) {
            IrCFGBlock block = (IrCFGBlock)entry.getKey();
            IrJump jump = (IrJump)entry.getValue();
            if (!(jump instanceof IrConditionalJump)) continue;
            this.conditionalJump.add((Pair<IrCFGBlock, IrCFGBlock>)TuplesKt.to((Object)block, (Object)((IrConditionalJump)jump).getTrueBranch()));
            this.conditionalJump.add((Pair<IrCFGBlock, IrCFGBlock>)TuplesKt.to((Object)block, (Object)((IrConditionalJump)jump).getFalseBranch()));
        }
        PathSensitiveCfgDescription description = new PathSensitiveCfgDescription(readWrites.getReads(), readWrites.getWrites(), readWrites.getBranches(), this.conditionalJump, CollectionsKt.emptyList());
        ControlFlowGraph cfg2 = ((IrFunctionDecl)decl).getBody().toControlFlowGraph();
        Pair pathSensitiveResult = PathSensitiveCfgProcessorImplKt.buildPathSensitiveCfg(((IrFunctionDecl)decl).getName().getAttr(), cfg2, description, true, this.cancellation);
        if (pathSensitiveResult == null) {
            LOG.warn("Path sensitive stage finished unsuccessfully, skip it");
            return decl;
        }
        Pair pair = pathSensitiveResult;
        ControlFlowGraph pathSensitiveCfg = (ControlFlowGraph)pair.component1();
        Map originalNode = (Map)pair.component2();
        Map $this$transform_u24lambda_u240 = map3 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (IrCFGBlock context : pathSensitiveCfg.getGraph().nodes()) {
            Unit unit;
            Object it;
            Iterable iterable;
            IrCFGBlock original;
            if ((IrCFGBlock)originalNode.get(context) == null) {
                throw new IllegalStateException();
            }
            originalJump = (IrJump)((IrFunctionDecl)decl).getBody().getJumps().get(original);
            if (originalJump instanceof IrUnconditionalJump) {
                Object v0;
                block14: {
                    iterable = pathSensitiveCfg.getGraph().get((Object)context);
                    for (Object object32 : iterable) {
                        it = (IrCFGBlock)object32;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(originalNode.get(it), (Object)((IrUnconditionalJump)originalJump).getNextBlock())) continue;
                        v0 = object32;
                        break block14;
                    }
                    v0 = null;
                }
                IrCFGBlock destContext = v0;
                if (destContext == null) {
                    LOG.error("destContext is null");
                    return decl;
                }
                unit = $this$transform_u24lambda_u240.put(context, new IrUnconditionalJump(destContext));
                continue;
            }
            if (originalJump instanceof IrConditionalJump) {
                Object object;
                IrCFGBlock trueBranchContext;
                block16: {
                    Object object2;
                    Object object32;
                    block15: {
                        iterable = pathSensitiveCfg.getGraph().get((Object)context);
                        for (Object object32 : iterable) {
                            it = (IrCFGBlock)object32;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(originalNode.get(it), (Object)((IrConditionalJump)originalJump).getTrueBranch())) continue;
                            object2 = object32;
                            break block15;
                        }
                        object2 = null;
                    }
                    trueBranchContext = (IrCFGBlock)object2;
                    Iterable iterable2 = pathSensitiveCfg.getGraph().get((Object)context);
                    object32 = iterable2.iterator();
                    while (object32.hasNext()) {
                        Object it2 = it = object32.next();
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(originalNode.get(it2), (Object)((IrConditionalJump)originalJump).getFalseBranch())) continue;
                        object = it;
                        break block16;
                    }
                    object = null;
                }
                IrCFGBlock falseBranchContext = object;
                if (trueBranchContext == null || falseBranchContext == null) {
                    LOG.error("trueBranchContext or falseBranchContext is null");
                    return decl;
                }
                unit = $this$transform_u24lambda_u240.put(context, new IrConditionalJump(((IrConditionalJump)originalJump).getCondition().clone(new IrCloner(){}), trueBranchContext, falseBranchContext));
                continue;
            }
            if (originalJump == null) {
                unit = Unit.INSTANCE;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Map newJumps2 = MapsKt.build((Map)map3);
        IrCfg newCfg = new IrCfg(pathSensitiveCfg.getGraph().nodes(), newJumps2, (IrCFGBlock)pathSensitiveCfg.getStartNode(), (IrCFGBlock)pathSensitiveCfg.getExitNode());
        $this$transform_u24lambda_u240 = originalNode;
        Key<Map<IrCFGBlock, Integer>> key = PATH_MAPPING;
        IrFunctionDecl irFunctionDecl = (IrFunctionDecl)decl;
        boolean $i$f$mapValues = false;
        Iterator iterator = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        originalJump = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv$iv;
            boolean bl5 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map4;
            boolean bl6 = false;
            IrCFGBlock origBlock = (IrCFGBlock)entry.getValue();
            Integer n = cfg2.getGraph().getIdByNode((Object)origBlock);
            map2.put(k, n);
        }
        map2 = destination$iv$iv$iv;
        irFunctionDecl.putUserData(key, (Object)map2);
        return (IrTopLevelDecl)((IrFunctionDecl)decl).modifyCfg(newCfg);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    static {
        Key key = Key.create((String)"PATH_MAPPING");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PATH_MAPPING = key;
        Logger logger = Logger.getInstance(PathSensitivityStage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R<\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/rml/dfa/impl/transform/PathSensitivityStage$Companion;", "", "<init>", "()V", "PATH_MAPPING", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/rml/dfa/ir/cfg/IrCFGBlock;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPATH_MAPPING", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Map<IrCFGBlock, Integer>> getPATH_MAPPING() {
            return PATH_MAPPING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

