/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.hivebase.types.HiveTypeSystemKt;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/hivebase/types/HiveTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "createDasType", "Lcom/intellij/database/types/DasType;", "dataType", "Lcom/intellij/database/model/DataType;", "getBuiltinFunctionReturnType", "prototype", "Lcom/intellij/sql/dialects/BuiltinFunction$Prototype;", "nameElement", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "params", "Lcom/intellij/psi/PsiElement;", "routineElement", "asName", "", "Lcom/intellij/sql/psi/SqlExpression;", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveTypeSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/HiveTypeSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1924#2,3:326\n*S KotlinDebug\n*F\n+ 1 HiveTypeSystem.kt\ncom/intellij/database/dialects/hivebase/types/HiveTypeSystem\n*L\n42#1:326,3\n*E\n"})
public final class HiveTypeSystem
extends DasTypeSystemImpl {
    public HiveTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @NotNull
    public DasType createDasType(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        DasType dasType = (DasType)HiveTypeSystemKt.access$getDasTypes$p().get(dataType);
        if (dasType == null) {
            dasType = (DasType)DasTypeSystemBase.UNKNOWN;
        }
        return dasType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public DasType getBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params, @NotNull PsiElement routineElement) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)routineElement, (String)"routineElement");
        SqlExpressionList expressionList = params instanceof SqlExpressionList ? (SqlExpressionList)params : null;
        Object object = expressionList;
        if (object == null || (object = object.getExpressionList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object args = object;
        switch (prototype.getFunction().getName()) {
            case "struct": {
                return SqlImplUtil.getTupleType((List)args, (PsiElement)((PsiElement)expressionList), (Dbms)this.getDbms(), (boolean)true);
            }
            case "named_struct": {
                int argCount = args.size() / 2;
                if (argCount == 0) {
                    return (DasType)SqlTableTypeBase.EMPTY_TABLE;
                }
                ArrayList<String> names = new ArrayList<String>(argCount);
                ArrayList<SqlExpression> values = new ArrayList<SqlExpression>(argCount);
                Iterable $this$forEachIndexed$iv = (Iterable)args;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    boolean bl;
                    void arg;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    SqlExpression sqlExpression = (SqlExpression)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    if (i % 2 == 0) {
                        Intrinsics.checkNotNull((Object)arg);
                        String string = this.asName((SqlExpression)arg);
                        if (string == null) {
                            string = arg.getText();
                        }
                        bl = names.add(string);
                        continue;
                    }
                    bl = values.add((SqlExpression)arg);
                }
                Dbms dbms = this.getDbms();
                return (DasType)new SqlImplUtil.ValuesTableTypeBase(expressionList, values, names, dbms){
                    final /* synthetic */ ArrayList<String> $names;
                    {
                        this.$names = $names;
                        super((PsiElement)$expressionList, (List)$values, $super_call_param$1);
                    }

                    protected SqlColumnSymbol createColumn(int index, SqlExpression expression, Dbms dbms) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
                        return (SqlColumnSymbol)new SqlImplUtil.ValueTypeColumnSymbol(this.$names.get(index), false, expression, index, null, null);
                    }
                };
            }
        }
        return super.getBuiltinFunctionReturnType(prototype, nameElement, params, routineElement);
    }

    private final String asName(SqlExpression $this$asName) {
        if ($this$asName instanceof SqlStringLiteralExpression) {
            return ((SqlStringLiteralExpression)$this$asName).getValue();
        }
        if ($this$asName instanceof SqlBinaryExpression && Intrinsics.areEqual((Object)((SqlBinaryExpression)$this$asName).getOpSign(), (Object)SqlCommonTokens.SQL_OP_CONCAT)) {
            String string = this.asName(((SqlBinaryExpression)$this$asName).getLOperand());
            if (string == null) {
                return null;
            }
            String left = string;
            Object object = ((SqlBinaryExpression)$this$asName).getROperand();
            if (object == null || (object = this.asName((SqlExpression)object)) == null) {
                return null;
            }
            Object right = object;
            return left + (String)right;
        }
        return null;
    }
}

