/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.couchbase.psi;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.couchbase.CouchbaseTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlJoinExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/couchbase/psi/CouchJoinExpression;", "Lcom/intellij/sql/psi/impl/SqlJoinExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "processImplicitContextDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "calcType", "Lcom/intellij/sql/psi/SqlTableType;", "end", "intellij.database.dialects.couchbase"})
public final class CouchJoinExpression
extends SqlJoinExpressionImpl {
    public CouchJoinExpression(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    public boolean processImplicitContextDeclarations(@Nullable SqlScopeProcessor processor, @Nullable ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        if (!super.processImplicitContextDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        IElementType opSign = PsiTreeUtilKt.getElementType((PsiElement)this.getOpSignElement());
        if (!Intrinsics.areEqual((Object)opSign, (Object)CouchbaseTypes.COUCH_UNNEST)) {
            return true;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)((PsiElement)this.getROperand()), (PsiElement)place, (boolean)false)) {
            return true;
        }
        return SqlImplUtil.processDeclarationsInType((SqlExpression)this.getLOperand(), (SqlScopeProcessor)processor, (ResolveState)state, (PsiElement)place);
    }

    @NotNull
    protected SqlTableType calcType(@Nullable PsiElement end) {
        IElementType opSign = PsiTreeUtilKt.getElementType((PsiElement)this.getOpSignElement());
        if (!Intrinsics.areEqual((Object)opSign, (Object)CouchbaseTypes.COUCH_UNNEST)) {
            super.calcType(end);
        }
        PsiElement lastToCheck = this.getLastToCheck(end);
        SqlExpression lOperand = this.getLOperand();
        DasType lType = SqlJoinExpressionImpl.getTypeLateralAware((SqlExpression)lOperand, (PsiElement)lastToCheck, (PsiElement)end);
        if (!(lType instanceof SqlTableType)) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"EMPTY_TABLE");
            return sqlTableType;
        }
        SqlExpression rOperand = this.getROperand();
        if (rOperand == null) {
            return (SqlTableType)lType;
        }
        List columns = CollectionsKt.listOf((Object)new SqlImplUtil.Column(rOperand.getName(), rOperand.getDasType(), (PsiElement)rOperand, null));
        SqlTableType sqlTableType = ((SqlTableType)lType).add(SqlImplUtil.createType(null, (List)columns, null));
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"add(...)");
        return sqlTableType;
    }
}

