/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.highlighting;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.MongoDBJsonLexer;
import com.intellij.persistence.mongodb.json.highlighting.MongoDBJsonSyntaxHighlighterFactoryKt;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/persistence/mongodb/json/highlighting/MongoDBJsonSyntaxHighlighterFactory;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterFactory;", "<init>", "()V", "getSyntaxHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLexer", "Lcom/intellij/lexer/Lexer;", "MyHighlighter", "intellij.javaee.persistence.impl"})
public class MongoDBJsonSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return (SyntaxHighlighter)new MyHighlighter();
    }

    @NotNull
    protected Lexer getLexer() {
        return (Lexer)new MongoDBJsonLexer();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/persistence/mongodb/json/highlighting/MongoDBJsonSyntaxHighlighterFactory$MyHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "<init>", "(Lcom/intellij/persistence/mongodb/json/highlighting/MongoDBJsonSyntaxHighlighterFactory;)V", "ourAttributes", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "getTokenHighlights", "", "type", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "gitSingleQuoteLexer", "getDoubleQuoteLexer", "intellij.javaee.persistence.impl"})
    private final class MyHighlighter
    extends SyntaxHighlighterBase {
        @NotNull
        private final Map<IElementType, TextAttributesKey> ourAttributes = new HashMap();

        public MyHighlighter() {
            IElementType[] iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.L_CURLY, MongoDBJsonElementTypes.R_CURLY};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACES(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.L_BRACKET, MongoDBJsonElementTypes.R_BRACKET};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BRACKETS(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.COMMA};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_COMMA(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.COLON};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_COLON(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.DOUBLE_QUOTED_STRING};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_STRING(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.SINGLE_QUOTED_STRING};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_STRING(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.NUMBER};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_NUMBER(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.TRUE, MongoDBJsonElementTypes.FALSE, MongoDBJsonElementTypes.NULL, MongoDBJsonElementTypes.NEW_KEYWORD};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_KEYWORD(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.LINE_COMMENT};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_LINE_COMMENT(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.BLOCK_COMMENT};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_BLOCK_COMMENT(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{MongoDBJsonElementTypes.IDENTIFIER};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_IDENTIFIER(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_VALID_ESCAPE(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_INVALID_ESCAPE(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_INVALID_ESCAPE(), (IElementType[])iElementTypeArray);
            iElementTypeArray = new IElementType[]{TokenType.BAD_CHARACTER};
            SyntaxHighlighterBase.fillMap(this.ourAttributes, (TextAttributesKey)HighlighterColors.BAD_CHARACTER, (IElementType[])iElementTypeArray);
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            LayeredLexer layeredLexer = new LayeredLexer(MongoDBJsonSyntaxHighlighterFactory.this.getLexer());
            Lexer lexer = this.getDoubleQuoteLexer();
            IElementType[] iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue((Object)MongoDBJsonElementTypes.DOUBLE_QUOTED_STRING, (String)"DOUBLE_QUOTED_STRING");
            layeredLexer.registerSelfStoppingLayer(lexer, iElementTypeArray, IElementType.EMPTY_ARRAY);
            Lexer lexer2 = this.gitSingleQuoteLexer();
            iElementTypeArray = new IElementType[1];
            Intrinsics.checkNotNullExpressionValue((Object)MongoDBJsonElementTypes.SINGLE_QUOTED_STRING, (String)"SINGLE_QUOTED_STRING");
            layeredLexer.registerSelfStoppingLayer(lexer2, iElementTypeArray, IElementType.EMPTY_ARRAY);
            return (Lexer)layeredLexer;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(@NotNull IElementType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)this.ourAttributes.get(type));
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"pack(...)");
            return textAttributesKeyArray;
        }

        private final Lexer gitSingleQuoteLexer() {
            IElementType iElementType = MongoDBJsonElementTypes.SINGLE_QUOTED_STRING;
            String string = MongoDBJsonSyntaxHighlighterFactoryKt.access$getPERMISSIVE_ESCAPES$p();
            return (Lexer)new StringLiteralLexer(iElementType, string){

                protected IElementType handleSingleSlashEscapeSequence() {
                    IElementType iElementType = this.myOriginalLiteralToken;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"myOriginalLiteralToken");
                    return iElementType;
                }

                protected boolean shouldAllowSlashZero() {
                    return true;
                }
            };
        }

        private final Lexer getDoubleQuoteLexer() {
            IElementType iElementType = MongoDBJsonElementTypes.DOUBLE_QUOTED_STRING;
            String string = MongoDBJsonSyntaxHighlighterFactoryKt.access$getPERMISSIVE_ESCAPES$p();
            return (Lexer)new StringLiteralLexer(iElementType, string){

                protected IElementType handleSingleSlashEscapeSequence() {
                    IElementType iElementType = this.myOriginalLiteralToken;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"myOriginalLiteralToken");
                    return iElementType;
                }

                protected boolean shouldAllowSlashZero() {
                    return true;
                }
            };
        }
    }
}

