/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/persistence/mongodb/json/psi/impl/MongoDBJsonPropertyNameReference;", "Lcom/intellij/psi/PsiReference;", "property", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;", "<init>", "(Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;)V", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "resolve", "getCanonicalText", "", "handleElementRename", "newElementName", "bindToElement", "element", "isReferenceTo", "", "isSoft", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonPropertyNameReference
implements PsiReference {
    @NotNull
    private final MongoDBJsonProperty property;

    public MongoDBJsonPropertyNameReference(@NotNull MongoDBJsonProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.property = property;
    }

    @NotNull
    public PsiElement getElement() {
        return this.property;
    }

    @NotNull
    public TextRange getRangeInElement() {
        MongoDBJsonValue mongoDBJsonValue = this.property.getNameElement();
        Intrinsics.checkNotNullExpressionValue((Object)mongoDBJsonValue, (String)"getNameElement(...)");
        MongoDBJsonValue nameElement = mongoDBJsonValue;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)nameElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return textRange;
    }

    @NotNull
    public PsiElement resolve() {
        return this.property;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.property.getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        return this.property.setName(newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof MongoDBJsonProperty)) {
            return false;
        }
        PsiElement selfResolve = this.resolve();
        return Intrinsics.areEqual((Object)((MongoDBJsonProperty)element).getName(), (Object)this.getCanonicalText()) && selfResolve != element;
    }

    public boolean isSoft() {
        return true;
    }
}

