/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.actions.HttpRequestBaseAction;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

public class HttpRequestDiffAction
extends HttpRequestBaseAction {
    private static final String ID = "HTTPClient.ShowDiff";
    private final HttpFilePath myFirstFilePath;
    private final HttpFilePath mySecondFilePath;

    public HttpRequestDiffAction(@NotNull HttpFilePath first, @NotNull HttpFilePath second) {
        if (first == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(0);
        }
        if (second == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(1);
        }
        this.myFirstFilePath = first;
        this.mySecondFilePath = second;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        this.getTemplatePresentation().setText(RestClientBundle.messagePointer("http.request.diff.compare.with.file", this.mySecondFilePath.getPresentablePath()));
        this.getTemplatePresentation().setDescription(RestClientBundle.messagePointer("http.request.diff.compare.with.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        PsiFile firstFile = FileReferenceUtil.findFile((PsiElement)this.myFirstFilePath);
        if (firstFile == null) {
            this.showErrorBalloon(RestClientBundle.message("http.request.diff.compare.with.can.not.resolve", this.myFirstFilePath.getPresentablePath()), e);
            return;
        }
        PsiFile secondFile = FileReferenceUtil.findFile((PsiElement)this.mySecondFilePath);
        if (secondFile == null) {
            this.showErrorBalloon(RestClientBundle.message("http.request.diff.compare.with.can.not.resolve", this.mySecondFilePath.getPresentablePath()), e);
            return;
        }
        DiffContent first = DiffContentFactory.getInstance().create(project, firstFile.getVirtualFile());
        DiffContent second = DiffContentFactory.getInstance().create(project, secondFile.getVirtualFile());
        String firstName = firstFile.getName();
        String secondName = secondFile.getName();
        String directories = HttpRequestDiffAction.getPresentableDirectories(firstFile.getVirtualFile().getPath(), secondFile.getVirtualFile().getPath());
        String title = RestClientBundle.message("http.request.diff.compare.with.dialog.title", firstName, secondName, directories);
        SimpleDiffRequest diffData = new SimpleDiffRequest(title, first, second, firstName, secondName);
        DiffManager.getInstance().showDiff(project, (DiffRequest)diffData);
    }

    public String getId() {
        return ID;
    }

    @NotNull
    private static String getPresentableDirectories(@NotNull String firstPath, @NotNull String secondPath) {
        String secondDirectory;
        String firstDirectory;
        if (firstPath == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(3);
        }
        if (secondPath == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(4);
        }
        if (FileUtil.pathsEqual((String)(firstDirectory = PathUtil.getParentPath((String)firstPath)), (String)(secondDirectory = PathUtil.getParentPath((String)secondPath)))) {
            String string = PathUtil.toSystemDependentName((String)firstDirectory);
            if (string == null) {
                HttpRequestDiffAction.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = RestClientBundle.message("http.request.diff.compare.with.dialog.title.directories", PathUtil.toSystemDependentName((String)firstDirectory), PathUtil.toSystemDependentName((String)secondDirectory));
        if (string == null) {
            HttpRequestDiffAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/codeInsight/HttpRequestDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/codeInsight/HttpRequestDiffAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDirectories";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

