/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.Credentials;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.externalProcessAuthHelper.ExternalProcessAuthHelperBundle;
import com.intellij.externalProcessAuthHelper.SshPrompts;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import externalApp.nativessh.NativeSshAskPassAppHandler;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00192\u00020\u0001:\t\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000b\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0012H\u0016J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u000b\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0012H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u000b\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0018H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;", "LexternalApp/nativessh/NativeSshAskPassAppHandler;", "project", "Lcom/intellij/openapi/project/Project;", "authenticationGate", "Lcom/intellij/externalProcessAuthHelper/AuthenticationGate;", "authenticationMode", "Lcom/intellij/externalProcessAuthHelper/AuthenticationMode;", "doNotRememberPasswords", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/externalProcessAuthHelper/AuthenticationGate;Lcom/intellij/externalProcessAuthHelper/AuthenticationMode;Z)V", "passwordHandlers", "", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptHandler;", "handleInput", "", "description", "Lcom/intellij/openapi/util/NlsSafe;", "doHandleInput", "askGenericInput", "Lorg/jetbrains/annotations/Nls;", "askUserOnEdt", "query", "Lkotlin/Function0;", "Companion", "KeyPassphrasePromptHandler", "SshPasswordPromptHandler", "SshPinPromptHandler", "PasswordPromptHandler", "ConfirmationPromptHandler", "PromptHandler", "PromptAnswer", "Prompt", "intellij.platform.externalProcessAuthHelper"})
@SourceDebugExtension(value={"SMAP\nNativeSshGuiAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeSshGuiAuthenticator.kt\ncom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n13#2:190\n*S KotlinDebug\n*F\n+ 1 NativeSshGuiAuthenticator.kt\ncom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator\n*L\n24#1:190\n*E\n"})
public final class NativeSshGuiAuthenticator
implements NativeSshAskPassAppHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final AuthenticationGate authenticationGate;
    @NotNull
    private final AuthenticationMode authenticationMode;
    private final boolean doNotRememberPasswords;
    @NotNull
    private final List<PromptHandler> passwordHandlers;
    @NotNull
    private static final Logger LOG;

    public NativeSshGuiAuthenticator(@Nullable Project project, @NotNull AuthenticationGate authenticationGate, @NotNull AuthenticationMode authenticationMode, boolean doNotRememberPasswords) {
        Intrinsics.checkNotNullParameter((Object)authenticationGate, (String)"authenticationGate");
        Intrinsics.checkNotNullParameter((Object)((Object)authenticationMode), (String)"authenticationMode");
        this.project = project;
        this.authenticationGate = authenticationGate;
        this.authenticationMode = authenticationMode;
        this.doNotRememberPasswords = doNotRememberPasswords;
        Object[] objectArray = new PromptHandler[]{new KeyPassphrasePromptHandler(), new SshPasswordPromptHandler(), new SshPinPromptHandler(), new ConfirmationPromptHandler()};
        this.passwordHandlers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public String handleInput(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        LOG.debug("handleInput: " + description + ", mode: " + this.authenticationMode);
        if (this.authenticationMode == AuthenticationMode.NONE) {
            LOG.debug("authenticationMode: NONE");
            return null;
        }
        return this.authenticationGate.waitAndCompute(() -> NativeSshGuiAuthenticator.handleInput$lambda$0(this, description));
    }

    private final String doHandleInput(String description) {
        for (PromptHandler passwordHandler : this.passwordHandlers) {
            PromptAnswer answer = passwordHandler.handleInput(description);
            if (!(answer instanceof PromptAnswer.Answer)) continue;
            LOG.debug("handling using: " + passwordHandler);
            return ((PromptAnswer.Answer)answer).getValue();
        }
        LOG.debug("handling using generic prompt");
        return this.askGenericInput(description);
    }

    private final String askGenericInput(String description) {
        return this.askUserOnEdt((Function0<String>)((Function0)() -> NativeSshGuiAuthenticator.askGenericInput$lambda$0(this, description)));
    }

    private final String askUserOnEdt(Function0<String> query) {
        return this.authenticationMode != AuthenticationMode.FULL ? null : (String)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), query);
    }

    private static final String handleInput$lambda$0(NativeSshGuiAuthenticator this$0, String $description) {
        return this$0.doHandleInput($description);
    }

    private static final String askGenericInput$lambda$0(NativeSshGuiAuthenticator this$0, String $description) {
        return Messages.showPasswordDialog((Project)this$0.project, (String)$description, (String)ExternalProcessAuthHelperBundle.message("ssh.keyboard.interactive.title", new Object[0]), null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NativeSshGuiAuthenticator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalProcessAuthHelper"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$ConfirmationPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptHandler;", "<init>", "(Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;)V", "lastAskedConfirmationInput", "", "handleInput", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "description", "intellij.platform.externalProcessAuthHelper"})
    private final class ConfirmationPromptHandler
    implements PromptHandler {
        @Nullable
        private String lastAskedConfirmationInput;

        @Override
        @NotNull
        public PromptAnswer handleInput(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            if (!StringsKt.contains$default((CharSequence)description, (CharSequence)"Are you sure you want to continue connecting", (boolean)false, (int)2, null)) {
                return PromptAnswer.NotHandled.INSTANCE;
            }
            String answer = NativeSshGuiAuthenticator.this.askUserOnEdt((Function0<String>)() -> ConfirmationPromptHandler.handleInput$lambda$0(description, NativeSshGuiAuthenticator.this, this));
            return new PromptAnswer.Answer(answer);
        }

        private static final String handleInput$lambda$0(String $description, NativeSshGuiAuthenticator this$0, ConfirmationPromptHandler this$1) {
            String string = SshPrompts.stripConfirmConnectionOptions($description);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripConfirmConnectionOptions(...)");
            String message = string;
            String knownAnswer = this$0.authenticationGate.getSavedInput(message);
            if (knownAnswer != null && this$1.lastAskedConfirmationInput == null) {
                this$1.lastAskedConfirmationInput = knownAnswer;
                return knownAnswer;
            }
            int answer = Messages.showYesNoDialog((Project)this$0.project, (String)message, (String)ExternalProcessAuthHelperBundle.message("title.ssh.confirmation", new Object[0]), null);
            String textAnswer = switch (answer) {
                case 0 -> "yes";
                case 1 -> "no";
                default -> throw new AssertionError(answer);
            };
            this$0.authenticationGate.saveInput(message, textAnswer);
            return textAnswer;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$KeyPassphrasePromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PasswordPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;", "<init>", "(Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;)V", "title", "", "getTitle", "()Ljava/lang/String;", "serviceName", "getServiceName", "parseDescription", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Prompt;", "description", "intellij.platform.externalProcessAuthHelper"})
    private final class KeyPassphrasePromptHandler
    extends PasswordPromptHandler {
        @NotNull
        private final String title;
        @NotNull
        private final String serviceName;

        public KeyPassphrasePromptHandler() {
            String string = ExternalProcessAuthHelperBundle.message("ssh.ask.passphrase.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.title = string;
            String string2 = ExternalProcessAuthHelperBundle.message("label.credential.store.key.ssh.passphrase", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.serviceName = string2;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        @NotNull
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @Nullable
        public Prompt parseDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Matcher matcher = SshPrompts.PASSPHRASE_PROMPT.matcher(description);
            if (!matcher.matches()) {
                return null;
            }
            String keyPath = SshPrompts.extractKeyPath(matcher);
            Object[] objectArray = new Object[]{keyPath};
            String string = ExternalProcessAuthHelperBundle.message("ssh.ask.passphrase.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String promptMessage = string;
            Intrinsics.checkNotNull((Object)keyPath);
            return new Prompt(keyPath, promptMessage);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J$\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PasswordPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptHandler;", "<init>", "(Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;)V", "lastAskedKey", "", "title", "getTitle", "()Ljava/lang/String;", "serviceName", "getServiceName", "parseDescription", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Prompt;", "description", "handleInput", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "askPassword", "project", "Lcom/intellij/openapi/project/Project;", "prompt", "resetPassword", "", "intellij.platform.externalProcessAuthHelper"})
    private abstract class PasswordPromptHandler
    implements PromptHandler {
        @Nullable
        private String lastAskedKey;

        @NotNull
        public abstract String getTitle();

        @NotNull
        public abstract String getServiceName();

        @Nullable
        public abstract Prompt parseDescription(@NotNull String var1);

        @Override
        @NotNull
        public PromptAnswer handleInput(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Prompt prompt = this.parseDescription(description);
            if (prompt == null) {
                return PromptAnswer.NotHandled.INSTANCE;
            }
            boolean resetPassword = Intrinsics.areEqual((Object)prompt.getAskedKey(), (Object)this.lastAskedKey);
            this.lastAskedKey = prompt.getAskedKey();
            String answer = this.askPassword(NativeSshGuiAuthenticator.this.project, prompt, resetPassword);
            return new PromptAnswer.Answer(answer);
        }

        private final String askPassword(Project project, Prompt prompt, boolean resetPassword) {
            String password;
            Credentials credentials;
            if (NativeSshGuiAuthenticator.this.authenticationMode == AuthenticationMode.NONE) {
                return null;
            }
            if (NativeSshGuiAuthenticator.this.doNotRememberPasswords) {
                return NativeSshGuiAuthenticator.this.askUserOnEdt((Function0<String>)() -> PasswordPromptHandler.askPassword$lambda$0(project, prompt, this));
            }
            String serviceName = CredentialAttributesKt.generateServiceName((String)this.getServiceName(), (String)prompt.getAskedKey());
            CredentialAttributes credentialAttributes = new CredentialAttributes(serviceName, prompt.getAskedKey());
            if (!resetPassword && (credentials = PasswordSafe.Companion.getInstance().get(credentialAttributes)) != null && (password = credentials.getPasswordAsString()) != null) {
                return password;
            }
            if (NativeSshGuiAuthenticator.this.authenticationMode == AuthenticationMode.SILENT) {
                return null;
            }
            return CredentialPromptDialog.askPassword$default((Project)project, (String)this.getTitle(), (String)prompt.getPromptMessage(), (CredentialAttributes)credentialAttributes, (boolean)true, null, (int)32, null);
        }

        private static final String askPassword$lambda$0(Project $project, Prompt $prompt, PasswordPromptHandler this$0) {
            return Messages.showPasswordDialog((Project)$project, (String)$prompt.getPromptMessage(), (String)this$0.getTitle(), null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005H\u00c6\u0001J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Prompt;", "", "askedKey", "", "promptMessage", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getAskedKey", "()Ljava/lang/String;", "getPromptMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalProcessAuthHelper"})
    private static final class Prompt {
        @NotNull
        private final String askedKey;
        @NotNull
        private final String promptMessage;

        public Prompt(@NotNull String askedKey, @NotNull String promptMessage) {
            Intrinsics.checkNotNullParameter((Object)askedKey, (String)"askedKey");
            Intrinsics.checkNotNullParameter((Object)promptMessage, (String)"promptMessage");
            this.askedKey = askedKey;
            this.promptMessage = promptMessage;
        }

        @NotNull
        public final String getAskedKey() {
            return this.askedKey;
        }

        @NotNull
        public final String getPromptMessage() {
            return this.promptMessage;
        }

        @NotNull
        public final String component1() {
            return this.askedKey;
        }

        @NotNull
        public final String component2() {
            return this.promptMessage;
        }

        @NotNull
        public final Prompt copy(@NotNull String askedKey, @NotNull String promptMessage) {
            Intrinsics.checkNotNullParameter((Object)askedKey, (String)"askedKey");
            Intrinsics.checkNotNullParameter((Object)promptMessage, (String)"promptMessage");
            return new Prompt(askedKey, promptMessage);
        }

        public static /* synthetic */ Prompt copy$default(Prompt prompt, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = prompt.askedKey;
            }
            if ((n & 2) != 0) {
                string2 = prompt.promptMessage;
            }
            return prompt.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Prompt(askedKey=" + this.askedKey + ", promptMessage=" + this.promptMessage + ")";
        }

        public int hashCode() {
            int result = this.askedKey.hashCode();
            result = result * 31 + this.promptMessage.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Prompt)) {
                return false;
            }
            Prompt prompt = (Prompt)other;
            if (!Intrinsics.areEqual((Object)this.askedKey, (Object)prompt.askedKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.promptMessage, (Object)prompt.promptMessage);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "", "NotHandled", "Answer", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer$Answer;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer$NotHandled;", "intellij.platform.externalProcessAuthHelper"})
    private static sealed interface PromptAnswer {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer$Answer;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.externalProcessAuthHelper"})
        public static final class Answer
        implements PromptAnswer {
            @Nullable
            private final String value;

            public Answer(@Nullable String value) {
                this.value = value;
            }

            @Nullable
            public final String getValue() {
                return this.value;
            }

            @Nullable
            public final String component1() {
                return this.value;
            }

            @NotNull
            public final Answer copy(@Nullable String value) {
                return new Answer(value);
            }

            public static /* synthetic */ Answer copy$default(Answer answer, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = answer.value;
                }
                return answer.copy(string);
            }

            @NotNull
            public String toString() {
                return "Answer(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value == null ? 0 : this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Answer)) {
                    return false;
                }
                Answer answer = (Answer)other;
                return Intrinsics.areEqual((Object)this.value, (Object)answer.value);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer$NotHandled;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.externalProcessAuthHelper"})
        public static final class NotHandled
        implements PromptAnswer {
            @NotNull
            public static final NotHandled INSTANCE = new NotHandled();

            private NotHandled() {
            }

            @NotNull
            public String toString() {
                return "NotHandled";
            }

            public int hashCode() {
                return -396388302;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotHandled)) {
                    return false;
                }
                NotHandled cfr_ignored_0 = (NotHandled)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptHandler;", "", "handleInput", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PromptAnswer;", "description", "", "intellij.platform.externalProcessAuthHelper"})
    private static interface PromptHandler {
        @NotNull
        public PromptAnswer handleInput(@NotNull String var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$SshPasswordPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PasswordPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;", "<init>", "(Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;)V", "title", "", "getTitle", "()Ljava/lang/String;", "serviceName", "getServiceName", "parseDescription", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Prompt;", "description", "intellij.platform.externalProcessAuthHelper"})
    private final class SshPasswordPromptHandler
    extends PasswordPromptHandler {
        @NotNull
        private final String title;
        @NotNull
        private final String serviceName;

        public SshPasswordPromptHandler() {
            String string = ExternalProcessAuthHelperBundle.message("ssh.password.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.title = string;
            String string2 = ExternalProcessAuthHelperBundle.message("label.credential.store.key.ssh.password", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.serviceName = string2;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        @NotNull
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @Nullable
        public Prompt parseDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Matcher matcher = SshPrompts.PASSWORD_PROMPT.matcher(description);
            if (!matcher.matches()) {
                return null;
            }
            String username = SshPrompts.extractUsername(matcher);
            Object[] objectArray = new Object[]{username};
            String string = ExternalProcessAuthHelperBundle.message("ssh.password.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String promptMessage = string;
            Intrinsics.checkNotNull((Object)username);
            return new Prompt(username, promptMessage);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$SshPinPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$PasswordPromptHandler;", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;", "<init>", "(Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator;)V", "title", "", "getTitle", "()Ljava/lang/String;", "serviceName", "getServiceName", "parseDescription", "Lcom/intellij/externalProcessAuthHelper/NativeSshGuiAuthenticator$Prompt;", "description", "intellij.platform.externalProcessAuthHelper"})
    private final class SshPinPromptHandler
    extends PasswordPromptHandler {
        @NotNull
        private final String title;
        @NotNull
        private final String serviceName;

        public SshPinPromptHandler() {
            String string = ExternalProcessAuthHelperBundle.message("ssh.ask.pin.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.title = string;
            String string2 = ExternalProcessAuthHelperBundle.message("label.credential.store.key.ssh.pin", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.serviceName = string2;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        @NotNull
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        @Nullable
        public Prompt parseDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Matcher matcher = SshPrompts.PKCS_PIN_TOKEN_PROMPT.matcher(description);
            if (!matcher.matches()) {
                return null;
            }
            String username = SshPrompts.extractPkcsTokenLabel(matcher);
            Object[] objectArray = new Object[]{username};
            String string = ExternalProcessAuthHelperBundle.message("ssh.ask.pin.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String promptMessage = string;
            Intrinsics.checkNotNull((Object)username);
            return new Prompt(username, promptMessage);
        }
    }
}

