/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DuplicatesModel {
    private final TreeSelectionModel mySelectionModel = new DefaultTreeSelectionModel();
    private final MyTreeModel myTreeModel;
    private final EventDispatcher<Listener> myListeners = EventDispatcher.create(Listener.class);
    private final Project myProject;
    private GroupNode myCurrentGroup;
    private final int[] myDiffIndices = new int[]{-1, -1};

    public DuplicatesModel(DupInfo duplicates, Project project) {
        this.myProject = project;
        DuplicatesRoot duplicatesRoot = new DuplicatesRoot(duplicates, this);
        this.myTreeModel = new MyTreeModel(duplicatesRoot);
        this.mySelectionModel.setSelectionMode(1);
        this.mySelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                DuplicatesModel.this.j();
            }
        });
        this.mySelectionModel.setSelectionPath(new TreePath(new Object[]{duplicatesRoot, duplicatesRoot.getChildAt(0)}));
    }

    @Nullable
    public CodeNode getRight() {
        if (this.myCurrentGroup == null) {
            return null;
        }
        return this.myCurrentGroup.getChildAt(this.myDiffIndices[1]);
    }

    @Nullable
    public CodeNode getLeft() {
        if (this.myCurrentGroup == null) {
            return null;
        }
        return this.myCurrentGroup.getChildAt(this.myDiffIndices[0]);
    }

    @Nullable
    private TreeNode j() {
        TreePath treePath = this.mySelectionModel.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (TreeNode)treePath.getLastPathComponent();
    }

    private void j() {
        TreeNode treeNode = this.j();
        GroupNode groupNode = null;
        if (treeNode != null) {
            if (treeNode instanceof GroupNode) {
                groupNode = (GroupNode)treeNode;
            } else {
                TreeNode treeNode2 = treeNode.getParent();
                if (treeNode2 instanceof GroupNode) {
                    groupNode = (GroupNode)treeNode2;
                }
            }
        }
        this.j(groupNode);
    }

    private void j(GroupNode groupNode) {
        if (Comparing.equal((Object)this.myCurrentGroup, (Object)groupNode)) {
            return;
        }
        if (groupNode != null) {
            this.j(groupNode, 0, 1);
        } else {
            this.j(null, -1, -1);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public void addListener(Listener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    public TreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public CodeNode getSelectedCodeNode() {
        TreeNode treeNode = this.j();
        return treeNode instanceof CodeNode ? (CodeNode)treeNode : null;
    }

    public DuplicatesRoot getRoot() {
        return this.myTreeModel.getRoot();
    }

    public void setDiff(int diffIndex, CodeNode codeNode) {
        GroupNode groupNode = codeNode.getParent();
        int n10 = groupNode.getIndexOf(codeNode);
        if (Comparing.equal((Object)groupNode, (Object)this.myCurrentGroup)) {
            if (n10 == this.myDiffIndices[diffIndex]) {
                return;
            }
            this.myDiffIndices[diffIndex] = n10;
            ((Listener)this.myListeners.getMulticaster()).onSelectionChanged();
        } else if (diffIndex == 0) {
            this.j(groupNode, n10, 1);
        } else {
            this.j(groupNode, 0, n10);
        }
    }

    private void j(GroupNode groupNode, int n10, int n11) {
        if (Comparing.equal((Object)this.myCurrentGroup, (Object)groupNode) && n10 == this.myDiffIndices[0] && n11 == this.myDiffIndices[1]) {
            return;
        }
        this.myCurrentGroup = groupNode;
        this.myDiffIndices[0] = n10;
        this.myDiffIndices[1] = n11;
        ((Listener)this.myListeners.getMulticaster()).onSelectionChanged();
    }

    public static interface Listener
    extends EventListener {
        public void onSelectionChanged();
    }

    private static class MyTreeModel
    extends DefaultTreeModel {
        MyTreeModel(DuplicatesRoot root) {
            super(root);
        }

        @Override
        public DuplicatesRoot getRoot() {
            return (DuplicatesRoot)super.getRoot();
        }
    }
}

