/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final GroupNode[] myGroupNodes;
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";
    private final DuplicatesRoot myRoot;

    ExportHTMLAction(DuplicatesRoot root) {
        super(InspectionsBundle.messagePointer((String)"action.ExportHTMLAction.text", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export);
        this.myGroupNodes = root.getChildren();
        this.myRoot = root;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            ExportHTMLAction.j(0);
        }
        final Project project = (Project)e2.getData(CommonDataKeys.PROJECT);
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.j(project, Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InputEvent inputEvent = e2.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            listPopup.showUnderneathOf(inputEvent.getComponent());
        } else {
            listPopup.showInBestPositionFor(e2.getDataContext());
        }
    }

    private void j(Project project, boolean bl) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(project, true);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance((Project)project);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        Path path = Paths.get(exportToHTMLSettings.OUTPUT_DIRECTORY, new String[0]);
        try {
            if (bl) {
                int n10 = 0;
                @NlsSafe StringBuffer stringBuffer = new StringBuffer();
                for (GroupNode groupNode : this.myGroupNodes) {
                    String string = "group" + n10++;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (CodeNode codeNode : groupNode.getChildren()) {
                        ExportHTMLAction.j(project, path, string, stringBuffer2, codeNode);
                    }
                    @NlsSafe String object = string + "-index.html";
                    HTMLExportUtil.writeFile((Path)path, (String)object, (Project)project, writer -> writer.write(XmlStringUtil.wrapInHtml((CharSequence)stringBuffer2)));
                    stringBuffer.append("<a href=\"").append(StringUtil.escapeXmlEntities((String)object)).append("\" target=\"codeFragmentFrame\">").append(string).append(" (").append(groupNode.getTitle(false).getText()).append(")").append("</a>").append("<br>");
                }
                HTMLExportUtil.writeFile((Path)path, (String)"groupIndex.html", (Project)project, writer -> writer.write(XmlStringUtil.wrapInHtml((CharSequence)stringBuffer)));
                ExportHTMLAction.j(project, path);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((Path)path.resolve("index.html"));
                }
            } else {
                DuplocatorHashCallback.writeDuplicates((Path)path, (Project)project, (DupInfo)this.myRoot.getDuplicates());
            }
        }
        catch (Exception exception) {
            Messages.showErrorDialog((Project)project, (String)exception.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void j(Project project, @NotNull Path path, @NlsSafe String string, StringBuffer stringBuffer, CodeNode codeNode) throws InvalidatedException {
        if (path == null) {
            ExportHTMLAction.j(1);
        }
        PsiFragment psiFragment = codeNode.getFragment();
        VirtualFile virtualFile = codeNode.getVirtualFile();
        TextRange textRange = codeNode.getTextRange();
        PsiFile psiFile = psiFragment.getFile();
        if (psiFile == null) {
            return;
        }
        String string2 = textRange.substring(psiFile.getText());
        String string3 = string + "/" + virtualFile.getNameWithoutExtension() + psiFragment.getStartOffset() + ".html";
        @NlsSafe StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<head><h4>");
        stringBuffer2.append(codeNode.getTitle(false).getText());
        stringBuffer2.append("</h4></head>");
        stringBuffer2.append("<body>");
        stringBuffer2.append(StringUtil.escapeXmlEntities((String)string2).replace("\n", "<br>"));
        stringBuffer2.append("</body>");
        HTMLExportUtil.writeFile((Path)path, (String)string3, (Project)project, writer -> writer.write(XmlStringUtil.wrapInHtml((CharSequence)stringBuffer2)));
        @NlsSafe String string4 = "<a href=\"" + StringUtil.escapeXmlEntities((String)string3) + "\" target=\"elementFrame\">" + virtualFile.getPath() + "</a><br>";
        stringBuffer.append(string4);
    }

    private static void j(@NotNull Project project, @NotNull Path path) {
        if (project == null) {
            ExportHTMLAction.j(2);
        }
        if (path == null) {
            ExportHTMLAction.j(3);
        }
        String string = DupLocatorBundle.message((String)"duplicates.export.html.page.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        @NlsSafe String string2 = "<HTML><HEAD><TITLE>" + string + "</TITLE></HEAD><FRAMESET cols=\"30%,70%\">  <FRAMESET rows=\"30%,70%\">    <FRAME src=\"groupIndex.html\" name=\"groupFrame\">    <FRAME src=\"group0-index.html\" name=\"codeFragmentFrame\">  </FRAMESET>  <FRAME src=\"empty.html\" name=\"elementFrame\"></FRAMESET></BODY></HTML";
        HTMLExportUtil.writeFile((Path)path, (String)"index.html", (Project)project, writer -> writer.write(string2));
        HTMLExportUtil.writeFile((Path)path, (String)"empty.html", (Project)project, writer -> writer.write(""));
    }

    private static /* synthetic */ void j(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/resultUI/ExportHTMLAction";
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "outputCodeFragment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "outputMainFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

