/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.WorkspaceDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0002J\"\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/model/DataClassResolver;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "projectDataManager", "Lcom/intellij/openapi/externalSystem/service/project/ProjectDataManager;", "kotlin.jvm.PlatformType", "managerClassLoaders", "", "Ljava/lang/ClassLoader;", "getClassLoadersToSearch", "hostObject", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "resolve", "Ljava/lang/Class;", "name", "", "intellij.platform.externalSystem"})
@SourceDebugExtension(value={"SMAP\nserialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serialization.kt\ncom/intellij/openapi/externalSystem/model/DataClassResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1586#2:108\n1661#2,3:109\n1404#2:112\n1496#2,5:113\n*S KotlinDebug\n*F\n+ 1 serialization.kt\ncom/intellij/openapi/externalSystem/model/DataClassResolver\n*L\n34#1:108\n34#1:109,3\n19#1:112\n19#1:113,5\n*E\n"})
final class DataClassResolver {
    @NotNull
    private final Logger log;
    private final ProjectDataManager projectDataManager;
    @NotNull
    private final Set<ClassLoader> managerClassLoaders;

    public DataClassResolver(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.projectDataManager = ProjectDataManager.getInstance();
        this.managerClassLoaders = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)ExternalSystemManager.EP_NAME.lazySequence(), DataClassResolver::managerClassLoaders$lambda$0), DataClassResolver::managerClassLoaders$lambda$1));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ClassLoader> getClassLoadersToSearch(DataNode<?> hostObject) {
        void $this$mapTo$iv$iv;
        if (hostObject == null) {
            return this.managerClassLoaders;
        }
        Intrinsics.checkNotNull((Object)this.projectDataManager);
        List<ProjectDataService<?, ?>> list = this.projectDataManager.findService(hostObject.getKey());
        Intrinsics.checkNotNullExpressionValue(list, (String)"findService(...)");
        Collection collection = list;
        List<WorkspaceDataService<?>> list2 = this.projectDataManager.findWorkspaceService(hostObject.getKey());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"findWorkspaceService(...)");
        List services = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        if (services.isEmpty()) {
            return this.managerClassLoaders;
        }
        Iterable $this$map$iv = services;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getClass().getClassLoader());
        }
        List serviceClassLoaders = (List)destination$iv$iv;
        LinkedHashSet set = new LinkedHashSet(this.managerClassLoaders.size() + serviceClassLoaders.size());
        set.addAll(serviceClassLoaders);
        set.addAll(this.managerClassLoaders);
        return set;
    }

    @Nullable
    public final Class<?> resolve(@NotNull String name, @Nullable DataNode<?> hostObject) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Set<ClassLoader> classLoadersToSearch = this.getClassLoadersToSearch(hostObject);
        PluginException pe = null;
        for (ClassLoader classLoader : classLoadersToSearch) {
            try {
                return classLoader.loadClass(name);
            }
            catch (PluginException e) {
                if (pe != null) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)pe);
                }
                pe = e;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        this.log.warn("ExternalProjectsDataStorage deserialization: Cannot find class `" + name + "`", (Throwable)pe);
        if (pe != null) {
            throw pe;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable managerClassLoaders$lambda$0(ExternalSystemManager it) {
        void $this$flatMapTo$iv$iv;
        List<ExtensionPointName<?>> list = it.getExtensionPointsForResolver();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExtensionPointsForResolver(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ExtensionPointName it2 = (ExtensionPointName)element$iv$iv;
            boolean bl = false;
            Sequence list$iv$iv = it2.lazySequence();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)it);
    }

    private static final ClassLoader managerClassLoaders$lambda$1(Object it) {
        return it.getClass().getClassLoader();
    }
}

