/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker;

import com.intellij.packageChecker.PackageCheckerIcons;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.Severity;
import com.intellij.packageChecker.toolwindow.tree.nodes.State;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"severityIcon", "Ljavax/swing/Icon;", "severity", "Lcom/intellij/packageChecker/model/Severity;", "severityTreeIcon", "transitiveSeverityTreeIcon", "dependencyNodeIcon", "nodeState", "Lcom/intellij/packageChecker/toolwindow/tree/nodes/State;", "matchCoordinates", "", "it", "Lcom/intellij/packageChecker/model/Package;", "intellij.packageChecker"})
public final class PackageUtilKt {
    @NotNull
    public static final Icon severityIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.Severity.Lowall;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.Severity.Medall;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.Severity.Highall;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon severityTreeIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.Severity.Lowall_tree;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall_tree");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.Severity.Medall_tree;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall_tree");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.Severity.Highall_tree;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall_tree");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon transitiveSeverityTreeIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.SeverityEmpty.Lowall_tree_outline;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall_tree_outline");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.SeverityEmpty.Medall_tree_outline;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall_tree_outline");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.SeverityEmpty.Highall_tree_outline;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall_tree_outline");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon dependencyNodeIcon(@NotNull State nodeState) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)nodeState, (String)"nodeState");
        if (nodeState.getMaxSeverity() == null) {
            Icon icon2 = PackageCheckerIcons.Severity.UncheckedAllTree;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"UncheckedAllTree");
        } else if (nodeState.getHasVulnerability()) {
            icon = PackageUtilKt.severityTreeIcon(nodeState.getMaxSeverity());
        } else if (nodeState.getHasTransitiveVulnerability()) {
            icon = PackageUtilKt.transitiveSeverityTreeIcon(nodeState.getMaxSeverity());
        } else {
            Icon icon3 = PackageCheckerIcons.Severity.SafeAllTree;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SafeAllTree");
        }
        return icon;
    }

    @NotNull
    public static final String matchCoordinates(@NotNull Package it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNamespace() + ":" + it.getName();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.Type.values().length];
            try {
                nArray[Severity.Type.Low.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Medium.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.High.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Critical.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

