/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.gradle.workaround;

import com.intellij.packageChecker.gradle.workaround.GradleCommonUtilsKt;
import com.intellij.packageChecker.model.Package;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/packageChecker/gradle/workaround/GradleGroovyVulnerablePackageFix;", "", "pkg", "Lcom/intellij/packageChecker/model/Package;", "<init>", "(Lcom/intellij/packageChecker/model/Package;)V", "doFix", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "fixGCompoundString", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl;", "fixGrArgumentList", "grArgumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentList;", "fixLiteral", "grLiteral", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteralContainer;", "intellij.packageChecker.gradle"})
public final class GradleGroovyVulnerablePackageFix {
    @NotNull
    private final Package pkg;

    public GradleGroovyVulnerablePackageFix(@NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        this.pkg = pkg;
    }

    public final void doFix(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof GrStringImpl) {
            this.fixGCompoundString((GrStringImpl)psiElement);
        } else if (psiElement2 instanceof GrArgumentList) {
            this.fixGrArgumentList((GrArgumentList)psiElement);
        } else if (psiElement2 instanceof GrLiteralContainer) {
            this.fixLiteral((GrLiteralContainer)psiElement);
        }
    }

    private final void fixGCompoundString(GrStringImpl element) {
        Package package_;
        Package $this$fixGCompoundString_u24lambda_u240 = package_ = this.pkg;
        boolean bl = false;
        GrInspectionUtil.replaceExpression((GrExpression)((GrExpression)element), (String)("\"" + $this$fixGCompoundString_u24lambda_u240.getNamespace() + ":" + $this$fixGCompoundString_u24lambda_u240.getName() + ":" + $this$fixGCompoundString_u24lambda_u240.getVersion() + "\""));
    }

    private final void fixGrArgumentList(GrArgumentList grArgumentList) {
        GrExpression grExpression;
        GrNamedArgument grNamedArgument = grArgumentList.findNamedArgument("version");
        if (grNamedArgument == null || (grExpression = grNamedArgument.getExpression()) == null) {
            return;
        }
        GrExpression versionLiteral = grExpression;
        GrInspectionUtil.replaceExpression((GrExpression)versionLiteral, (String)("'" + this.pkg.getVersion() + "'"));
    }

    private final void fixLiteral(GrLiteralContainer grLiteral) {
        GrLiteralContainer grLiteralContainer = grLiteral;
        try {
            GrLiteralContainer $this$fixLiteral_u24lambda_u240 = grLiteralContainer;
            boolean bl = false;
            Object object = grLiteral.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String patchedDependencyNotation = GradleCommonUtilsKt.patchDependencyNotation((String)object, this.pkg.getVersion().getValue());
            Object object2 = Result.constructor-impl((Object)((GrLiteralContainer)ElementManipulators.handleContentChange((PsiElement)((PsiElement)grLiteral), (String)patchedDependencyNotation)));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

