/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.PackagesInterner;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.model.SingleVersion;
import com.intellij.packageChecker.model.utils.StringUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000J\n\u0010\u001d\u001a\u00020\u001eH\u0096\u0080\u0004J\u0014\u0010\u001f\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\u0006\u0010 \u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/model/Package;", "", "type", "Lcom/intellij/packageChecker/model/PackageType;", "namespace", "", "name", "version", "Lcom/intellij/packageChecker/model/SingleVersion;", "coordinates", "searchCoordinates", "searchKey", "<init>", "(Lcom/intellij/packageChecker/model/PackageType;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/packageChecker/model/SingleVersion;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getType", "()Lcom/intellij/packageChecker/model/PackageType;", "getNamespace", "()Ljava/lang/String;", "getName", "getVersion", "()Lcom/intellij/packageChecker/model/SingleVersion;", "getCoordinates", "getSearchCoordinates", "getSearchKey", "humanReadableCoordinates", "getHumanReadableCoordinates", "matches", "", "other", "hashCode", "", "equals", "humanReadableCoordinatesWithoutType", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Package.kt\ncom/intellij/packageChecker/model/Package\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class Package {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PackageType type;
    @Nullable
    private final String namespace;
    @NotNull
    private final String name;
    @NotNull
    private final SingleVersion version;
    @NotNull
    private final String coordinates;
    @NotNull
    private final String searchCoordinates;
    @NotNull
    private final String searchKey;
    @NotNull
    private final String humanReadableCoordinates;

    /*
     * WARNING - void declaration
     */
    private Package(PackageType type, String namespace, String name, SingleVersion version, String coordinates, String searchCoordinates, String searchKey) {
        Object object;
        PackageType packageType;
        block3: {
            block2: {
                void it;
                this.type = type;
                this.namespace = namespace;
                this.name = name;
                this.version = version;
                this.coordinates = coordinates;
                this.searchCoordinates = searchCoordinates;
                this.searchKey = searchKey;
                Package package_ = this;
                packageType = this.type;
                object = this.namespace;
                if (object == null) break block2;
                String string = object;
                PackageType packageType2 = packageType;
                Package package_2 = package_;
                boolean bl = false;
                String string2 = ":" + (String)it;
                package_ = package_2;
                packageType = packageType2;
                String string3 = string2;
                object = string3;
                if (string3 != null) break block3;
            }
            object = "";
        }
        package_.humanReadableCoordinates = packageType + (String)object + ":" + this.name + ":" + this.version;
    }

    /* synthetic */ Package(PackageType packageType, String string, String string2, SingleVersion singleVersion, String object, String object2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            object = packageType + ":" + string + ":" + string2 + ":" + singleVersion;
        }
        if ((n & 0x20) != 0) {
            object2 = string + ":" + string2 + ":" + singleVersion;
        }
        if ((n & 0x40) != 0) {
            Object[] objectArray = new Object[]{packageType.name() + ":" + (String)object2};
            string3 = StringUtils.INSTANCE.calculateContentsHashSha256(objectArray);
        }
        this(packageType, string, string2, singleVersion, (String)object, (String)object2, string3);
    }

    @NotNull
    public final PackageType getType() {
        return this.type;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final SingleVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final String getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final String getSearchCoordinates() {
        return this.searchCoordinates;
    }

    @NotNull
    public final String getSearchKey() {
        return this.searchKey;
    }

    @NotNull
    public final String getHumanReadableCoordinates() {
        return this.humanReadableCoordinates;
    }

    public final boolean matches(@NotNull Package other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !Intrinsics.areEqual((Object)this.name, (Object)other.name) ? false : (this.type != other.type ? false : (!this.version.checkIfAnyVersion() && !other.version.checkIfAnyVersion() && !Intrinsics.areEqual((Object)this.version, (Object)other.version) ? false : Intrinsics.areEqual((Object)this.namespace, (Object)other.namespace)));
    }

    public int hashCode() {
        int result = this.type.hashCode();
        String string = this.namespace;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Package)) {
            return false;
        }
        if (this.type != ((Package)other).type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)((Package)other).namespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Package)other).name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)((Package)other).version);
    }

    @NotNull
    public final String humanReadableCoordinatesWithoutType() {
        String string = this.namespace;
        if (string == null) {
            string = "";
        }
        return string + ":" + this.name + ":" + this.version + "$";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/packageChecker/model/Package$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/packageChecker/model/Package;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/packageChecker/model/PackageType;", "namespace", "", "name", "version", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Package create(@NotNull Project project, @NotNull PackageType type, @Nullable String namespace, @NotNull String name, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Package pkg = new Package(type, namespace, name, new SingleVersion(version), null, null, null, 112, null);
            return PackagesInterner.Companion.getInstance(project).intern(pkg);
        }

        public static /* synthetic */ Package create$default(Companion companion, Project project, PackageType packageType, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            return companion.create(project, packageType, string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

