/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EarResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String earDirectory;
    @NotNull
    private final String relativePath;
    @NotNull
    private final Path filePath;

    @Deprecated
    @PropertyMapping(value={"earDirectory", "relativePath", "file"})
    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        if (earDirectory == null) {
            EarResource.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            EarResource.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EarResource.$$$reportNull$$$0(2);
        }
        this(earDirectory, relativePath, file.toPath());
    }

    @PropertyMapping(value={"earDirectory", "relativePath", "file"})
    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull Path filePath) {
        if (earDirectory == null) {
            EarResource.$$$reportNull$$$0(3);
        }
        if (relativePath == null) {
            EarResource.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            EarResource.$$$reportNull$$$0(5);
        }
        this.earDirectory = earDirectory;
        this.relativePath = EarResource.getAdjustedPath(relativePath);
        this.filePath = filePath;
    }

    @NotNull
    public String getEarDirectory() {
        String string = this.earDirectory;
        if (string == null) {
            EarResource.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getRelativePath() {
        String string = this.relativePath;
        if (string == null) {
            EarResource.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public File getFile() {
        File file = this.filePath.toFile();
        if (file == null) {
            EarResource.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public Path getFilePath() {
        Path path = this.filePath;
        if (path == null) {
            EarResource.$$$reportNull$$$0(9);
        }
        return path;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            EarResource.$$$reportNull$$$0(10);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarResource resource = (EarResource)o;
        return Objects.equals(this.earDirectory, resource.earDirectory) && Objects.equals(this.relativePath, resource.relativePath) && Objects.equals(this.filePath, resource.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.earDirectory, this.relativePath, this.filePath);
    }

    public String toString() {
        return "EarResource{earDirectory='" + this.earDirectory + "', relativePath='" + this.relativePath + "', filePath=" + String.valueOf(this.filePath) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earDirectory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEarDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

