/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.open;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import icons.GradleIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\rH\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/open/GradleProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectAsync", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canImportProjectAfterwards", "importProjectAfterwardsAsync", "", "project", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.gradle"})
public final class GradleProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    public String getName() {
        String string = GradleBundle.message("gradle.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GradleIcons.Gradle;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Gradle");
        return icon;
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GradleProjectImportUtil.canOpenGradleProject(file);
    }

    @Nullable
    public Object openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        return GradleProjectImportUtil.openGradleProject(virtualFile, projectToClose, forceOpenInNewFrame, $completion);
    }

    public boolean canImportProjectAfterwards() {
        return true;
    }

    @Nullable
    public Object importProjectAfterwardsAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull Continuation<? super Unit> $completion) {
        Object object = GradleProjectImportUtil.linkAndSyncGradleProject(project, file, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

