/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.json.metadata;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.boot.application.metadata.SpringBootKeyDefinition;
import com.intellij.spring.boot.json.metadata.SpringBootJsonConfigProcessorKt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\rJ\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u001e\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\u001e\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/spring/boot/json/metadata/LocalMetadataParser;", "", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "typeCache", "Lcom/intellij/spring/boot/json/metadata/LocalMetadataParser$TypeCache;", "parseAdditionalMetadata", "", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "additionalKeys", "", "", "Lcom/intellij/spring/boot/application/metadata/SpringBootKeyDefinition;", "keyHints", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ItemHint;", "collectAdditionalKeys", "", "rootObject", "Lcom/intellij/json/psi/JsonObject;", "getDefaultValue", "jsonObject", "Lcom/intellij/psi/SmartPsiElementPointer;", "getItemHints", "createItemHint", "entry", "getItemHintProviders", "", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ValueProvider;", "getItemHintProviderParameters", "getItemHintValues", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ValueHint;", "getDescription", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$DescriptionText;", "getDeprecation", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$Deprecation;", "property", "getPropertyValue", "propertyName", "TypeCache", "intellij.spring.boot.json"})
@SourceDebugExtension(value={"SMAP\nSpringBootJsonConfigProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootJsonConfigProcessor.kt\ncom/intellij/spring/boot/json/metadata/LocalMetadataParser\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n18#2:230\n18#2:231\n18#2:232\n18#2:233\n18#2:234\n18#2:235\n18#2:237\n18#2:238\n18#2:239\n18#2:240\n18#2:241\n18#2:242\n18#2:243\n18#2:244\n1#3:236\n*S KotlinDebug\n*F\n+ 1 SpringBootJsonConfigProcessor.kt\ncom/intellij/spring/boot/json/metadata/LocalMetadataParser\n*L\n76#1:230\n85#1:231\n87#1:232\n90#1:233\n92#1:234\n122#1:235\n128#1:237\n141#1:238\n146#1:239\n156#1:240\n163#1:241\n173#1:242\n174#1:243\n191#1:244\n*E\n"})
final class LocalMetadataParser {
    @NotNull
    private final TypeCache typeCache;

    public LocalMetadataParser(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.typeCache = new TypeCache(project);
    }

    public final void parseAdditionalMetadata(@NotNull JsonFile jsonFile, @NotNull Map<String, SpringBootKeyDefinition> additionalKeys, @NotNull Map<String, MetaConfigKey.ItemHint> keyHints) {
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        Intrinsics.checkNotNullParameter(additionalKeys, (String)"additionalKeys");
        Intrinsics.checkNotNullParameter(keyHints, (String)"keyHints");
        JsonValue $this$asSafely$iv = jsonFile.getTopLevelValue();
        boolean $i$f$asSafely = false;
        JsonValue jsonValue = $this$asSafely$iv;
        if (!(jsonValue instanceof JsonObject)) {
            jsonValue = null;
        }
        JsonObject jsonObject = (JsonObject)jsonValue;
        if (jsonObject == null) {
            return;
        }
        JsonObject rootObject = jsonObject;
        additionalKeys.putAll(this.collectAdditionalKeys(rootObject));
        keyHints.putAll(this.getItemHints(rootObject));
    }

    private final Map<String, SpringBootKeyDefinition> collectAdditionalKeys(JsonObject rootObject) {
        Object object;
        Map keys = new LinkedHashMap();
        JsonProperty jsonProperty = rootObject.findProperty("properties");
        Object $this$asSafely$iv = jsonProperty != null ? jsonProperty.getValue() : null;
        boolean $i$f$asSafely = false;
        JsonValue jsonValue = $this$asSafely$iv;
        if (!(jsonValue instanceof JsonArray)) {
            jsonValue = null;
        }
        List properties = (object = (JsonArray)jsonValue) != null && ($this$asSafely$iv = object.getValueList()) != null ? $this$asSafely$iv : CollectionsKt.emptyList();
        object = properties.iterator();
        while (object.hasNext()) {
            PsiType psiType;
            JsonStringLiteral nameValue;
            String typeValue;
            String $this$asSafely$iv2;
            JsonProperty nameProperty;
            JsonObject propertyObject;
            JsonValue property;
            JsonValue $this$asSafely$iv3 = property = (JsonValue)object.next();
            boolean $i$f$asSafely2 = false;
            JsonValue jsonValue2 = $this$asSafely$iv3;
            if (!(jsonValue2 instanceof JsonObject)) {
                jsonValue2 = null;
            }
            if ((JsonObject)jsonValue2 == null) continue;
            SmartPsiElementPointer propertyObjectPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)propertyObject));
            if (propertyObject.findProperty("name") == null) continue;
            JsonValue $this$asSafely$iv4 = nameProperty.getValue();
            boolean $i$f$asSafely222 = false;
            JsonValue jsonValue3 = $this$asSafely$iv4;
            if (!(jsonValue3 instanceof JsonStringLiteral)) {
                jsonValue3 = null;
            }
            if ((JsonStringLiteral)jsonValue3 == null) continue;
            JsonProperty jsonProperty2 = propertyObject.findProperty("type");
            JsonValue $i$f$asSafely222 = jsonProperty2 != null ? jsonProperty2.getValue() : null;
            boolean $i$f$asSafely3 = false;
            String string = $this$asSafely$iv2;
            if (!(string instanceof JsonStringLiteral)) {
                string = null;
            }
            String string2 = typeValue = ($this$asSafely$iv4 = (JsonStringLiteral)string) != null && ($this$asSafely$iv2 = $this$asSafely$iv4.getValue()) != null ? $this$asSafely$iv2 : "java.lang.String";
            if (this.typeCache.getType(typeValue) == null) continue;
            String string3 = nameValue.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            String key = SpringBootJsonConfigProcessorKt.access$toKeyName(string3);
            if (!StringUtil.isNotEmpty((String)key)) continue;
            keys.put(key, new SpringBootKeyDefinition(key, psiType, LazyKt.lazy(() -> LocalMetadataParser.collectAdditionalKeys$lambda$0(this, propertyObjectPointer)), this.getDescription(propertyObject), LazyKt.lazy(() -> LocalMetadataParser.collectAdditionalKeys$lambda$1(this, propertyObjectPointer)), (PsiElement)nameProperty, null));
        }
        return keys;
    }

    private final String getDefaultValue(SmartPsiElementPointer<JsonObject> jsonObject) {
        String string;
        JsonValue jsonValue;
        JsonProperty defaultValueProperty;
        JsonObject jsonObject2 = (JsonObject)jsonObject.getElement();
        JsonProperty jsonProperty = defaultValueProperty = jsonObject2 != null ? jsonObject2.findProperty("defaultValue") : null;
        Object object = jsonValue = jsonProperty != null ? jsonProperty.getValue() : null;
        if (jsonValue instanceof JsonStringLiteral) {
            string = ((JsonStringLiteral)jsonValue).getValue();
        } else {
            JsonValue jsonValue2 = jsonValue;
            string = jsonValue2 != null ? jsonValue2.getText() : null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, MetaConfigKey.ItemHint> getItemHints(JsonObject rootObject) {
        Object $i$f$asSafely2;
        Object object;
        block7: {
            block6: {
                Object object2;
                JsonArray jsonArray;
                void $this$asSafely$iv;
                object = rootObject != null && (object = rootObject.findProperty("hints")) != null ? object.getValue() : null;
                boolean $i$f$asSafely2 = false;
                Object v0 = $this$asSafely$iv;
                if (!(v0 instanceof JsonArray)) {
                    v0 = null;
                }
                if ((jsonArray = (JsonArray)v0) == null || (object = jsonArray.getValueList()) == null) break block6;
                Object it = object2 = object;
                boolean bl = false;
                Object object3 = $i$f$asSafely2 = !((Collection)it).isEmpty() ? object2 : null;
                if ($i$f$asSafely2 != null) break block7;
            }
            return MapsKt.emptyMap();
        }
        Object hints = $i$f$asSafely2;
        Map hintsMap = new LinkedHashMap();
        object = hints.iterator();
        while (object.hasNext()) {
            String nameValue;
            JsonObject hintJsonObject;
            JsonValue hint;
            JsonValue $this$asSafely$iv = hint = (JsonValue)object.next();
            boolean $i$f$asSafely3 = false;
            JsonValue jsonValue = $this$asSafely$iv;
            if (!(jsonValue instanceof JsonObject)) {
                jsonValue = null;
            }
            if (this.getPropertyValue(hintJsonObject = (JsonObject)jsonValue, "name") == null) continue;
            hintsMap.put(SpringBootJsonConfigProcessorKt.access$toKeyName(nameValue), this.createItemHint(hintJsonObject));
        }
        return hintsMap;
    }

    private final MetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        return new MetaConfigKey.ItemHint(this.getItemHintProviders(entry), this.getItemHintValues(entry));
    }

    /*
     * WARNING - void declaration
     */
    private final List<MetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonArray jsonArray;
        void $this$asSafely$iv;
        Object object;
        object = entry != null && (object = entry.findProperty("providers")) != null ? object.getValue() : null;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof JsonArray)) {
            v0 = null;
        }
        if ((jsonArray = (JsonArray)v0) == null || (object = jsonArray.getValueList()) == null) {
            return CollectionsKt.emptyList();
        }
        Object providersValue = object;
        SmartList providers = new SmartList();
        object = providersValue.iterator();
        while (object.hasNext()) {
            String name;
            JsonObject providerObject;
            JsonValue arrayValue;
            JsonValue $this$asSafely$iv2 = arrayValue = (JsonValue)object.next();
            boolean $i$f$asSafely2 = false;
            JsonValue jsonValue = $this$asSafely$iv2;
            if (!(jsonValue instanceof JsonObject)) {
                jsonValue = null;
            }
            if (this.getPropertyValue(providerObject = (JsonObject)jsonValue, "name") == null) continue;
            Map<String, String> parameters = this.getItemHintProviderParameters(providerObject);
            providers.add((Object)new MetaConfigKey.ValueProvider(name, parameters));
        }
        return (List)providers;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonObject jsonObject;
        void $this$asSafely$iv;
        Object object;
        object = entry != null && (object = entry.findProperty("parameters")) != null ? object.getValue() : null;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof JsonObject)) {
            v0 = null;
        }
        if ((jsonObject = (JsonObject)v0) == null || (object = jsonObject.getPropertyList()) == null) {
            return MapsKt.emptyMap();
        }
        Object parameterList = object;
        Map parameters = new LinkedHashMap();
        object = parameterList.iterator();
        while (object.hasNext()) {
            JsonStringLiteral primitive;
            String key;
            JsonValue value;
            JsonProperty property = (JsonProperty)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)property.getName(), (String)"getName(...)");
            if (property.getValue() == null) continue;
            JsonValue $this$asSafely$iv2 = value;
            boolean $i$f$asSafely2 = false;
            JsonValue jsonValue = $this$asSafely$iv2;
            if (!(jsonValue instanceof JsonStringLiteral)) {
                jsonValue = null;
            }
            if ((JsonStringLiteral)jsonValue == null) continue;
            parameters.put(key, primitive.getValue());
        }
        return parameters;
    }

    private final List<MetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        Object object;
        JsonProperty valuesObject;
        JsonObject jsonObject = entry;
        Object object2 = valuesObject = jsonObject != null ? jsonObject.findProperty("values") : null;
        if (valuesObject == null) {
            return CollectionsKt.emptyList();
        }
        List values = (List)new SmartList();
        JsonValue $this$asSafely$iv = valuesObject.getValue();
        boolean $i$f$asSafely = false;
        JsonValue jsonValue = $this$asSafely$iv;
        if (!(jsonValue instanceof JsonArray)) {
            jsonValue = null;
        }
        if ((object = (JsonArray)jsonValue) == null || (object = object.getValueList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String value;
            JsonObject valueObject;
            JsonValue arrayValue;
            JsonValue $this$asSafely$iv2 = arrayValue = (JsonValue)iterator.next();
            boolean $i$f$asSafely2 = false;
            JsonValue jsonValue2 = $this$asSafely$iv2;
            if (!(jsonValue2 instanceof JsonObject)) {
                jsonValue2 = null;
            }
            if ((JsonObject)jsonValue2 == null || this.getPropertyValue(valueObject, "value") == null) continue;
            values.add(new MetaConfigKey.ValueHint(value, this.getDescription(valueObject)));
        }
        return values;
    }

    private final MetaConfigKey.DescriptionText getDescription(JsonObject jsonObject) {
        MetaConfigKey.DescriptionText descriptionText;
        String description = this.getPropertyValue(jsonObject, "description");
        if (description != null) {
            descriptionText = new MetaConfigKey.DescriptionText(description);
        } else {
            MetaConfigKey.DescriptionText descriptionText2 = MetaConfigKey.DescriptionText.NONE;
            descriptionText = descriptionText2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptionText2, (String)"NONE");
        }
        return descriptionText;
    }

    /*
     * WARNING - void declaration
     */
    private final MetaConfigKey.Deprecation getDeprecation(SmartPsiElementPointer<JsonObject> property) {
        void $this$asSafely$iv;
        JsonProperty jsonProperty;
        JsonObject jsonObject = (JsonObject)property.getElement();
        jsonObject = jsonObject != null && (jsonProperty = jsonObject.findProperty("deprecation")) != null ? jsonProperty.getValue() : null;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof JsonObject)) {
            v0 = null;
        }
        JsonObject jsonObject2 = v0;
        if (jsonObject2 == null) {
            MetaConfigKey.Deprecation deprecation = MetaConfigKey.Deprecation.NOT_DEPRECATED;
            Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"NOT_DEPRECATED");
            return deprecation;
        }
        JsonObject deprecationObject = jsonObject2;
        String reasonText = this.getPropertyValue(deprecationObject, "reason");
        MetaConfigKey.DescriptionText reason = reasonText == null ? MetaConfigKey.DescriptionText.NONE : new MetaConfigKey.DescriptionText(reasonText);
        MetaConfigKey.Deprecation.DeprecationLevel level = MetaConfigKey.Deprecation.DeprecationLevel.WARNING;
        String levelLiteral = this.getPropertyValue(deprecationObject, "level");
        MetaConfigKey.Deprecation.DeprecationLevel parsedLevel = MetaConfigKey.Deprecation.DeprecationLevel.parse((String)levelLiteral);
        if (parsedLevel != null) {
            level = parsedLevel;
        }
        String replacement = this.getPropertyValue(deprecationObject, "replacement");
        return new MetaConfigKey.Deprecation(reason, level, replacement);
    }

    private final String getPropertyValue(JsonObject jsonObject, String propertyName) {
        String string;
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 != null && (jsonObject2 = jsonObject2.findProperty(propertyName)) != null && (jsonObject2 = jsonObject2.getValue()) != null) {
            PsiElement p0 = (PsiElement)jsonObject2;
            boolean bl = false;
            string = ElementManipulators.getValueText((PsiElement)p0);
        } else {
            string = null;
        }
        return string;
    }

    private static final String collectAdditionalKeys$lambda$0(LocalMetadataParser this$0, SmartPsiElementPointer $propertyObjectPointer) {
        return this$0.getDefaultValue((SmartPsiElementPointer<JsonObject>)$propertyObjectPointer);
    }

    private static final MetaConfigKey.Deprecation collectAdditionalKeys$lambda$1(LocalMetadataParser this$0, SmartPsiElementPointer $propertyObjectPointer) {
        return this$0.getDeprecation((SmartPsiElementPointer<JsonObject>)$propertyObjectPointer);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000bR\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/boot/json/metadata/LocalMetadataParser$TypeCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "elementFactory", "Lcom/intellij/psi/PsiElementFactory;", "Lorg/jetbrains/annotations/NotNull;", "cache", "", "", "Lcom/intellij/psi/PsiType;", "getType", "fqn", "intellij.spring.boot.json"})
    @SourceDebugExtension(value={"SMAP\nSpringBootJsonConfigProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootJsonConfigProcessor.kt\ncom/intellij/spring/boot/json/metadata/LocalMetadataParser$TypeCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,229:1\n23#2:230\n*S KotlinDebug\n*F\n+ 1 SpringBootJsonConfigProcessor.kt\ncom/intellij/spring/boot/json/metadata/LocalMetadataParser$TypeCache\n*L\n221#1:230\n*E\n"})
    private static final class TypeCache {
        @NotNull
        private final PsiElementFactory elementFactory;
        @NotNull
        private Map<String, PsiType> cache;

        public TypeCache(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            this.elementFactory = psiElementFactory;
            Map map = FactoryMap.create(arg_0 -> TypeCache.cache$lambda$1(arg_0 -> TypeCache.cache$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
            this.cache = map;
        }

        @Nullable
        public final PsiType getType(@NotNull String fqn) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            return this.cache.get(fqn);
        }

        private static final PsiType cache$lambda$0(TypeCache this$0, String key) {
            PsiType psiType;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                psiType = this$0.elementFactory.createTypeFromText(StringsKt.replace$default((String)key, (char)'$', (char)'.', (boolean)false, (int)4, null), null);
            }
            catch (IncorrectOperationException e) {
                TypeCache $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TypeCache.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Unsupported property type specified: " + key);
                psiType = null;
            }
            return psiType;
        }

        private static final PsiType cache$lambda$1(Function1 $tmp0, Object p0) {
            return (PsiType)$tmp0.invoke(p0);
        }
    }
}

