/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.run.icons.SpringBootRunIcons;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.LiveBeansNavigationHandler;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.runtime.SpringRuntimeBean;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

final class LiveBeansClassLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    LiveBeansClassLineMarkerProvider() {
    }

    public String getId() {
        return "LiveBeansClassLineMarkerProvider";
    }

    public String getName() {
        return SpringBootApiBundle.message((String)"runtime.beans.class.gutter.icon.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return SpringBootRunIcons.Gutter.LiveBean;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        if (!LiveBeansNavigationHandler.hasLiveBeansModels(psiElement)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UDeclaration elementToProcess;
        if (psiElement == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)psiElement)) instanceof UMethod) {
            LiveBeansClassLineMarkerProvider.annotateMethod(psiElement, (UMethod)elementToProcess, result);
        }
    }

    private static void annotateMethod(@NotNull PsiElement nameIdentifier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiMethod psiMethod;
        if (nameIdentifier == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (uMethod == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (result == null) {
            LiveBeansClassLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if ((psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class)) == null) {
            return;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        if (psiMethod.isConstructor()) {
            return;
        }
        ContextJavaBean contextJavaBean = (ContextJavaBean)JamService.getJamService((Project)psiMethod.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)psiMethod);
        if (contextJavaBean == null) {
            return;
        }
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)contextJavaBean.getPsiAnnotation()));
        if (psiAnnotationIdentifier != nameIdentifier) {
            return;
        }
        String methodName = psiMethod.getName();
        BiPredicate<SpringRuntimeBean, SpringRuntimeResourceContext> beanMatcher = (liveBean, context) -> {
            SpringRuntimeResource liveResource = liveBean.getResource();
            if (liveResource == null || !liveResource.matchesClass(psiClass, false)) {
                return false;
            }
            return liveBean.getFactoryMethodName() == null || liveBean.getFactoryMethodName().equals(methodName);
        };
        LiveBeansNavigationHandler.addLiveBeansGutterIcon(List.of(contextJavaBean), beanMatcher, nameIdentifier, true, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansClassLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

