/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.icons.SpringBootRunIcons;
import com.intellij.spring.boot.run.lifecycle.SpringBootRuntimeApplicationProvider;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.InactiveRuntimeBeanLineMarkerInfo;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.RuntimeBeanLineMarkerInfo;
import com.intellij.spring.boot.run.lifecycle.beans.gutter.RuntimeBeanLineMarkerInfoKt;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.extensions.Mapper;
import com.intellij.spring.runtime.SpringRuntimeApplication;
import com.intellij.spring.runtime.SpringRuntimeBean;
import com.intellij.spring.runtime.SpringRuntimeContext;
import com.intellij.spring.runtime.SpringRuntimeResourceContext;
import com.intellij.ui.GroupHeaderSeparator;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.list.TargetPopup;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@VisibleForTesting
public final class LiveBeansNavigationHandler
implements GutterIconNavigationHandler<PsiElement> {
    private static final ExtensionPointName<SpringBootRuntimeApplicationProvider> RUNTIME_APPLICATION_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.run.runtimeApplicationProvider");
    private static final NotNullFunction<BeanNavigationItem, Collection<? extends GotoRelatedItem>> GOTO_RELATED_ITEMS_PROVIDER = item -> {
        SmartList gotoItems = new SmartList();
        String injectedIntoGroupId = SpringBootRunBundle.message("spring.boot.application.endpoints.bean.item.group.dependent", new Object[0]);
        for (SpringRuntimeBean liveBean : item.bean.getInjectedInto()) {
            PsiElement psiElement = LiveBeansNavigationHandler.findBeanPointer(item, liveBean).getPsiElement();
            if (psiElement == null) continue;
            gotoItems.add(new GotoRelatedItem(psiElement, injectedIntoGroupId));
        }
        String dependenciesGroupId = SpringBootRunBundle.message("spring.boot.application.endpoints.bean.item.group.injected", new Object[0]);
        for (SpringRuntimeBean liveBean : item.bean.getDependencies()) {
            PsiElement psiElement = LiveBeansNavigationHandler.findBeanPointer(item, liveBean).getPsiElement();
            if (psiElement == null) continue;
            gotoItems.add(new GotoRelatedItem(psiElement, dependenciesGroupId));
        }
        return gotoItems;
    };
    private final Project myProject;
    private final List<? extends BeanNavigationItem> myItems;
    private List<Dependencies> myDependencies;

    private LiveBeansNavigationHandler(@NotNull Project project, List<? extends BeanNavigationItem> items) {
        if (project == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myItems = items;
    }

    @NlsContexts.Tooltip
    private static String getLiveMarkerInfoTooltipText() {
        return SpringBootRunBundle.message("spring.boot.application.endpoints.bean.gutter.tooltip", new Object[0]);
    }

    @Nullable
    public ListPopup createNavigationPopup() {
        if (this.myItems.isEmpty()) {
            return null;
        }
        this.prepareDependencies();
        if (this.myItems.size() == 1) {
            BeanNavigationItem item = this.myItems.get(0);
            return this.createDependenciesPopup(this.myProject, null, item);
        }
        return this.createBeansPopup(this.myProject, this.myItems);
    }

    public void navigate(MouseEvent e, PsiElement element) {
        ListPopup popup = this.createNavigationPopup();
        if (popup == null) {
            return;
        }
        LiveBeansNavigationHandler.showPopup(e, popup, this.myProject);
    }

    private void prepareDependencies() {
        this.myDependencies = (List)RuntimeBeanLineMarkerInfoKt.prepareRuntimeDependencies(null, null, () -> ContainerUtil.map(this.myItems, LiveBeansNavigationHandler::getRelatedBeansWithSeparators));
    }

    private static void showPopup(MouseEvent e, ListPopup popup, Project project) {
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
        popup.show(new RelativePoint(e));
    }

    @NotNull
    private ListPopup createBeansPopup(Project project, List<? extends BeanNavigationItem> items) {
        return new ListPopupImpl(project, (ListPopupStep)new BeansPopupStep(items)){

            protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
                if (!(step instanceof ListPopupStep)) {
                    throw new IllegalArgumentException("Step: " + String.valueOf(step.getClass()));
                }
                if (!(parentValue instanceof BeanNavigationItem)) {
                    throw new IllegalArgumentException("Parent value: " + String.valueOf(step.getClass()));
                }
                return LiveBeansNavigationHandler.this.createDependenciesPopup(this.getProject(), parent, (BeanNavigationItem)parentValue);
            }
        };
    }

    @NotNull
    private ListPopupImpl createDependenciesPopup(Project project, WizardPopup parent, BeanNavigationItem item) {
        Dependencies dependencies = this.myDependencies.get(this.myItems.indexOf(item));
        final DependenciesPopupStep step = new DependenciesPopupStep(item, dependencies);
        return new ListPopupImpl(this, project, parent, (ListPopupStep)step, item){

            protected ListCellRenderer<?> getListElementRenderer() {
                return new DependencyPopupRenderer((ListPopupStep<DependencyNavigationItem>)step);
            }

            protected void afterShow() {
            }
        };
    }

    private static Dependencies getRelatedBeansWithSeparators(BeanNavigationItem item) {
        BeanPointerCellRenderer renderer = new BeanPointerCellRenderer();
        List injected = ContainerUtil.map((Collection)item.bean.getInjectedInto(), dependency -> new DependencyNavigationItem(item, (SpringRuntimeBean)dependency, renderer));
        List dependencies = ContainerUtil.map((Collection)item.bean.getDependencies(), dependency -> new DependencyNavigationItem(item, (SpringRuntimeBean)dependency, renderer));
        ArrayList<DependencyNavigationItem> items = new ArrayList<DependencyNavigationItem>();
        items.add(new DependencyNavigationItem(item, item.bean, renderer));
        items.addAll(injected);
        items.addAll(dependencies);
        return new Dependencies(items, (DependencyNavigationItem)ContainerUtil.getFirstItem((List)injected), (DependencyNavigationItem)ContainerUtil.getFirstItem((List)dependencies));
    }

    private static void navigateToBean(BeanNavigationItem item, SpringRuntimeBean liveBean) {
        PsiElementPointer pointer = LiveBeansNavigationHandler.findBeanPointer(item, liveBean);
        if (pointer.getPsiElement() instanceof NavigatablePsiElement) {
            ((NavigatablePsiElement)pointer.getPsiElement()).navigate(true);
            SpringBootRunUsageTriggerCollector.logRuntimeBeansNavigationHandler(item.project, "ICON_NAVIGATION");
        }
    }

    @NotNull
    private static PsiElementPointer findBeanPointer(BeanNavigationItem item, SpringRuntimeBean liveBean) {
        SpringRuntimeResourceContext resourceContext = item.application.getResourceContext();
        Module module = resourceContext.getModule();
        SpringModel model = module == null ? null : SpringManager.getInstance((Project)item.project).getCombinedModel(module);
        PsiElement resourceElement = liveBean.getResource() == null ? null : liveBean.getResource().findResourceElement(resourceContext);
        PsiClass beanClass = liveBean.findBeanClass(item.project, resourceContext.getSearchScope());
        PsiElementPointer psiElementPointer = liveBean.findBeanPointer(beanClass, resourceElement, (CommonSpringModel)model);
        if (psiElementPointer == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(1);
        }
        return psiElementPointer;
    }

    static boolean hasLiveBeansModels(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(2);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return false;
        }
        return !LiveBeansNavigationHandler.getRuntimeApplications(psiElement).isEmpty();
    }

    private static Collection<SpringRuntimeApplication> getRuntimeApplications(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(3);
        }
        HashMap<ProcessHandler, SpringRuntimeApplication> applications = new HashMap<ProcessHandler, SpringRuntimeApplication>();
        for (SpringBootRuntimeApplicationProvider provider : RUNTIME_APPLICATION_PROVIDER_EP_NAME.getExtensionList()) {
            for (SpringRuntimeApplication application : provider.getApplications(psiElement)) {
                applications.put(application.getProcessHandler(), application);
            }
        }
        return applications.values();
    }

    static void addLiveBeansGutterIcon(@NotNull Collection<CommonSpringBean> candidates, @NotNull BiPredicate<? super SpringRuntimeBean, SpringRuntimeResourceContext> beanMatcher, @NotNull PsiElement nameIdentifier, boolean forMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (candidates == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(4);
        }
        if (beanMatcher == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(5);
        }
        if (nameIdentifier == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(6);
        }
        if (result == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(7);
        }
        LinkedHashSet mappers = new LinkedHashSet();
        LinkedHashSet names = new LinkedHashSet();
        for (CommonSpringBean candidate : candidates) {
            Object className;
            if (candidate instanceof Mapper) {
                Mapper mapper = (Mapper)candidate;
                ContainerUtil.addIfNotNull(mappers, (Object)mapper.getMappedFqn());
                continue;
            }
            String beanName = candidate.getBeanName();
            if (beanName == null) continue;
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)candidate.getBeanType());
            Object object = className = psiClass == null ? null : psiClass.getQualifiedName();
            if (className == null) continue;
            ContainerUtil.addIfNotNull(names, (Object)Pair.create((Object)beanName, (Object)className));
        }
        if (names.isEmpty() && mappers.isEmpty()) {
            return;
        }
        Collection<SpringRuntimeApplication> applications = LiveBeansNavigationHandler.getRuntimeApplications(nameIdentifier);
        if (applications.isEmpty()) {
            return;
        }
        SmartList items = new SmartList();
        Project project = nameIdentifier.getProject();
        for (SpringRuntimeApplication application : applications) {
            for (Pair name : names) {
                List beans = ContainerUtil.mapNotNull((Collection)application.getContexts(), context -> context.getBeanByName((String)name.first));
                if (beans.isEmpty() && name.second != null) {
                    beans = application.getContexts().stream().flatMap(context -> context.getBeansByClass((String)name.second).stream()).toList();
                }
                if (beans.isEmpty()) continue;
                SpringRuntimeResourceContext resourceContext = application.getResourceContext();
                beans.stream().filter(liveBean -> beanMatcher.test((SpringRuntimeBean)liveBean, resourceContext)).forEach(arg_0 -> LiveBeansNavigationHandler.lambda$addLiveBeansGutterIcon$7((List)items, project, application, arg_0));
            }
            SmartList mapperBeans = new SmartList();
            for (String mapper : mappers) {
                for (SpringRuntimeContext context2 : application.getContexts()) {
                    SpringRuntimeBean mapperBean = (SpringRuntimeBean)ContainerUtil.find((Iterable)context2.getBeans(), bean -> {
                        String beanClassName = bean.getClassName();
                        return beanClassName.startsWith(mapper) && beanClassName.length() > mapper.length() && beanClassName.charAt(mapper.length()) != '.';
                    });
                    ContainerUtil.addIfNotNull((Collection)mapperBeans, (Object)mapperBean);
                }
            }
            mapperBeans.forEach(arg_0 -> LiveBeansNavigationHandler.lambda$addLiveBeansGutterIcon$9((List)items, project, application, arg_0));
        }
        SpringGutterIconBuilder<BeanNavigationItem> builder = LiveBeansNavigationHandler.getBuilder(project, (List<BeanNavigationItem>)items, forMethod);
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(nameIdentifier));
    }

    @NotNull
    private static SpringGutterIconBuilder<BeanNavigationItem> getBuilder(@NotNull Project project, List<BeanNavigationItem> items, final boolean forMethod) {
        if (project == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(8);
        }
        final LiveBeansNavigationHandler navigationHandler = new LiveBeansNavigationHandler(project, items);
        final boolean isActive = !items.isEmpty();
        final boolean isMock = ContainerUtil.find(items, item -> !item.bean.isMock()) == null;
        Icon icon = SpringBootRunIcons.Gutter.LiveBean;
        if (isMock) {
            icon = SpringPresentationProvider.getMockIcon((Icon)icon);
        }
        SpringGutterIconBuilder<BeanNavigationItem> builder = new SpringGutterIconBuilder<BeanNavigationItem>(icon, (NotNullFunction)new ConstantFunction(Collections.emptyList()), GOTO_RELATED_ITEMS_PROVIDER){

            @NotNull
            public RelatedItemLineMarkerInfo<PsiElement> createSpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (isActive) {
                    return new RuntimeBeanLineMarkerInfo(element, this.myIcon, LiveBeansNavigationHandler.getLiveMarkerInfoTooltipText(), navigationHandler, isMock, forMethod, (NotNullFactory<? extends Collection<GotoRelatedItem>>)((NotNullFactory)() -> this.computeGotoTargets()));
                }
                return new InactiveRuntimeBeanLineMarkerInfo(element, this.myIcon, LiveBeansNavigationHandler.getLiveMarkerInfoTooltipText(), navigationHandler, forMethod, (NotNullFactory<? extends Collection<GotoRelatedItem>>)((NotNullFactory)() -> this.computeGotoTargets()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$3", "createSpringRelatedMergeableLineMarkerInfo"));
            }
        };
        builder.setTargets(NotNullLazyValue.createConstantValue(items));
        SpringGutterIconBuilder<BeanNavigationItem> springGutterIconBuilder = builder;
        if (springGutterIconBuilder == null) {
            LiveBeansNavigationHandler.$$$reportNull$$$0(9);
        }
        return springGutterIconBuilder;
    }

    private static /* synthetic */ void lambda$addLiveBeansGutterIcon$9(List items, Project project, SpringRuntimeApplication application, SpringRuntimeBean liveBean) {
        items.add(new BeanNavigationItem(project, application, liveBean));
    }

    private static /* synthetic */ void lambda$addLiveBeansGutterIcon$7(List items, Project project, SpringRuntimeApplication application, SpringRuntimeBean liveBean) {
        items.add(new BeanNavigationItem(project, application, liveBean));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanMatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeanPointer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasLiveBeansModels";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeApplications";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLiveBeansGutterIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9 -> new IllegalStateException(string);
        };
    }

    private static class BeanNavigationItem {
        final Project project;
        final SpringRuntimeApplication application;
        final SpringRuntimeBean bean;

        BeanNavigationItem(Project project, SpringRuntimeApplication application, SpringRuntimeBean bean) {
            this.project = project;
            this.application = application;
            this.bean = bean;
        }

        @Nls
        String getDisplayText() {
            return this.bean.getName() + " [" + this.application.getName() + "]";
        }
    }

    private static class BeansPopupStep
    extends BaseListPopupStep<BeanNavigationItem> {
        BeansPopupStep(List<? extends BeanNavigationItem> items) {
            super(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.popup.title", new Object[0]), items);
        }

        @NotNull
        public String getTextFor(BeanNavigationItem item) {
            String string = item.getDisplayText();
            if (string == null) {
                BeansPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(BeanNavigationItem item) {
            return true;
        }

        public Icon getIconFor(BeanNavigationItem item) {
            return item.bean.getIcon();
        }

        public PopupStep<?> onChosen(BeanNavigationItem item, boolean finalChoice) {
            return (PopupStep)RuntimeBeanLineMarkerInfoKt.prepareRuntimeDependencies(null, null, () -> new DependenciesPopupStep(item, LiveBeansNavigationHandler.getRelatedBeansWithSeparators(item)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$BeansPopupStep", "getTextFor"));
        }
    }

    private record Dependencies(List<DependencyNavigationItem> items, DependencyNavigationItem injectedSeparator, DependencyNavigationItem dependencySeparator) {
    }

    private static class DependenciesPopupStep
    extends BaseListPopupStep<DependencyNavigationItem>
    implements ListPopupStepEx<DependencyNavigationItem> {
        private final BeanNavigationItem myItem;
        private final DependencyNavigationItem myBeanDefinition;
        private final DependencyNavigationItem myInjectedSeparator;
        private final DependencyNavigationItem myDependencySeparator;

        DependenciesPopupStep(BeanNavigationItem item, Dependencies dependencies) {
            super(item.getDisplayText(), dependencies.items);
            this.myItem = item;
            this.myBeanDefinition = dependencies.items.get(0);
            this.myInjectedSeparator = dependencies.injectedSeparator;
            this.myDependencySeparator = dependencies.dependencySeparator;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep<?> onChosen(DependencyNavigationItem item, boolean finalChoice) {
            WriteIntentReadAction.run(() -> LiveBeansNavigationHandler.navigateToBean(this.myItem, item.bean));
            return FINAL_CHOICE;
        }

        @Nullable
        public String getTooltipTextFor(DependencyNavigationItem item) {
            return null;
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                DependenciesPopupStep.$$$reportNull$$$0(0);
            }
            emptyText.setText(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.not.injected", new Object[0]));
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DependencyNavigationItem value) {
            if (value.equals(this.myBeanDefinition)) {
                return new ListSeparator(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.definition", new Object[0]));
            }
            if (this.myInjectedSeparator != null && value.bean.equals((Object)this.myInjectedSeparator.bean)) {
                return new ListSeparator(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.injected.into", new Object[0]));
            }
            if (this.myDependencySeparator != null && value.bean.equals((Object)this.myDependencySeparator.bean)) {
                return new ListSeparator(SpringBootRunBundle.message("spring.boot.application.endpoints.bean.depends.on", new Object[0]));
            }
            return super.getSeparatorAbove((Object)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/spring/boot/run/lifecycle/beans/gutter/LiveBeansNavigationHandler$DependenciesPopupStep", "setEmptyText"));
        }
    }

    private static class BeanPointerCellRenderer
    extends DefaultPsiElementCellRenderer {
        SpringRuntimeBean myBean;

        private BeanPointerCellRenderer() {
        }

        void setBean(SpringRuntimeBean bean) {
            this.myBean = bean;
        }

        public String getElementText(PsiElement element) {
            if (this.myBean != null) {
                return this.myBean.getName();
            }
            return super.getElementText(element);
        }

        protected Icon getIcon(PsiElement element) {
            if (this.myBean != null) {
                return this.myBean.getIcon();
            }
            return super.getIcon(element);
        }
    }

    private static class DependencyNavigationItem {
        final SpringRuntimeBean bean;
        final PsiElementPointer pointer;
        final TargetPresentation presentation;

        DependencyNavigationItem(BeanNavigationItem item, SpringRuntimeBean bean, BeanPointerCellRenderer renderer) {
            this.bean = bean;
            this.pointer = LiveBeansNavigationHandler.findBeanPointer(item, bean);
            PsiElement element = this.pointer.getPsiElement();
            renderer.setBean(bean);
            this.presentation = element == null ? null : renderer.computePresentation(element);
        }
    }

    private static class DependencyPopupRenderer
    implements ListCellRenderer<DependencyNavigationItem> {
        private final ListPopupStep<DependencyNavigationItem> myPopupStep;
        private final JPanel myRendererPanel;
        private final GroupHeaderSeparator mySeparatorComponent;
        private final SimpleListCellRenderer<DependencyNavigationItem> myNotFoundBeanRenderer;
        private final ListCellRenderer<DependencyNavigationItem> myElementCellRenderer = TargetPopup.createTargetPresentationRenderer(item -> item.presentation);
        private final Wrapper myElementComponent = new Wrapper();

        DependencyPopupRenderer(ListPopupStep<DependencyNavigationItem> popupStep) {
            this.myPopupStep = popupStep;
            this.myNotFoundBeanRenderer = SimpleListCellRenderer.create((label, value, index) -> {
                label.setIcon(value.bean.getIcon());
                label.setText(value.bean.getName());
                label.setEnabled(false);
            });
            OpaquePanel beanPanel = new OpaquePanel((LayoutManager)new BorderLayout(), UIUtil.getListBackground());
            beanPanel.add((Component)this.myNotFoundBeanRenderer, "North");
            beanPanel.add((Component)this.myElementComponent, "Center");
            this.mySeparatorComponent = new GroupHeaderSeparator(JBUI.CurrentTheme.Popup.separatorLabelInsets());
            this.myRendererPanel = new OpaquePanel((LayoutManager)new BorderLayout(), UIUtil.getListBackground());
            this.myRendererPanel.add((Component)this.mySeparatorComponent, "North");
            this.myRendererPanel.add((Component)beanPanel, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends DependencyNavigationItem> list, DependencyNavigationItem value, int index, boolean isSelected, boolean cellHasFocus) {
            ListSeparator separator = this.myPopupStep.getSeparatorAbove((Object)value);
            this.mySeparatorComponent.setVisible(separator != null);
            if (separator != null) {
                this.mySeparatorComponent.setCaption(separator.getText());
                this.mySeparatorComponent.setHideLine(index == 0);
            }
            boolean found = value.presentation != null;
            this.myElementComponent.setVisible(found);
            this.myNotFoundBeanRenderer.setVisible(!found);
            if (found) {
                JComponent component = (JComponent)ObjectUtils.tryCast((Object)this.myElementCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus), JComponent.class);
                if (component != null) {
                    component.setBorder((Border)JBUI.Borders.empty((int)0, (int)8));
                }
                this.myElementComponent.setContent(component);
            } else {
                this.myNotFoundBeanRenderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            }
            return this.myRendererPanel;
        }
    }
}

