/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeanImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveBeansModelImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveContextImpl;
import com.intellij.spring.boot.run.lifecycle.beans.model.impl.LiveResourceImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class LiveBeansSnapshotParser {
    private static final Logger LOG = Logger.getInstance(LiveBeansSnapshotParser.class);
    private static final Context[] EMPTY_CONTEXTS = new Context[0];
    private static final Bean[] EMPTY_BEANS = new Bean[0];

    @NotNull
    public LiveBeansModel parseEndpoint(Object data) {
        Gson gson = new GsonBuilder().create();
        JsonElement jsonElement = gson.toJsonTree(data);
        EndpointApplication application = (EndpointApplication)gson.fromJson(jsonElement, EndpointApplication.class);
        Context[] contexts = (Context[])ContainerUtil.map2Array(application.contexts.entrySet(), (Object[])EMPTY_CONTEXTS, entry -> {
            EndpointContext endpointContext = (EndpointContext)entry.getValue();
            Context context = new Context();
            context.context = (String)entry.getKey();
            context.parent = endpointContext.parentId;
            context.beans = (Bean[])ContainerUtil.map2Array(endpointContext.beans.entrySet(), (Object[])EMPTY_BEANS, beanEntry -> {
                Bean bean = (Bean)beanEntry.getValue();
                bean.bean = (String)beanEntry.getKey();
                return bean;
            });
            return context;
        });
        LiveBeansModel liveBeansModel = LiveBeansSnapshotParser.parse(contexts);
        if (liveBeansModel == null) {
            LiveBeansSnapshotParser.$$$reportNull$$$0(0);
        }
        return liveBeansModel;
    }

    @NotNull
    public LiveBeansModel parse(String snapshot) {
        Gson gson = new GsonBuilder().create();
        Context[] contexts = (Context[])gson.fromJson(snapshot, Context[].class);
        LiveBeansModel liveBeansModel = LiveBeansSnapshotParser.parse(contexts);
        if (liveBeansModel == null) {
            LiveBeansSnapshotParser.$$$reportNull$$$0(1);
        }
        return liveBeansModel;
    }

    private static LiveBeansModel parse(Context[] contexts) {
        LiveContextImpl liveContext;
        LinkedHashMap<Context, LiveContextImpl> liveContexts = new LinkedHashMap<Context, LiveContextImpl>();
        HashMap<String, LiveContextImpl> liveContextsByName = new HashMap<String, LiveContextImpl>();
        HashMap contextLiveBeans = new HashMap();
        HashMap<String, LiveBeanImpl> allBeans = new HashMap<String, LiveBeanImpl>();
        for (Context context : contexts) {
            if (context.context == null) continue;
            liveContext = new LiveContextImpl(context.context);
            liveContexts.put(context, liveContext);
            liveContextsByName.putIfAbsent(context.context, liveContext);
            HashMap<String, LiveResourceImpl> liveResources = new HashMap<String, LiveResourceImpl>();
            HashMap<String, LiveBeanImpl> liveBeans = new HashMap<String, LiveBeanImpl>();
            contextLiveBeans.put(context, liveBeans);
            for (Bean bean : context.beans) {
                LiveResourceImpl liveResource;
                if (bean.bean == null) continue;
                String resource = bean.resource;
                if (resource == null) {
                    resource = "null";
                }
                if ((liveResource = (LiveResourceImpl)liveResources.get(resource)) == null) {
                    liveResource = new LiveResourceImpl(resource, (LiveContext)liveContext);
                    liveResources.put(resource, liveResource);
                }
                LiveBeanImpl liveBean = LiveBeanImpl.createLiveBean(bean.bean, bean.scope, bean.type, liveResource);
                liveResource.addBean(liveBean);
                liveBeans.put(bean.bean, liveBean);
                allBeans.put(bean.bean, liveBean);
            }
            liveContext.addResources(liveResources.values());
        }
        for (Context context : contexts) {
            if (context.context == null) continue;
            if (context.parent != null) {
                liveContext = (LiveContextImpl)liveContexts.get(context);
                LOG.assertTrue(liveContext != null);
                liveContext.setParent((LiveContext)liveContextsByName.get(context.parent));
            }
            for (Bean bean : context.beans) {
                if (bean.bean == null) continue;
                Map liveBeans = (Map)contextLiveBeans.get(context);
                LOG.assertTrue(liveBeans != null);
                LiveBeanImpl liveBean = (LiveBeanImpl)liveBeans.get(bean.bean);
                LOG.assertTrue(liveBean != null);
                for (String dependency : bean.dependencies) {
                    if (dependency == null) continue;
                    LiveBeanImpl dependencyBean = (LiveBeanImpl)liveBeans.get(dependency);
                    if (dependencyBean == null && (dependencyBean = (LiveBeanImpl)allBeans.get(dependency)) == null) {
                        dependencyBean = LiveBeanImpl.createInnerBean(dependency);
                    }
                    liveBean.addDependency(dependencyBean);
                }
            }
        }
        return new LiveBeansModelImpl(liveContexts.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeansSnapshotParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEndpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class EndpointApplication {
        public Map<String, EndpointContext> contexts;

        private EndpointApplication() {
        }
    }

    @ApiStatus.Internal
    public static final class Context {
        public String context;
        public String parent;
        public Bean[] beans = EMPTY_BEANS;
    }

    @ApiStatus.Internal
    public static final class Bean {
        public String bean;
        public String scope;
        public String type;
        public String resource;
        public String[] dependencies = ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static final class EndpointContext {
        public Map<String, Bean> beans;
        public String parentId;

        private EndpointContext() {
        }
    }
}

