/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IconWithOverlay
extends LayeredIcon {
    public IconWithOverlay(@NotNull Icon main, @NotNull Icon overlay) {
        if (main == null) {
            IconWithOverlay.$$$reportNull$$$0(0);
        }
        if (overlay == null) {
            IconWithOverlay.$$$reportNull$$$0(1);
        }
        super(main, overlay);
    }

    @Nullable
    public abstract Shape getOverlayShape(int var1, int var2);

    @NotNull
    public Icon getMainIcon() {
        return this.getScaled(0);
    }

    @NotNull
    public Icon getOverlayIcon() {
        return this.getScaled(1);
    }

    @NotNull
    private Icon getScaled(int layer) {
        Icon icon = this.getIcon(layer);
        assert (icon != null);
        float scale2 = this.getScale();
        Icon icon2 = scale2 == 1.0f ? icon : IconUtil.scale(icon, null, scale2);
        if (icon2 == null) {
            IconWithOverlay.$$$reportNull$$$0(2);
        }
        return icon2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Shape dontPaintHere = this.getOverlayShape(0, 0);
        if (dontPaintHere == null) {
            super.paintIcon(c, g, x, y);
            return;
        }
        BufferedImage img = UIUtil.createImage((GraphicsConfiguration)((Graphics2D)g).getDeviceConfiguration(), (double)this.getIconWidth(), (double)this.getIconHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
        Graphics2D g2 = img.createGraphics();
        this.getMainIcon().paintIcon(c, g2, 0, 0);
        GraphicsConfig config = new GraphicsConfig((Graphics)g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(1));
        g2.fill(dontPaintHere);
        config.restore();
        UIUtil.drawImage((Graphics)g, (Image)img, (int)x, (int)y, null);
        this.getOverlayIcon().paintIcon(c, g, x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlay";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/icons/IconWithOverlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/icons/IconWithOverlay";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

