/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.connection.backend;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.connection.backend.join.RdServerJoinLinkManager;
import com.intellij.cwm.connection.lobby.LobbySessionTokenHandler;
import com.intellij.cwm.connection.lobby.SessionTokenUtilKt;
import com.intellij.cwm.plugin.common.connection.CwmConnectionStatusService;
import com.intellij.cwm.plugin.common.connection.GuestTerminationReasonsData;
import com.intellij.cwm.plugin.common.ui.AccessNotification;
import com.intellij.cwm.plugin.common.ui.UserInfo;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.CwmSessionManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.idea.AppMode;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.IPasswordAuthHandler;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.wire.SecureWireOverStreamTransport;
import com.intellij.platform.split.connection.protocol.wire.SessionTokenHandler;
import com.jetbrains.codeWithMe.lobby.SessionToken;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.connection.ClientAcceptState;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.SecureClientData;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0012\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/intellij/cwm/connection/backend/CwmConnectionManagerImpl;", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createPasswordHandler", "Lcom/intellij/platform/split/connection/protocol/IPasswordAuthHandler;", "isController", "", "clientData", "Lcom/jetbrains/rdserver/startup/SecureClientData;", "askForConfirmationIfNeeded", "", "id", "", "wire", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "futureToComplete", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/rdserver/connection/ClientAcceptState;", "isSessionAccepted", "sessionId", "terminateObsoleteConnections", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "createSessionTokenHandler", "Lcom/intellij/platform/split/connection/protocol/wire/SessionTokenHandler;", "disconnectClient", "disconnectReason", "Lcom/intellij/cwm/plugin/common/connection/GuestTerminationReasonsData;", "disconnectAllClients", "getConfirmationFuture", "data", "Companion", "intellij.cwm.connection.backend"})
@SourceDebugExtension(value={"SMAP\nCwmConnectionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmConnectionManagerImpl.kt\ncom/intellij/cwm/connection/backend/CwmConnectionManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n60#2,5:176\n13#2:185\n1915#3:181\n1915#3,2:182\n1916#3:184\n*S KotlinDebug\n*F\n+ 1 CwmConnectionManagerImpl.kt\ncom/intellij/cwm/connection/backend/CwmConnectionManagerImpl\n*L\n101#1:176,5\n172#1:185\n123#1:181\n124#1:182,2\n123#1:184\n*E\n"})
public final class CwmConnectionManagerImpl
extends RdServerConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private static final Logger logger;

    public CwmConnectionManagerImpl(@NotNull Project project, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(lifetime, SelfSignedCertificate.INSTANCE.getCwmSessionCertificateData(), true);
        this.project = project;
        this.lifetime = lifetime;
        this.getProjects().add((Object)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    protected IPasswordAuthHandler createPasswordHandler() {
        return null;
    }

    protected boolean isController(@NotNull SecureClientData clientData) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        return false;
    }

    public void askForConfirmationIfNeeded(@NotNull String id, @NotNull SecureClientData clientData, @NotNull ICodeWithMeWire wire, @NotNull CompletableFuture<ClientAcceptState> futureToComplete) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)wire, (String)"wire");
        Intrinsics.checkNotNullParameter(futureToComplete, (String)"futureToComplete");
        RdCoroutinesUtilKt.launchBackground$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, clientData, id, futureToComplete, wire, null){
            int label;
            final /* synthetic */ CwmConnectionManagerImpl this$0;
            final /* synthetic */ SecureClientData $clientData;
            final /* synthetic */ String $id;
            final /* synthetic */ CompletableFuture<ClientAcceptState> $futureToComplete;
            final /* synthetic */ ICodeWithMeWire $wire;
            {
                this.this$0 = $receiver;
                this.$clientData = $clientData;
                this.$id = $id;
                this.$futureToComplete = $futureToComplete;
                this.$wire = $wire;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = CwmConnectionManagerImpl.access$getLogger$cp();
                        var4_4 = this.$id;
                        t$iv = null;
                        $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            var8_9 = $this$debug_u24default$iv;
                            $i$a$-debug$default-CwmConnectionManagerImpl$askForConfirmationIfNeeded$1$1 = false;
                            var8_9.debug("Asking for confirmation for client group " + var4_4, (Throwable)t$iv);
                        }
                        if (!CwmSessionManager.Companion.getInstance(this.this$0.getProject()).isAtConcurrentGuestLimit(this.this$0.getProject()) && this.this$0.shouldAutoAccept(this.$clientData)) {
                            CwmConnectionManagerImpl.access$getLogger$cp().info("Auto accepting client group " + this.$id + " for " + this.$clientData.getUserName());
                            this.$futureToComplete.complete(ClientAcceptState.Accepted);
                            return Unit.INSTANCE;
                        }
                        this.label = 1;
                        v0 = FutureKt.await((CompletionStage)CwmConnectionManagerImpl.access$getConfirmationFuture(this.this$0, this.$id, this.$clientData, this.$wire), (Continuation)((Continuation)this));
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        acceptFuture = (ClientAcceptState)v0;
                        if (CwmSessionManager.Companion.getInstance(this.this$0.getProject()).isAtConcurrentGuestLimit(this.this$0.getProject()) && acceptFuture == ClientAcceptState.Declined) {
                            t$iv = CwmConnectionManagerImpl.access$getLogger$cp();
                            var5_7 = this.$id;
                            t$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var8_9 = $this$debug_u24default$iv;
                                $i$a$-debug$default-CwmConnectionManagerImpl$askForConfirmationIfNeeded$1$2 = false;
                                var8_9.debug("Group " + var5_7 + " was decided with " + ClientAcceptState.GuestLimit, t$iv);
                            }
                            v1 = this.$futureToComplete.complete(ClientAcceptState.GuestLimit);
                        } else {
                            $this$debug_u24default$iv = CwmConnectionManagerImpl.access$getLogger$cp();
                            var5_8 = this.$id;
                            t$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var8_9 = $this$debug_u24default$iv;
                                $i$a$-debug$default-CwmConnectionManagerImpl$askForConfirmationIfNeeded$1$3 = false;
                                var8_9.debug("Group " + var5_8 + " was decided with " + acceptFuture, t$iv);
                            }
                            v1 = this.$futureToComplete.complete(acceptFuture);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public boolean isSessionAccepted(@Nullable String sessionId) {
        if (sessionId == null) {
            throw new IllegalStateException("Could not get session id from provided certificate".toString());
        }
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.project).getJoinLinkData();
        if (!Intrinsics.areEqual((Object)(joinLinkData != null ? joinLinkData.getSessionId() : null), (Object)sessionId)) {
            throw new IllegalStateException(("SessionId " + sessionId + " is unknown on this host").toString());
        }
        return true;
    }

    protected void terminateObsoleteConnections(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Do not terminate obsolete connections for Code With Me. Skip.", t$iv);
        }
    }

    @Nullable
    protected SessionTokenHandler createSessionTokenHandler() {
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.project).getJoinLinkData();
        RdServerJoinLinkManager.JoinLinkDataImpl joinLinkData2 = joinLinkData instanceof RdServerJoinLinkManager.JoinLinkDataImpl ? (RdServerJoinLinkManager.JoinLinkDataImpl)joinLinkData : null;
        RdServerJoinLinkManager.JoinLinkDataImpl joinLinkDataImpl = joinLinkData2;
        if (joinLinkDataImpl == null || (joinLinkDataImpl = joinLinkDataImpl.getLobbyServerSession()) == null || (joinLinkDataImpl = joinLinkDataImpl.getSessionResponse()) == null || (joinLinkDataImpl = joinLinkDataImpl.getSessionOwnerToken()) == null) {
            return null;
        }
        RdServerJoinLinkManager.JoinLinkDataImpl sessionOwnerToken = joinLinkDataImpl;
        String string = joinLinkData2.getSessionId();
        String string2 = sessionOwnerToken.getValue();
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return (SessionTokenHandler)new LobbySessionTokenHandler(string, byArray, null);
    }

    public final void disconnectClient(@NotNull ClientId clientId, @Nullable GuestTerminationReasonsData disconnectReason) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        if (disconnectReason != null) {
            ClientId.Companion.withClientId(clientId, () -> CwmConnectionManagerImpl.disconnectClient$lambda$0(disconnectReason));
        }
        this.getWireStorage().terminateWireIfExists(clientId);
        this.getAutoAcceptedClients().remove(clientId);
    }

    public final void disconnectAllClients(@Nullable GuestTerminationReasonsData disconnectReason) {
        Iterable $this$forEach$iv = (Iterable)this.getProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = ClientSessionsUtil.sessions((Project)it, (ClientKind)ClientKind.GUEST);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ClientProjectSession projectSession = (ClientProjectSession)element$iv2;
                boolean bl2 = false;
                this.disconnectClient(projectSession.getClientId(), disconnectReason);
            }
        }
        this.getAutoAcceptedClients().clear();
        this.getPinHolder().clear();
    }

    private final CompletableFuture<ClientAcceptState> getConfirmationFuture(String id, SecureClientData data, ICodeWithMeWire wire) {
        if (AppMode.isRemoteDevHost()) {
            CompletableFuture<ClientAcceptState> accepted = CompletableFuture.completedFuture(ClientAcceptState.Declined);
            logger.info("Host in unattended mode, auto-accept check for connection group " + id + ": " + accepted);
            Intrinsics.checkNotNull(accepted);
            return accepted;
        }
        String fingerprintString = this.getPinString(data.getClientFingerprint());
        SecureWireOverStreamTransport secureWireOverStreamTransport = wire instanceof SecureWireOverStreamTransport ? (SecureWireOverStreamTransport)wire : null;
        Object object = secureWireOverStreamTransport != null ? secureWireOverStreamTransport.getSessionTokenHandler() : null;
        LobbySessionTokenHandler lobbySessionTokenHandler = object instanceof LobbySessionTokenHandler ? (LobbySessionTokenHandler)object : null;
        UserInfo userInfo = lobbySessionTokenHandler != null && (lobbySessionTokenHandler = lobbySessionTokenHandler.getRemoteToken()) != null ? SessionTokenUtilKt.asUserInfo((SessionToken)lobbySessionTokenHandler) : null;
        TransportInfo transportInfo2 = this.getWireStorage().getTransportOrNull(data.getClientId());
        Lifetime transportLifetime = transportInfo2 != null ? transportInfo2.getTransportConnectionLifetime() : null;
        CompletableFuture notification = AccessNotification.showNewAccessNotification$default((AccessNotification)AccessNotification.INSTANCE, (Project)this.project, (Lifetime)Lifetime.Companion.getEternal(), (String)data.getUserName(), (ClientId)data.getClientId(), (String)fingerprintString, (Lifetime)transportLifetime, (UserInfo)userInfo, null, (int)128, null);
        CompletionStage completionStage = notification.thenApply(arg_0 -> CwmConnectionManagerImpl.getConfirmationFuture$lambda$1(CwmConnectionManagerImpl::getConfirmationFuture$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final Unit disconnectClient$lambda$0(GuestTerminationReasonsData $disconnectReason) {
        CwmConnectionStatusService.Companion.getInstance().getTerminateClient().fire((Object)$disconnectReason);
        return Unit.INSTANCE;
    }

    private static final ClientAcceptState getConfirmationFuture$lambda$0(Boolean isOk) {
        return isOk != false ? ClientAcceptState.Accepted : ClientAcceptState.Declined;
    }

    private static final ClientAcceptState getConfirmationFuture$lambda$1(Function1 $tmp0, Object p0) {
        return (ClientAcceptState)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ CompletableFuture access$getConfirmationFuture(CwmConnectionManagerImpl $this, String id, SecureClientData data, ICodeWithMeWire wire) {
        return $this.getConfirmationFuture(id, data, wire);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CwmConnectionManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CwmConnectionManagerImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/connection/backend/CwmConnectionManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.connection.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

