/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.K8sYamlMappings;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistAstMarker;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.AstUtilKt;
import org.jetbrains.yaml.YAMLFileType;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/KubernetesYamlDetector;", "", "<init>", "()V", "K8S_GIST_MARKER", "Lcom/intellij/util/gist/GistAstMarker;", "looksLikeKubernetesYaml", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectKubernetesYaml", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesFileIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesYamlDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n2792#2,3:147\n*S KotlinDebug\n*F\n+ 1 KubernetesFileIconProvider.kt\ncom/intellij/kubernetes/KubernetesYamlDetector\n*L\n137#1:147,3\n*E\n"})
public final class KubernetesYamlDetector {
    @NotNull
    private final GistAstMarker K8S_GIST_MARKER;

    public KubernetesYamlDetector() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
        this.K8S_GIST_MARKER = new GistAstMarker((FileType)yAMLFileType, "K8S_YAML", (Function1)new Function1<LighterAST, Boolean>((Object)this){

            public final Boolean invoke(LighterAST p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KubernetesYamlDetector.access$detectKubernetesYaml((KubernetesYamlDetector)this.receiver, p0);
            }
        });
    }

    public final boolean looksLikeKubernetesYaml(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.K8S_GIST_MARKER.accepts(project, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean detectKubernetesYaml(LighterAST tree) {
        boolean bl;
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        LighterASTNode astRoot = lighterASTNode;
        Ref.BooleanRef hasApiVersion = new Ref.BooleanRef();
        Ref.BooleanRef hasKind = new Ref.BooleanRef();
        AstUtilKt.visitTopLevelKeyPairs((LighterAST)tree, (arg_0, arg_1) -> KubernetesYamlDetector.detectKubernetesYaml$lambda$0(hasKind, hasApiVersion, arg_0, arg_1));
        if (!hasApiVersion.element) return false;
        if (!hasKind.element) return false;
        List list = tree.getChildren(astRoot);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$none$iv = list;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            LighterASTNode child = (LighterASTNode)element$iv;
            boolean bl2 = false;
            if (child instanceof LighterASTTokenNode && CollectionsKt.contains((Iterable)K8sYamlMappings.INSTANCE.getNO_K8S_ANALYZED_TOKENS(), (Object)((LighterASTTokenNode)child).getTokenType())) {
                CharSequence charSequence;
                Intrinsics.checkNotNullExpressionValue((Object)((LighterASTTokenNode)child).getText(), (String)"getText(...)");
                if (K8sYamlMappings.INSTANCE.getNO_K8S_DIRECTIVE_REGEX().containsMatchIn(charSequence)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final boolean detectKubernetesYaml$lambda$0(Ref.BooleanRef $hasKind, Ref.BooleanRef $hasApiVersion, CharSequence key, LighterASTNode lighterASTNode) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lighterASTNode, (String)"<unused var>");
        CharSequence charSequence = key;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"kind")) {
            $hasKind.element = true;
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"apiVersion")) {
            $hasApiVersion.element = true;
        }
        return !$hasKind.element || !$hasApiVersion.element;
    }

    public static final /* synthetic */ boolean access$detectKubernetesYaml(KubernetesYamlDetector $this, LighterAST tree) {
        return $this.detectKubernetesYaml(tree);
    }
}

