/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug.recents;

import com.intellij.kubernetes.debug.KubectlDebugCommandUtilsKt;
import com.intellij.kubernetes.debug.recents.KubectlDebugRecentParametersTemplate;
import com.intellij.kubernetes.debug.recents.KubectlEditRecentDebugDialog;
import com.intellij.kubernetes.debug.recents.KubernetesRecentDebugsParametersService;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.settings.KubernetesSettingsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/debug/recents/KubectlRecentDebugsSettingsPanel;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesSettingsPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "table", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/kubernetes/debug/recents/KubectlDebugRecentParametersTemplate;", "doEdit", "", "doRemove", "doAdd", "isModified", "", "()Z", "apply", "reset", "NameColumnInfo", "ParametersColumnInfo", "intellij.clouds.kubernetes.backend"})
public final class KubectlRecentDebugsSettingsPanel
extends KubernetesSettingsPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TableView<KubectlDebugRecentParametersTemplate> table;

    public KubectlRecentDebugsSettingsPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.table = new TableView();
        this.table.setShowGrid(false);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new NameColumnInfo(), new ParametersColumnInfo(this.project)};
        this.table.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
        this.add((Component)ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).disableUpDownActions().setAddAction(arg_0 -> KubectlRecentDebugsSettingsPanel._init_$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> KubectlRecentDebugsSettingsPanel._init_$lambda$1(this, arg_0)).setEditAction(arg_0 -> KubectlRecentDebugsSettingsPanel._init_$lambda$2(this, arg_0)).createPanel(), "Center");
    }

    private final void doEdit() {
        int rowIndex = this.table.getSelectedRow();
        ListTableModel tableModel = this.table.getListTableModel();
        if (rowIndex < 0 || rowIndex >= tableModel.getItems().size()) {
            return;
        }
        KubectlDebugRecentParametersTemplate debugParameters = (KubectlDebugRecentParametersTemplate)tableModel.getItems().get(rowIndex);
        KubectlEditRecentDebugDialog dialog2 = new KubectlEditRecentDebugDialog(this.project, debugParameters);
        boolean result2 = dialog2.showAndGet();
        if (!result2) {
            return;
        }
        KubectlDebugRecentParametersTemplate updatedDebugParameters = dialog2.getEnteredDebugParameters$intellij_clouds_kubernetes_backend();
        tableModel.removeRow(rowIndex);
        tableModel.insertRow(rowIndex, (Object)updatedDebugParameters);
        this.table.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
    }

    private final void doRemove() {
        int indexToSelect;
        int[] selectedRows = this.table.getSelectedRows();
        Intrinsics.checkNotNull((Object)selectedRows);
        if (selectedRows.length == 0) {
            return;
        }
        ListTableModel tableModel = this.table.getListTableModel();
        List rowIndexesDescending = ArraysKt.sortedDescending((int[])selectedRows);
        Iterator iterator = rowIndexesDescending.iterator();
        while (iterator.hasNext()) {
            int rowIndex = ((Number)iterator.next()).intValue();
            tableModel.removeRow(rowIndex);
        }
        int lowestRemovedIndex = ((Number)CollectionsKt.last((List)rowIndexesDescending)).intValue();
        int n = indexToSelect = lowestRemovedIndex < tableModel.getRowCount() ? lowestRemovedIndex : tableModel.getRowCount() - 1;
        if (indexToSelect >= 0) {
            this.table.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    private final void doAdd() {
        KubectlEditRecentDebugDialog dialog2 = new KubectlEditRecentDebugDialog(this.project, null);
        if (dialog2.showAndGet()) {
            KubectlDebugRecentParametersTemplate params = dialog2.getEnteredDebugParameters$intellij_clouds_kubernetes_backend();
            this.table.getListTableModel().insertRow(0, (Object)params);
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public boolean isModified() {
        KubernetesRecentDebugsParametersService service = KubernetesRecentDebugsParametersService.Companion.getInstance(this.project);
        List<KubectlDebugRecentParametersTemplate> oldTemplatesList = service.getTemplates();
        List list = this.table.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List newTemplatesList = list;
        return oldTemplatesList.size() != newTemplatesList.size() || !Intrinsics.areEqual(oldTemplatesList, (Object)newTemplatesList);
    }

    @Override
    public void apply() {
        KubernetesRecentDebugsParametersService kubernetesRecentDebugsParametersService = KubernetesRecentDebugsParametersService.Companion.getInstance(this.project);
        List list = this.table.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        kubernetesRecentDebugsParametersService.rewriteTemplatesList(list);
    }

    @Override
    public void reset() {
        KubernetesRecentDebugsParametersService service = KubernetesRecentDebugsParametersService.Companion.getInstance(this.project);
        this.table.getListTableModel().setItems(service.getTemplates());
    }

    private static final void _init_$lambda$0(KubectlRecentDebugsSettingsPanel this$0, AnActionButton it) {
        this$0.doAdd();
    }

    private static final void _init_$lambda$1(KubectlRecentDebugsSettingsPanel this$0, AnActionButton it) {
        this$0.doRemove();
    }

    private static final void _init_$lambda$2(KubectlRecentDebugsSettingsPanel this$0, AnActionButton it) {
        this$0.doEdit();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/debug/recents/KubectlRecentDebugsSettingsPanel$NameColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/kubernetes/debug/recents/KubectlDebugRecentParametersTemplate;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "intellij.clouds.kubernetes.backend"})
    private static final class NameColumnInfo
    extends ColumnInfo<KubectlDebugRecentParametersTemplate, String> {
        public NameColumnInfo() {
            super(KubernetesBundle.message((String)"kubectl.debug.settings.recents.table.column.name.title", (Object[])new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull KubectlDebugRecentParametersTemplate item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getName();
        }

        public boolean isCellEditable(@NotNull KubectlDebugRecentParametersTemplate item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/debug/recents/KubectlRecentDebugsSettingsPanel$ParametersColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/kubernetes/debug/recents/KubectlDebugRecentParametersTemplate;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "valueOf", "item", "isCellEditable", "", "intellij.clouds.kubernetes.backend"})
    private static final class ParametersColumnInfo
    extends ColumnInfo<KubectlDebugRecentParametersTemplate, String> {
        @NotNull
        private final Project project;

        public ParametersColumnInfo(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(KubernetesBundle.message((String)"kubectl.debug.settings.recents.table.column.command.title", (Object[])new Object[0]));
            this.project = project;
        }

        @NotNull
        public String valueOf(@NotNull KubectlDebugRecentParametersTemplate item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return KubectlDebugCommandUtilsKt.getPrintableCliCommandForSettings(this.project, item);
        }

        public boolean isCellEditable(@NotNull KubectlDebugRecentParametersTemplate item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return false;
        }
    }
}

