/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helmfile;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helmfile.HelmfileFileType;
import com.intellij.kubernetes.helmfile.model.HelmReleaseModel;
import com.intellij.kubernetes.helmfile.model.HelmReleaseModelFactory;
import com.intellij.kubernetes.helmfile.model.HelmRepositoryModel;
import com.intellij.kubernetes.helmfile.model.HelmfileModel;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/helmfile/HelmfileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getAllHelmfileModels", "Lcom/intellij/util/Plow;", "Lcom/intellij/kubernetes/helmfile/model/HelmfileModel;", "getHelmfileModel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeHelmfileModel", "psiFile", "Lcom/intellij/psi/PsiFile;", "computeReleases", "", "", "Lcom/intellij/kubernetes/helmfile/model/HelmReleaseModel;", "repositories", "", "Lcom/intellij/kubernetes/helmfile/model/HelmRepositoryModel;", "computeRepositories", "HelmfileManagerCachedValueProvider", "intellij.clouds.kubernetes.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHelmfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmfileManager.kt\ncom/intellij/kubernetes/helmfile/HelmfileManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,74:1\n1220#2,2:75\n1249#2,4:77\n455#3:81\n455#3:82\n*S KotlinDebug\n*F\n+ 1 HelmfileManager.kt\ncom/intellij/kubernetes/helmfile/HelmfileManager\n*L\n55#1:75,2\n55#1:77,4\n53#1:81\n63#1:82\n*E\n"})
public final class HelmfileManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public HelmfileManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    @NotNull
    public final Plow<HelmfileModel> getAllHelmfileModels() {
        return Plow.Companion.of(arg_0 -> HelmfileManager.getAllHelmfileModels$lambda$0(this, arg_0)).mapNotNull(arg_0 -> HelmfileManager.getAllHelmfileModels$lambda$1(this, arg_0));
    }

    @RequiresReadLock
    @Nullable
    public final HelmfileModel getHelmfileModel(@Nullable VirtualFile file) {
        VirtualFile virtualFile = file;
        if (virtualFile == null || (virtualFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)this.project)) == null) {
            return null;
        }
        VirtualFile psiFile = virtualFile;
        return (HelmfileModel)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), (CachedValueProvider)new HelmfileManagerCachedValueProvider((PsiFile)psiFile));
    }

    private final HelmfileModel computeHelmfileModel(PsiFile psiFile) {
        List<HelmRepositoryModel> repositories = this.computeRepositories(psiFile);
        Map<String, HelmReleaseModel> releases = this.computeReleases(psiFile, repositories);
        return new HelmfileModel(repositories, releases);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, HelmReleaseModel> computeReleases(PsiFile psiFile, List<HelmRepositoryModel> repositories) {
        void $this$associateByTo$iv$iv;
        YAMLSequence releases;
        YAMLMapping yAMLMapping = YamlUtilKt.topLevelMapping((PsiElement)((PsiElement)psiFile));
        YAMLValue yAMLValue = yAMLMapping != null && (yAMLMapping = yAMLMapping.getKeyValueByKey("releases")) != null ? yAMLMapping.getValue() : null;
        YAMLSequence yAMLSequence = releases = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
        if (releases == null) {
            return MapsKt.emptyMap();
        }
        List list = releases.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$associateBy$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), HelmfileManager::computeReleases$lambda$0), arg_0 -> HelmfileManager.computeReleases$lambda$1(repositories, arg_0)));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HelmReleaseModel helmReleaseModel = (HelmReleaseModel)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final List<HelmRepositoryModel> computeRepositories(PsiFile psiFile) {
        YAMLSequence repositories;
        YAMLMapping yAMLMapping = YamlUtilKt.topLevelMapping((PsiElement)((PsiElement)psiFile));
        YAMLValue yAMLValue = yAMLMapping != null && (yAMLMapping = yAMLMapping.getKeyValueByKey("repositories")) != null ? yAMLMapping.getValue() : null;
        YAMLSequence yAMLSequence = repositories = yAMLValue instanceof YAMLSequence ? (YAMLSequence)yAMLValue : null;
        if (repositories == null) {
            return CollectionsKt.emptyList();
        }
        List list = repositories.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), HelmfileManager::computeRepositories$lambda$0), HelmfileManager::computeRepositories$lambda$1));
    }

    private static final boolean getAllHelmfileModels$lambda$0(HelmfileManager this$0, Processor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FileTypeIndex.processFiles((FileType)((FileType)HelmfileFileType.INSTANCE), (Processor)it, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this$0.project));
    }

    private static final HelmfileModel getAllHelmfileModels$lambda$1(HelmfileManager this$0, VirtualFile it) {
        return this$0.getHelmfileModel(it);
    }

    private static final YAMLMapping computeReleases$lambda$0(YAMLSequenceItem it) {
        Intrinsics.checkNotNull((Object)it);
        PsiElement $this$childrenOfType$iv = (PsiElement)it;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLMapping.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        return (YAMLMapping)CollectionsKt.firstOrNull((List)list);
    }

    private static final HelmReleaseModel computeReleases$lambda$1(List $repositories, YAMLMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HelmReleaseModelFactory.Companion.createReleaseModel((PsiElement)it, $repositories);
    }

    private static final YAMLMapping computeRepositories$lambda$0(YAMLSequenceItem it) {
        Intrinsics.checkNotNull((Object)it);
        PsiElement $this$childrenOfType$iv = (PsiElement)it;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, YAMLMapping.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        return (YAMLMapping)CollectionsKt.firstOrNull((List)list);
    }

    private static final HelmRepositoryModel computeRepositories$lambda$1(YAMLMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HelmRepositoryModel.Companion.create((PsiElement)it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/kubernetes/helmfile/HelmfileManager$HelmfileManagerCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lcom/intellij/kubernetes/helmfile/model/HelmfileModel;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/kubernetes/helmfile/HelmfileManager;Lcom/intellij/psi/PsiFile;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "intellij.clouds.kubernetes.backend"})
    private final class HelmfileManagerCachedValueProvider
    implements CachedValueProvider<HelmfileModel> {
        @NotNull
        private final PsiFile file;

        public HelmfileManagerCachedValueProvider(PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @NotNull
        public CachedValueProvider.Result<HelmfileModel> compute() {
            HelmfileModel model2 = HelmfileManager.this.computeHelmfileModel(this.file);
            Object[] objectArray = new Object[]{this.file};
            return new CachedValueProvider.Result((Object)model2, objectArray);
        }
    }
}

