/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.logs.BackendKubernetesLogUtilsKt;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesLogFilterModelImpl;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.KubernetesLogStateManagerKt;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEventContainerObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u00016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020'0#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0014\u0010+\u001a\u00020,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "Lcom/intellij/openapi/util/CheckedDisposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "pareDisposable", "Lcom/intellij/openapi/Disposable;", "currentContainers", "", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "getApiModel$intellij_clouds_kubernetes_backend", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "getCurrentContainers$intellij_clouds_kubernetes_backend", "()Ljava/util/List;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope$intellij_clouds_kubernetes_backend", "()Lkotlinx/coroutines/CoroutineScope;", "dispose", "", "isDisposed", "", "presentationSettings", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "getPresentationSettings$intellij_clouds_kubernetes_backend", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "largeLogsSizeFlow", "", "getLargeLogsSizeFlow$intellij_clouds_kubernetes_backend", "streamingLogsStatus", "", "getStreamingLogsStatus$intellij_clouds_kubernetes_backend", "updateTimePeriodAndSourcesFieldsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "getUpdateTimePeriodAndSourcesFieldsFlow$intellij_clouds_kubernetes_backend", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "jumpToTimestampFlow", "Ljava/time/Instant;", "getJumpToTimestampFlow$intellij_clouds_kubernetes_backend", "clearLogsEvent", "getClearLogsEvent$intellij_clouds_kubernetes_backend", "filterModel", "Lcom/intellij/kubernetes/logs/KubernetesLogFilterModelImpl;", "getFilterModel$intellij_clouds_kubernetes_backend", "()Lcom/intellij/kubernetes/logs/KubernetesLogFilterModelImpl;", "hyperlinkEntryRegistry", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "getHyperlinkEntryRegistry$intellij_clouds_kubernetes_backend", "()Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "addClusterEventsAsLogs", "getAddClusterEventsAsLogs$intellij_clouds_kubernetes_backend", "()Z", "HyperLinkCachedCreator", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n13#2:97\n139#3:98\n1#4:99\n*S KotlinDebug\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager\n*L\n40#1:97\n57#1:98\n57#1:99\n*E\n"})
public final class KubernetesLogStateManager
implements CheckedDisposable {
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    @NotNull
    private final List<KubernetesContainerObject> currentContainers;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<KubernetesLogPresentationSettings> presentationSettings;
    @NotNull
    private final MutableStateFlow<Long> largeLogsSizeFlow;
    @NotNull
    private final MutableStateFlow<Integer> streamingLogsStatus;
    @NotNull
    private final MutableSharedFlow<Unit> updateTimePeriodAndSourcesFieldsFlow;
    @NotNull
    private final MutableSharedFlow<Instant> jumpToTimestampFlow;
    @NotNull
    private final MutableSharedFlow<Instant> clearLogsEvent;
    @NotNull
    private final KubernetesLogFilterModelImpl filterModel;
    @NotNull
    private final HyperLinkCachedCreator hyperlinkEntryRegistry;

    public KubernetesLogStateManager(@NotNull KubernetesApiModelInterface apiModel2, @NotNull Disposable pareDisposable, @NotNull List<? extends KubernetesContainerObject> currentContainers) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)pareDisposable, (String)"pareDisposable");
        Intrinsics.checkNotNullParameter(currentContainers, (String)"currentContainers");
        this.apiModel = apiModel2;
        this.currentContainers = currentContainers;
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.apiModel.getCoroutineScope(), (String)"k8s.log.manager.model", null, (boolean)false, (int)6, null);
        KubernetesLogStateManagerKt.access$getLOG$p().assertTrue(!((Collection)this.currentContainers).isEmpty());
        Disposer.register((Disposable)pareDisposable, (Disposable)((Disposable)this));
        this.presentationSettings = StateFlowKt.MutableStateFlow((Object)new KubernetesLogPresentationSettings(false, false, false, 7, null));
        this.largeLogsSizeFlow = StateFlowKt.MutableStateFlow((Object)0L);
        this.streamingLogsStatus = StateFlowKt.MutableStateFlow((Object)0);
        this.updateTimePeriodAndSourcesFieldsFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.jumpToTimestampFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.clearLogsEvent = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.filterModel = new KubernetesLogFilterModelImpl(this);
        this.hyperlinkEntryRegistry = new HyperLinkCachedCreator(this.apiModel, this);
    }

    @NotNull
    public final KubernetesApiModelInterface getApiModel$intellij_clouds_kubernetes_backend() {
        return this.apiModel;
    }

    @NotNull
    public final List<KubernetesContainerObject> getCurrentContainers$intellij_clouds_kubernetes_backend() {
        return this.currentContainers;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope$intellij_clouds_kubernetes_backend() {
        return this.coroutineScope;
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.hyperlinkEntryRegistry.clearCache$intellij_clouds_kubernetes_backend();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesLogStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("KubernetesLogStateManager disposed, coroutine scope cancelled");
    }

    public boolean isDisposed() {
        return !kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope);
    }

    @NotNull
    public final MutableStateFlow<KubernetesLogPresentationSettings> getPresentationSettings$intellij_clouds_kubernetes_backend() {
        return this.presentationSettings;
    }

    @NotNull
    public final MutableStateFlow<Long> getLargeLogsSizeFlow$intellij_clouds_kubernetes_backend() {
        return this.largeLogsSizeFlow;
    }

    @NotNull
    public final MutableStateFlow<Integer> getStreamingLogsStatus$intellij_clouds_kubernetes_backend() {
        return this.streamingLogsStatus;
    }

    @NotNull
    public final MutableSharedFlow<Unit> getUpdateTimePeriodAndSourcesFieldsFlow$intellij_clouds_kubernetes_backend() {
        return this.updateTimePeriodAndSourcesFieldsFlow;
    }

    @NotNull
    public final MutableSharedFlow<Instant> getJumpToTimestampFlow$intellij_clouds_kubernetes_backend() {
        return this.jumpToTimestampFlow;
    }

    @NotNull
    public final MutableSharedFlow<Instant> getClearLogsEvent$intellij_clouds_kubernetes_backend() {
        return this.clearLogsEvent;
    }

    @NotNull
    public final KubernetesLogFilterModelImpl getFilterModel$intellij_clouds_kubernetes_backend() {
        return this.filterModel;
    }

    @NotNull
    public final HyperLinkCachedCreator getHyperlinkEntryRegistry$intellij_clouds_kubernetes_backend() {
        return this.hyperlinkEntryRegistry;
    }

    public final boolean getAddClusterEventsAsLogs$intellij_clouds_kubernetes_backend() {
        Object v1;
        Object v0;
        block2: {
            Iterable $this$findInstanceOf$iv = this.currentContainers;
            boolean $i$f$findInstanceOf = false;
            Iterator iterator = $this$findInstanceOf$iv.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object it$iv = t = iterator.next();
                boolean bl = false;
                if (!(it$iv instanceof KubernetesEventContainerObject)) continue;
                v0 = t;
                break block2;
            }
            v0 = v1 = null;
        }
        if (!(v0 instanceof KubernetesEventContainerObject)) {
            v1 = null;
        }
        return (KubernetesEventContainerObject)v1 != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "stateManager", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "getStateManager", "()Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "cache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "getHyperlinkInfoForLog", "log", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "getHyperlinkInfoForLog$intellij_clouds_kubernetes_backend", "clearCache", "", "clearCache$intellij_clouds_kubernetes_backend", "onContainerHyperlinkClick", "container", "onEventHyperlinkClick", "buildHyperLink", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nKubernetesLogStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n72#2,2:97\n1#3:99\n*S KotlinDebug\n*F\n+ 1 KubernetesLogStateManager.kt\ncom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator\n*L\n67#1:97,2\n67#1:99\n*E\n"})
    public static final class HyperLinkCachedCreator {
        @NotNull
        private final KubernetesApiModelInterface apiModel;
        @NotNull
        private final KubernetesLogStateManager stateManager;
        @NotNull
        private final ConcurrentSkipListMap<KubernetesContainerObject, HyperlinkInfo> cache;

        public HyperLinkCachedCreator(@NotNull KubernetesApiModelInterface apiModel2, @NotNull KubernetesLogStateManager stateManager) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            Intrinsics.checkNotNullParameter((Object)stateManager, (String)"stateManager");
            this.apiModel = apiModel2;
            this.stateManager = stateManager;
            this.cache = new ConcurrentSkipListMap();
        }

        @NotNull
        public final KubernetesApiModelInterface getApiModel() {
            return this.apiModel;
        }

        @NotNull
        public final KubernetesLogStateManager getStateManager() {
            return this.stateManager;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HyperlinkInfo getHyperlinkInfoForLog$intellij_clouds_kubernetes_backend(@NotNull KubernetesContextLog log) {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            if (this.stateManager.isDisposed()) {
                KubernetesLogStateManagerKt.access$getLOG$p().error("Illegal operation - hyperlink registry is already disposed");
            }
            if (!this.stateManager.getCurrentContainers$intellij_clouds_kubernetes_backend().contains(log.getSourceObject())) {
                KubernetesLogStateManagerKt.access$getLOG$p().error("Invalid container object in hyperlink registry");
            }
            ConcurrentMap concurrentMap = this.cache;
            KubernetesContainerObject key$iv = log.getSourceObject();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                HyperlinkInfo default$iv = this.buildHyperLink(log);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
            return (HyperlinkInfo)object;
        }

        public final void clearCache$intellij_clouds_kubernetes_backend() {
            this.cache.clear();
            KubernetesLogStateManagerKt.access$getLOG$p().info("Cleanup log hyperlink entry registry");
        }

        private final void onContainerHyperlinkClick(KubernetesApiModelInterface apiModel2, KubernetesContainerObject container) {
            if (this.stateManager.isDisposed()) {
                return;
            }
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(apiModel2.getProject(), (Object)"logs-highlight-navigation-action");
            String tabName = apiModel2.getCurrentContext() + ": " + container.getName() + " logs";
            BackendKubernetesLogUtilsKt.openLogsInEditor(apiModel2, CollectionsKt.listOf((Object)container), this, tabName);
        }

        private final void onEventHyperlinkClick(KubernetesApiModelInterface apiModel2, KubernetesContainerObject container) {
            if (this.stateManager.isDisposed()) {
                return;
            }
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(apiModel2.getProject(), (Object)"logs-highlight-navigation-action");
            String tabName = apiModel2.getCurrentContext() + ": cluster events";
            BackendKubernetesLogUtilsKt.openLogsInEditor(apiModel2, CollectionsKt.listOf((Object)container), this, tabName);
        }

        private final HyperlinkInfo buildHyperLink(KubernetesContextLog log) {
            return arg_0 -> HyperLinkCachedCreator.buildHyperLink$lambda$0(log, this, arg_0);
        }

        private static final void buildHyperLink$lambda$0(KubernetesContextLog $log, HyperLinkCachedCreator this$0, Project it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!($log.getSourceObject() instanceof KubernetesEventContainerObject)) {
                this$0.onContainerHyperlinkClick(this$0.apiModel, $log.getSourceObject());
            } else {
                this$0.onEventHyperlinkClick(this$0.apiModel, $log.getSourceObject());
            }
        }
    }
}

