/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaMinLengthValidator;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "minLength", "", "<init>", "(I)V", "validateScalarValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes.backend"})
public final class OpenApiSchemaMinLengthValidator
extends YamlScalarType {
    private final int minLength;

    public OpenApiSchemaMinLengthValidator(int minLength) {
        super("minLength validator");
        this.minLength = minLength;
    }

    protected void validateScalarValue(@NotNull YAMLScalar value, @NotNull ProblemsHolder holder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = YamlUtilKt.getAsStrictString((YAMLScalar)value);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (it.length() < this.minLength) {
                Object[] objectArray = new Object[]{this.minLength};
                holder.registerProblem((PsiElement)value, KubernetesBundle.message((String)"KubernetesModelDefinition.value.too.short.error", (Object[])objectArray), new LocalQuickFix[0]);
            }
        }
    }
}

