/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.util;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/gradle/toolingExtension/util/GradleVersionSpecificsUtil;", "", "<init>", "()V", "isBuildSrcSyncedSeparately", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "isBuildTreePathAvailable", "isBuildSrcAddedInEditableBuilds", "isPluginExtensionSupported", "isKotlinPropertyAssignmentSupported", "isJavaToolchainSupported", "intellij.gradle.toolingExtension"})
public final class GradleVersionSpecificsUtil {
    @NotNull
    public static final GradleVersionSpecificsUtil INSTANCE = new GradleVersionSpecificsUtil();

    private GradleVersionSpecificsUtil() {
    }

    @JvmStatic
    public static final boolean isBuildSrcSyncedSeparately(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleOlderThan(gradleVersion, "8.0");
    }

    @JvmStatic
    public static final boolean isBuildTreePathAvailable(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast(gradleVersion, "8.2");
    }

    @JvmStatic
    public static final boolean isBuildSrcAddedInEditableBuilds(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast(gradleVersion, "7.2");
    }

    @JvmStatic
    public static final boolean isPluginExtensionSupported(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast(gradleVersion, "4.10");
    }

    @JvmStatic
    public static final boolean isKotlinPropertyAssignmentSupported(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast(gradleVersion, "8.6");
    }

    @JvmStatic
    public static final boolean isJavaToolchainSupported(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast(gradleVersion, "6.7");
    }
}

