/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.community.wintools;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.community.wintools.ntdll.FILE_PROCESS_IDS_USING_FILE_INFORMATION;
import com.intellij.community.wintools.ntdll.IO_STATUS_BLOCK;
import com.intellij.community.wintools.ntdll.NtDllExt;
import com.intellij.openapi.util.SystemInfoRt;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Result;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"getProcessLockedPath", "Lkotlin/Result;", "", "Ljava/lang/ProcessHandle;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "intellij.community.wintools"})
@SourceDebugExtension(value={"SMAP\nLockedFIleInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockedFIleInfo.kt\ncom/intellij/community/wintools/LockedFIleInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1#2:65\n1#2:81\n11705#3:66\n12052#3,3:67\n1642#4,10:70\n1915#4:80\n1916#4:82\n1652#4:83\n*S KotlinDebug\n*F\n+ 1 LockedFIleInfo.kt\ncom/intellij/community/wintools/LockedFIleInfoKt\n*L\n57#1:81\n56#1:66\n56#1:67,3\n57#1:70,10\n57#1:80\n57#1:82\n57#1:83\n*E\n"})
public final class LockedFIleInfoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Object getProcessLockedPath(@NotNull Path path) {
        LinkOption[] linkOptionArray;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl = SystemInfoRt.isWindows;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$32 = false;
            String $i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$32 = "Do not call on **nix";
            throw new AssertionError((Object)$i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$32);
        }
        Kernel32 kernel32 = Kernel32.INSTANCE;
        String fileName = ((Object)path).toString();
        WinNT.HANDLE fileHandle = kernel32.CreateFile(fileName, 128, 1, null, 3, Files.isDirectory(path2 = path, Arrays.copyOf(linkOptionArray = new LinkOption[0], linkOptionArray.length)) ? 0x2000000 : 0, null);
        if (Intrinsics.areEqual((Object)fileHandle, (Object)WinBase.INVALID_HANDLE_VALUE)) {
            return ErrorToolsKt.winFailure("Failed to open " + fileName);
        }
        int numberOfProcesses = 1;
        FILE_PROCESS_IDS_USING_FILE_INFORMATION fileInfo = null;
        int result = 0;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterator iterator;
            void $this$mapTo$iv$iv;
            boolean bl2;
            do {
                fileInfo = new FILE_PROCESS_IDS_USING_FILE_INFORMATION(numberOfProcesses);
                NtDllExt ntDllExt = NtDllExt.Companion.getINSTANCE();
                Intrinsics.checkNotNull((Object)fileHandle);
                result = ntDllExt.NtQueryInformationFile(fileHandle, new IO_STATUS_BLOCK(), fileInfo, new WinDef.ULONG((long)fileInfo.size()), 47);
                numberOfProcesses <<= 1;
            } while (result == -1073741820);
            boolean bl3 = bl2 = result == 0;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$42 = false;
                String $i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$42 = "ZwQueryInformationFile: " + result;
                throw new AssertionError((Object)$i$a$-assert-LockedFIleInfoKt$getProcessLockedPath$42);
            }
            WinDef.ULONGLONG[] $this$map$iv = fileInfo.processList;
            boolean $i$f$map = false;
            WinDef.ULONGLONG[] uLONGLONGArray = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                iterator = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.longValue());
            }
            List pids = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = pids;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ProcessHandle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                long it = ((Number)element$iv$iv).longValue();
                boolean bl6 = false;
                Optional<ProcessHandle> optional = ProcessHandle.of(it);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                if ((ProcessHandle)OptionalsKt.getOrNull(optional) == null) continue;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List processes = (List)destination$iv$iv2;
            Object object = Result.constructor-impl((Object)processes);
            return object;
        }
        finally {
            kernel32.CloseHandle(fileHandle);
        }
    }
}

