/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.lang.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.qute.lang.psi.tree.QuteElementTypesGenerated;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class QuteParserUtil
extends GeneratedParserUtilBase {
    private static final MultiMap<IElementType, IElementType> BLOCK_CLOSERS_MAP = MultiMap.createSet();
    private static final TokenSet BLOCK_TOKENS;
    private static final TokenSet WHEN_RECOVER_TOKEN_SET;
    private static final TokenSet SWITCH_RECOVER_TOKEN_SET;

    private QuteParserUtil() {
    }

    public static boolean markBadCharacters(PsiBuilder b, int l) {
        PsiBuilder.Marker mark = null;
        StringBuilder message = null;
        while (!b.eof() && b.getTokenType() == TokenType.BAD_CHARACTER) {
            if (mark == null) {
                mark = b.mark();
                message = new StringBuilder();
            }
            message.append(b.getTokenText());
            b.advanceLexer();
        }
        if (mark != null) {
            mark.error(QuarkusBundle.message("qute.parser.error.tag.name.expected", message.toString()));
        }
        return true;
    }

    public static boolean processCloseTags(PsiBuilder b, int l) {
        if (b.getTokenType() != QuteElementTypesGenerated.EXPR_START) {
            return false;
        }
        IElementType tagTokenType = b.lookAhead(1);
        if (tagTokenType == QuteElementTypesGenerated.EXPR_END) {
            b.advanceLexer();
            b.mark().error(QuarkusBundle.message("qute.parser.error.missing.tag.name", new Object[0]));
            b.advanceLexer();
            return true;
        }
        if (tagTokenType == null || !BLOCK_CLOSERS_MAP.containsKey((Object)tagTokenType)) {
            return false;
        }
        IElementType nearestBlockFrameType = QuteParserUtil.getNearestBlockFrameType(b);
        if (nearestBlockFrameType != null && BLOCK_CLOSERS_MAP.get((Object)tagTokenType).contains(nearestBlockFrameType)) {
            return false;
        }
        QuteParserUtil.consumeToken((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.EXPR_START);
        PsiBuilder.Marker mark = b.mark();
        QuteParserUtil.recoverToToken(b, l, QuteElementTypesGenerated.EXPR_END);
        if (nearestBlockFrameType == null) {
            mark.error(QuarkusBundle.message("qute.parser.error.unexpected.tag", tagTokenType));
        } else {
            LinkedHashSet expectedTokens = new LinkedHashSet();
            BLOCK_CLOSERS_MAP.entrySet().forEach(it -> {
                if (((Collection)it.getValue()).contains(nearestBlockFrameType)) {
                    expectedTokens.add(((IElementType)it.getKey()).toString());
                }
            });
            mark.error(QuarkusBundle.message("qute.parser.error.unexpected.tag.expected", tagTokenType, String.join((CharSequence)", ", ContainerUtil.map((Collection)ContainerUtil.sorted(expectedTokens), it -> "`" + it + "`"))));
        }
        QuteParserUtil.consumeToken((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.EXPR_END);
        return true;
    }

    @Nullable
    private static IElementType getNearestBlockFrameType(PsiBuilder b) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)b);
        GeneratedParserUtilBase.Frame frame = state.currentFrame;
        while (frame != null) {
            if (BLOCK_TOKENS.contains(frame.elementType)) {
                return frame.elementType;
            }
            frame = frame.parentFrame;
        }
        return null;
    }

    public static boolean recoverToToken(PsiBuilder b, int l, IElementType stopTokenType) {
        return QuteParserUtil.recoverToToken(b, l, false, stopTokenType);
    }

    public static boolean recoverToTokenWithError(PsiBuilder b, int l, IElementType stopTokenType) {
        return QuteParserUtil.recoverToToken(b, l, true, stopTokenType);
    }

    public static boolean recoverToToken(PsiBuilder b, int l, boolean reportError, IElementType stopTokenType) {
        while (!b.eof() && b.getTokenType() != stopTokenType) {
            if (reportError) {
                String tokenText = b.getTokenText();
                PsiBuilder.Marker marker = b.mark();
                b.advanceLexer();
                marker.error(QuarkusBundle.message("qute.parser.error.unexpected.token", stopTokenType, tokenText));
                reportError = false;
                continue;
            }
            b.advanceLexer();
        }
        return true;
    }

    public static boolean recoverWhenTag(PsiBuilder b, int l) {
        PsiBuilder.Marker mark = b.mark();
        boolean advanced = false;
        while (!(b.eof() || b.getTokenType() == QuteElementTypesGenerated.EXPR_START && WHEN_RECOVER_TOKEN_SET.contains(b.lookAhead(1)))) {
            advanced = true;
            b.advanceLexer();
        }
        if (advanced) {
            mark.error(QuarkusBundle.message("qute.parser.error.when.recovery.error", new Object[0]));
        } else {
            mark.drop();
        }
        return true;
    }

    public static boolean recoverSwitchTag(PsiBuilder b, int l) {
        PsiBuilder.Marker mark = b.mark();
        boolean advanced = false;
        while (!(b.eof() || b.getTokenType() == QuteElementTypesGenerated.EXPR_START && SWITCH_RECOVER_TOKEN_SET.contains(b.lookAhead(1)))) {
            advanced = true;
            b.advanceLexer();
        }
        if (advanced) {
            mark.error(QuarkusBundle.message("qute.parser.error.switch.recovery.error", new Object[0]));
        } else {
            mark.drop();
        }
        return true;
    }

    public static boolean parseIncludeTemplatePath(PsiBuilder b, int l) {
        boolean r = QuteParserUtil.parseIncludeTemplatePathPart(b);
        while (r) {
            if (QuteParserUtil.nextTokenIs((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.EXPR_END) || QuteParserUtil.isSlashExprEndAhead(b) || QuteParserUtil.isIdentifierAfterWhitespace(b)) {
                return true;
            }
            r = QuteParserUtil.parseIncludeTemplatePathPart(b);
        }
        return r;
    }

    private static boolean isIdentifierAfterWhitespace(PsiBuilder b) {
        return QuteParserUtil.nextTokenIs((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.IDENTIFIER) && b.rawLookup(-1) == TokenType.WHITE_SPACE;
    }

    private static boolean parseIncludeTemplatePathPart(PsiBuilder b) {
        boolean r = QuteParserUtil.consumeToken((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.IDENTIFIER);
        if (!r) {
            r = QuteParserUtil.consumeToken((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.DOT);
        }
        if (!r) {
            r = QuteParserUtil.consumeToken((PsiBuilder)b, (String)"..");
        }
        if (!r) {
            r = QuteParserUtil.consumeToken((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.SLASH);
        }
        return r;
    }

    private static boolean isSlashExprEndAhead(PsiBuilder b) {
        return QuteParserUtil.nextTokenIs((PsiBuilder)b, (IElementType)QuteElementTypesGenerated.SLASH) && b.lookAhead(1) == QuteElementTypesGenerated.EXPR_END;
    }

    static {
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.ELSE, Arrays.asList(QuteElementTypesGenerated.IF_BRANCH, QuteElementTypesGenerated.ELSE_IF_BRANCH, QuteElementTypesGenerated.IS_BRANCH, QuteElementTypesGenerated.FOR_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.ELSE_IF, Arrays.asList(QuteElementTypesGenerated.IF_BRANCH, QuteElementTypesGenerated.ELSE_IF_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.IF_END, Arrays.asList(QuteElementTypesGenerated.IF_BRANCH, QuteElementTypesGenerated.ELSE_IF_BRANCH, QuteElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.WHEN_END, Arrays.asList(QuteElementTypesGenerated.WHEN_SECTION, QuteElementTypesGenerated.IS_BRANCH, QuteElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.IS_START, Arrays.asList(QuteElementTypesGenerated.WHEN_SECTION, QuteElementTypesGenerated.IS_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.SWITCH_END, Arrays.asList(QuteElementTypesGenerated.SWITCH_SECTION, QuteElementTypesGenerated.CASE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.CASE_START, Arrays.asList(QuteElementTypesGenerated.SWITCH_SECTION, QuteElementTypesGenerated.CASE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.FOR_END, List.of(QuteElementTypesGenerated.FOR_BRANCH, QuteElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.EACH_END, List.of(QuteElementTypesGenerated.EACH_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.WITH_END, List.of(QuteElementTypesGenerated.WITH_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.LET_END, List.of(QuteElementTypesGenerated.LET_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.SET_END, List.of(QuteElementTypesGenerated.SET_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.INCLUDE_END, List.of(QuteElementTypesGenerated.INCLUDE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.INSERT_END, List.of(QuteElementTypesGenerated.INSERT_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.CUSTOM_END, List.of(QuteElementTypesGenerated.CUSTOM_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)QuteElementTypesGenerated.SHORT_END_TAG, Arrays.asList(QuteElementTypesGenerated.IF_BRANCH, QuteElementTypesGenerated.ELSE_IF_BRANCH, QuteElementTypesGenerated.ELSE_BRANCH, QuteElementTypesGenerated.WHEN_SECTION, QuteElementTypesGenerated.IS_BRANCH, QuteElementTypesGenerated.ELSE_BRANCH, QuteElementTypesGenerated.SWITCH_SECTION, QuteElementTypesGenerated.CASE_BRANCH, QuteElementTypesGenerated.FOR_BRANCH, QuteElementTypesGenerated.EACH_BRANCH, QuteElementTypesGenerated.WITH_BRANCH, QuteElementTypesGenerated.LET_BRANCH, QuteElementTypesGenerated.SET_BRANCH, QuteElementTypesGenerated.INCLUDE_BRANCH, QuteElementTypesGenerated.INSERT_BRANCH, QuteElementTypesGenerated.CUSTOM_BRANCH));
        BLOCK_TOKENS = TokenSet.create((IElementType[])BLOCK_CLOSERS_MAP.values().toArray(IElementType.EMPTY_ARRAY));
        WHEN_RECOVER_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{QuteElementTypesGenerated.IS_START, QuteElementTypesGenerated.WHEN_END, QuteElementTypesGenerated.ELSE});
        SWITCH_RECOVER_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{QuteElementTypesGenerated.CASE_START, QuteElementTypesGenerated.SWITCH_END});
    }
}

