/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.qute.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.JamNavigationUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.CustomNavigationGutterIconBuilder;
import com.intellij.quarkus.QsLineMarkerBuilderKt;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.uast.UastSmartPointer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0014J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0014\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0016\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00190\u0018H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0018\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020 H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/quarkus/qute/navigation/QuteTemplateLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "isRecordTemplateDeclaration", "uElement", "Lorg/jetbrains/uast/UElement;", "isMethodTemplateDeclaration", "isInjectedTemplate", "hasInjectAnnotation", "createLineMarker", "psiElement", "targetsProvider", "Lkotlin/Function0;", "", "findTemplateFiles", "Lcom/intellij/psi/PsiFile;", "uastSmartPointer", "Lcom/intellij/uast/UastSmartPointer;", "Lorg/jetbrains/uast/UDeclaration;", "getTemplateName", "", "templateUDeclaration", "getTemplatePath", "topmostPsiClass", "Lcom/intellij/psi/PsiClass;", "getCheckedTemplateAttribute", "annoAttributeName", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQuteTemplateLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuteTemplateLineMarkerProvider.kt\ncom/intellij/quarkus/qute/navigation/QuteTemplateLineMarkerProvider\n+ 2 UastSmartPointer.kt\ncom/intellij/uast/UastSmartPointerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,151:1\n20#2:152\n18#3:153\n18#3:154\n18#3:155\n18#3:158\n18#3:191\n66#4,2:156\n62#4,2:159\n43#4,13:161\n3938#5:174\n4474#5,2:175\n1642#6,10:177\n1915#6:187\n1916#6:189\n1652#6:190\n296#6,2:192\n296#6,2:196\n1#7:188\n1#7:194\n18#8:195\n*S KotlinDebug\n*F\n+ 1 QuteTemplateLineMarkerProvider.kt\ncom/intellij/quarkus/qute/navigation/QuteTemplateLineMarkerProvider\n*L\n45#1:152\n55#1:153\n63#1:154\n69#1:155\n74#1:158\n115#1:191\n70#1:156,2\n90#1:159,2\n90#1:161,13\n107#1:174\n107#1:175,2\n108#1:177,10\n108#1:187\n108#1:189\n108#1:190\n128#1:192,2\n147#1:196,2\n108#1:188\n145#1:195\n*E\n"})
public final class QuteTemplateLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement2);
        if (QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            super.collectNavigationMarkers(elements, result, forNavigation);
        }
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
        UDeclaration uDeclaration = uElement instanceof UDeclaration ? (UDeclaration)uElement : null;
        if (uDeclaration == null) {
            return;
        }
        UDeclaration uElement2 = uDeclaration;
        if (this.isRecordTemplateDeclaration((UElement)uElement2) || this.isMethodTemplateDeclaration((UElement)uElement2) || this.isInjectedTemplate((UElement)uElement2)) {
            UElement $this$createUastSmartPointer$iv = (UElement)uElement2;
            boolean $i$f$createUastSmartPointer = false;
            UastSmartPointer uSmartPointer = new UastSmartPointer($this$createUastSmartPointer$iv, UDeclaration.class);
            result.add(this.createLineMarker(element, (Function0<? extends Set<? extends PsiElement>>)((Function0)() -> QuteTemplateLineMarkerProvider.collectNavigationMarkers$lambda$0(this, uSmartPointer))));
        }
    }

    private final boolean isRecordTemplateDeclaration(UElement uElement) {
        return uElement instanceof UClass && ((UClass)uElement).getJavaPsi().isRecord();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMethodTemplateDeclaration(UElement uElement) {
        UElement $this$asSafely$iv = uElement;
        boolean $i$f$asSafely = false;
        UElement uElement2 = $this$asSafely$iv;
        if (!(uElement2 instanceof UMethod)) {
            uElement2 = null;
        }
        UMethod uMethod = (UMethod)uElement2;
        UMethod uMethod2 = uMethod;
        if (uMethod == null) return false;
        if ((uMethod2 = uMethod2.getJavaPsi()) == null) {
            return false;
        }
        UMethod psiMethod = uMethod2;
        if (!psiMethod.hasModifier(JvmModifier.STATIC)) return false;
        if (!psiMethod.hasModifier(JvmModifier.NATIVE)) return false;
        PsiType psiType = psiMethod.getReturnType();
        if (psiType == null) return false;
        if (!psiType.equalsToText("io.quarkus.qute.TemplateInstance")) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) return false;
        if (!psiClass.hasAnnotation("io.quarkus.qute.CheckedTemplate")) return false;
        return true;
    }

    private final boolean isInjectedTemplate(UElement uElement) {
        UVariable uVariable;
        UElement $this$asSafely$iv = uElement;
        boolean $i$f$asSafely = false;
        UElement uElement2 = $this$asSafely$iv;
        if (!(uElement2 instanceof UVariable)) {
            uElement2 = null;
        }
        return ((uVariable = (UVariable)uElement2) != null && (uVariable = uVariable.getType()) != null ? uVariable.equalsToText("io.quarkus.qute.Template") : false) && this.hasInjectAnnotation(uElement);
    }

    private final boolean hasInjectAnnotation(UElement uElement) {
        PsiField psiModifierListOwner;
        PsiField psiField;
        UElement uElement2 = uElement;
        if (uElement2 instanceof UField) {
            PsiElement $this$asSafely$iv = ((UField)uElement).getJavaPsi();
            boolean $i$f$asSafely = false;
            PsiElement psiElement = $this$asSafely$iv;
            if (!(psiElement instanceof PsiField)) {
                psiElement = null;
            }
            psiField = (PsiField)psiElement;
        } else if (uElement2 instanceof UParameter) {
            PsiElement psiElement = ((UParameter)uElement).getJavaPsi();
            if (psiElement != null) {
                PsiElement $this$parentOfType_u24default$iv = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                psiField = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiMethod.class, (boolean)true);
            } else {
                psiField = null;
            }
        } else {
            psiField = null;
        }
        if (psiField == null) {
            return false;
        }
        PsiField $this$asSafely$iv = psiModifierListOwner = psiField;
        boolean $i$f$asSafely = false;
        PsiField psiField2 = $this$asSafely$iv;
        if (!(psiField2 instanceof PsiMethod)) {
            psiField2 = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiField2;
        return (psiMethod != null ? psiMethod.isConstructor() : false) || CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)psiModifierListOwner, 0);
    }

    private final RelatedItemLineMarkerInfo<PsiElement> createLineMarker(PsiElement psiElement, Function0<? extends Set<? extends PsiElement>> targetsProvider) {
        CustomNavigationGutterIconBuilder customNavigationGutterIconBuilder;
        NotNullFunction converter = ContainerUtil::createMaybeSingletonList;
        Icon icon = AllIcons.FileTypes.Any_type;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Any_type");
        CustomNavigationGutterIconBuilder $this$createLineMarker_u24lambda_u240 = customNavigationGutterIconBuilder = QsLineMarkerBuilderKt.createCustomNavigationBuilder(icon, converter, null);
        boolean bl = false;
        $this$createLineMarker_u24lambda_u240.setTargets(NotNullLazyValue.lazy(() -> QuteTemplateLineMarkerProvider.createLineMarker$lambda$0$0(targetsProvider)));
        $this$createLineMarker_u24lambda_u240.setTargetRenderer(JamNavigationUtilsKt::getCacheableTargetRenderer);
        $this$createLineMarker_u24lambda_u240.setTooltipText(QuarkusBundle.message("qute.open.template", new Object[0]));
        $this$createLineMarker_u24lambda_u240.setEmptyPopupText(QuarkusBundle.message("qute.no.template.found", new Object[0]));
        return customNavigationGutterIconBuilder.createMergeableLineMarkerInfo(psiElement);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PsiFile> findTemplateFiles(UastSmartPointer<UDeclaration> uastSmartPointer) {
        Set set;
        Set set2;
        VirtualFile $i$f$findTopmostParentOfType2;
        PsiElement current$iv$iv;
        VirtualFile[] virtualFileArray;
        VirtualFile[] virtualFileArray2;
        UDeclaration uDeclaration;
        block21: {
            block20: {
                PsiElement psiElement;
                PsiElement psiElement2;
                void $this$findTopmostParentInFile$iv$iv;
                UDeclaration uDeclaration2 = (UDeclaration)uastSmartPointer.getElement();
                if (uDeclaration2 == null) {
                    return SetsKt.emptySet();
                }
                uDeclaration = uDeclaration2;
                virtualFileArray2 = uDeclaration.getJavaPsi();
                if (virtualFileArray2 == null) break block20;
                VirtualFile[] $this$findTopmostParentOfType_u24default$iv = virtualFileArray2;
                boolean strict$iv = true;
                boolean $i$f$findTopmostParentOfType2 = false;
                virtualFileArray = $this$findTopmostParentOfType_u24default$iv;
                boolean withSelf$iv$iv = false;
                boolean $i$f$findTopmostParentInFile = false;
                PsiElement answer$iv$iv = null;
                if ($this$findTopmostParentInFile$iv$iv instanceof PsiFile) {
                    psiElement2 = null;
                } else {
                    for (current$iv$iv = $this$findTopmostParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                        PsiElement it$iv = current$iv$iv;
                        boolean bl = false;
                        if (it$iv instanceof PsiClass) {
                            answer$iv$iv = current$iv$iv;
                        }
                        if (current$iv$iv instanceof PsiFile) break;
                    }
                    psiElement2 = psiElement = answer$iv$iv;
                }
                if (!(psiElement2 instanceof PsiClass)) {
                    psiElement = null;
                }
                if ((virtualFileArray2 = (VirtualFile[])((PsiElement)((PsiClass)psiElement))) != null) break block21;
            }
            return SetsKt.emptySet();
        }
        VirtualFile[] topmostPsiClass = virtualFileArray2;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)topmostPsiClass);
        if (module == null) {
            return SetsKt.emptySet();
        }
        Module module2 = module;
        String templatePath = this.getTemplatePath(uDeclaration, (PsiClass)topmostPsiClass);
        List list = ModuleRootManager.getInstance((Module)module2).getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
        VirtualFile strict$iv = (VirtualFile)CollectionsKt.firstOrNull((List)list);
        if (strict$iv == null || ($i$f$findTopmostParentOfType2 = strict$iv.findFileByRelativePath(templatePath)) == null) {
            return SetsKt.emptySet();
        }
        VirtualFile virtualFile = $i$f$findTopmostParentOfType2;
        PsiManager psiManager = topmostPsiClass.getManager();
        if (VirtualFileUtil.isFile((VirtualFile)virtualFile)) {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile == null) {
                return SetsKt.emptySet();
            }
            PsiFile psiFile2 = psiFile;
            return SetsKt.setOf((Object)psiFile2);
        }
        String string = this.getTemplateName(uDeclaration);
        if (string == null) {
            return SetsKt.emptySet();
        }
        String templateName = string;
        virtualFileArray = virtualFile.getChildren();
        if (virtualFileArray != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            VirtualFile[] $i$f$findTopmostParentInFile = virtualFileArray;
            boolean $i$f$filter22 = false;
            current$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)templateName, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)psiManager);
            PsiManager psiManager2 = psiManager;
            boolean $i$f$mapNotNull = false;
            void $i$f$filterTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile p0 = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (psiManager2.findFile(p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final String getTemplateName(UDeclaration templateUDeclaration) {
        PsiElement $this$asSafely$iv = templateUDeclaration.getJavaPsi();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
        String declarationName = psiNamedElement != null ? psiNamedElement.getName() : null;
        String namingStrategy = this.getCheckedTemplateAttribute(templateUDeclaration, "defaultName");
        String string = namingStrategy;
        return Intrinsics.areEqual((Object)string, (Object)"<<hyphenated element name>>") ? RelaxedNames.camelCaseToHyphen((String)declarationName) : (Intrinsics.areEqual((Object)string, (Object)"<<underscored element name>>") ? RelaxedNames.camelCaseToUnderscore((String)declarationName) : declarationName);
    }

    private final String getTemplatePath(UDeclaration templateUDeclaration, PsiClass topmostPsiClass) {
        StringBuilder stringBuilder;
        if (topmostPsiClass.hasAnnotation("io.quarkus.qute.CheckedTemplate")) {
            return "templates";
        }
        if (templateUDeclaration instanceof UField || templateUDeclaration instanceof UParameter) {
            String string;
            Object object;
            String $i$f$firstOrNull2;
            Object v0;
            Iterable $this$firstOrNull$iv;
            block7: {
                $this$firstOrNull$iv = templateUDeclaration.getUAnnotations();
                boolean $i$f$firstOrNull2 = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UAnnotation uAnnotation = (UAnnotation)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)uAnnotation.getQualifiedName(), (Object)"io.quarkus.qute.Location")) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            UAnnotation uAnnotation = v0;
            if (uAnnotation != null && ($this$firstOrNull$iv = uAnnotation.findDeclaredAttributeValue("value")) != null && ($i$f$firstOrNull2 = UastUtils.evaluateString((UExpression)$this$firstOrNull$iv)) != null) {
                String it = $i$f$firstOrNull2;
                boolean bl = false;
                object = "/" + it;
            } else {
                object = string = null;
            }
            if (object == null) {
                string = "";
            }
            String customPath = string;
            return "templates" + customPath;
        }
        String basePath = this.getCheckedTemplateAttribute(templateUDeclaration, "basePath");
        StringBuilder $this$getTemplatePath_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getTemplatePath_u24lambda_u242.append("templates");
        $this$getTemplatePath_u24lambda_u242.append("/");
        String string = basePath;
        if (string == null) {
            string = topmostPsiClass.getName();
        }
        $this$getTemplatePath_u24lambda_u242.append(string);
        $this$getTemplatePath_u24lambda_u242.append("/");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getCheckedTemplateAttribute(UDeclaration templateUDeclaration, String annoAttributeName) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            UElement $this$getParentOfType_u24default$iv = (UElement)templateUDeclaration;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType22 = false;
            UClass uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
            if (uClass == null) return null;
            List list = uClass.getUAnnotations();
            if (list == null) return null;
            Iterable $i$f$getParentOfType22 = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UAnnotation it = (UAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"io.quarkus.qute.CheckedTemplate")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        UAnnotation uAnnotation = v0;
        if (uAnnotation == null) return null;
        UExpression uExpression = uAnnotation.findDeclaredAttributeValue(annoAttributeName);
        if (uExpression == null) return null;
        String string = UastUtils.evaluateString((UExpression)uExpression);
        return string;
    }

    private static final Set collectNavigationMarkers$lambda$0(QuteTemplateLineMarkerProvider this$0, UastSmartPointer $uSmartPointer) {
        return this$0.findTemplateFiles((UastSmartPointer<UDeclaration>)$uSmartPointer);
    }

    private static final Collection createLineMarker$lambda$0$0(Function0 $tmp0) {
        return (Collection)$tmp0.invoke();
    }
}

