/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.run.QsRunConfigurationService;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u001a\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/quarkus/run/QsOpenDevUiAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getDevUiUrl", "", "openDevUI", "url", "project", "Lcom/intellij/openapi/project/Project;", "getProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "isRunning", "", "(Lcom/intellij/execution/process/ProcessHandler;)Z", "qsServerConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "getQsServerConfiguration", "(Lcom/intellij/execution/process/ProcessHandler;)Lcom/intellij/quarkus/run/QsServerConfiguration;", "intellij.quarkus"})
public final class QsOpenDevUiAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProcessHandler processHandler2 = this.getProcessHandler(e);
        e.getPresentation().setVisible(this.getQsServerConfiguration(processHandler2) != null);
        e.getPresentation().setEnabled(e.getProject() != null && this.isRunning(processHandler2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = this.getDevUiUrl(e);
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        this.openDevUI(string, project);
    }

    private final String getDevUiUrl(AnActionEvent e) {
        StringBuilder stringBuilder;
        QsServerConfiguration qsServerConfiguration = this.getQsServerConfiguration(this.getProcessHandler(e));
        Intrinsics.checkNotNull((Object)qsServerConfiguration);
        QsServerConfiguration qsServerConfiguration2 = qsServerConfiguration;
        StringBuilder $this$getDevUiUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDevUiUrl_u24lambda_u240.append(qsServerConfiguration2.getApplicationUrl());
        $this$getDevUiUrl_u24lambda_u240.append("/q/dev-ui");
        return stringBuilder.toString();
    }

    private final void openDevUI(String url, Project project) {
        if (JBCefApp.isSupported()) {
            HTMLEditorProvider.Companion.openEditor(project, QuarkusBundle.message("dev.ui.editor.tab.title", new Object[0]), HTMLEditorProvider.Request.Companion.url(url));
        } else {
            BrowserUtil.browse((String)url);
        }
    }

    private final ProcessHandler getProcessHandler(AnActionEvent e) {
        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        return runContentDescriptor != null ? runContentDescriptor.getProcessHandler() : null;
    }

    private final boolean isRunning(ProcessHandler $this$isRunning) {
        ProcessHandler processHandler2 = $this$isRunning;
        return (processHandler2 != null ? !processHandler2.isProcessTerminating() : false) && !$this$isRunning.isProcessTerminated();
    }

    private final QsServerConfiguration getQsServerConfiguration(ProcessHandler $this$qsServerConfiguration) {
        ProcessHandler processHandler2 = $this$qsServerConfiguration;
        return processHandler2 != null ? (QsServerConfiguration)processHandler2.getUserData(QsRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY()) : null;
    }
}

