/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.application;

import com.intellij.application.options.ModulesCombo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.application.JavaSettingsEditorBase;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.CommonJavaFragments;
import com.intellij.execution.ui.CommonParameterFragments;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TagButton;
import com.intellij.execution.ui.TargetPathFragment;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.application.QsApplicationRunConfiguration;
import com.intellij.quarkus.run.application.QsApplicationSettingsEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J<\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\nH\u0002J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140\nH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140\nH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/quarkus/run/application/QsApplicationSettingsEditor;", "Lcom/intellij/execution/application/JavaSettingsEditorBase;", "Lcom/intellij/quarkus/run/application/QsApplicationRunConfiguration;", "runConfiguration", "<init>", "(Lcom/intellij/quarkus/run/application/QsApplicationRunConfiguration;)V", "customizeFragments", "", "fragments", "", "Lcom/intellij/execution/ui/SettingsEditorFragment;", "moduleClasspath", "Lcom/intellij/execution/ui/ModuleClasspathCombo;", "commonParameterFragments", "Lcom/intellij/execution/ui/CommonParameterFragments;", "createJrePathFragment", "Lcom/intellij/execution/ui/JrePathEditor;", "mainClassFragment", "Lcom/intellij/execution/application/ClassEditorField;", "createIncludeProvidedDependenciesFragment", "Lcom/intellij/execution/ui/TagButton;", "createEmulateTerminalFragment", "createMainClassFragment", "modulesCombo", "Lcom/intellij/application/options/ModulesCombo;", "intellij.quarkus"})
public final class QsApplicationSettingsEditor
extends JavaSettingsEditorBase<QsApplicationRunConfiguration> {
    public QsApplicationSettingsEditor(@NotNull QsApplicationRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        super((JavaRunConfigurationBase)runConfiguration);
    }

    protected void customizeFragments(@NotNull List<SettingsEditorFragment<QsApplicationRunConfiguration, ?>> fragments, @NotNull SettingsEditorFragment<QsApplicationRunConfiguration, ModuleClasspathCombo> moduleClasspath, @NotNull CommonParameterFragments<QsApplicationRunConfiguration> commonParameterFragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter(moduleClasspath, (String)"moduleClasspath");
        Intrinsics.checkNotNullParameter(commonParameterFragments, (String)"commonParameterFragments");
        fragments.add(this.createIncludeProvidedDependenciesFragment());
        SettingsEditorFragment settingsEditorFragment = commonParameterFragments.programArguments();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"programArguments(...)");
        fragments.add(settingsEditorFragment);
        fragments.add((SettingsEditorFragment<QsApplicationRunConfiguration, ?>)new TargetPathFragment());
        SettingsEditorFragment settingsEditorFragment2 = commonParameterFragments.createRedirectFragment();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment2, (String)"createRedirectFragment(...)");
        fragments.add(settingsEditorFragment2);
        JComponent jComponent = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component(...)");
        SettingsEditorFragment<QsApplicationRunConfiguration, ClassEditorField> mainClassFragment = this.createMainClassFragment((ModulesCombo)jComponent);
        fragments.add(mainClassFragment);
        SettingsEditorFragment<QsApplicationRunConfiguration, JrePathEditor> jrePath = this.createJrePathFragment(moduleClasspath, mainClassFragment);
        fragments.add(jrePath);
        SettingsEditorFragment settingsEditorFragment3 = this.createShortenClasspath((ModuleClasspathCombo)moduleClasspath.component(), jrePath, true);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment3, (String)"createShortenClasspath(...)");
        fragments.add(settingsEditorFragment3);
        fragments.add(this.createEmulateTerminalFragment());
    }

    private final SettingsEditorFragment<QsApplicationRunConfiguration, JrePathEditor> createJrePathFragment(SettingsEditorFragment<QsApplicationRunConfiguration, ModuleClasspathCombo> moduleClasspath, SettingsEditorFragment<QsApplicationRunConfiguration, ClassEditorField> mainClassFragment) {
        JComponent jComponent = moduleClasspath.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component(...)");
        ModuleClasspathCombo moduleClasspathCombo = (ModuleClasspathCombo)jComponent;
        JComponent jComponent2 = mainClassFragment.component();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"component(...)");
        DefaultJreSelector jreSelector = DefaultJreSelector.Companion.fromSourceRootsDependencies(moduleClasspathCombo, (EditorTextField)jComponent2);
        SettingsEditorFragment settingsEditorFragment = CommonJavaFragments.createJrePath((DefaultJreSelector)jreSelector);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"createJrePath(...)");
        return settingsEditorFragment;
    }

    private final SettingsEditorFragment<QsApplicationRunConfiguration, TagButton> createIncludeProvidedDependenciesFragment() {
        SettingsEditorFragment settingsEditorFragment = SettingsEditorFragment.createTag((String)"include.provided", (String)ExecutionBundle.message((String)"application.configuration.include.provided.scope", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), QsApplicationSettingsEditor::createIncludeProvidedDependenciesFragment$lambda$0, QsApplicationSettingsEditor::createIncludeProvidedDependenciesFragment$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"createTag(...)");
        return settingsEditorFragment;
    }

    private final SettingsEditorFragment<QsApplicationRunConfiguration, TagButton> createEmulateTerminalFragment() {
        SettingsEditorFragment settingsEditorFragment = SettingsEditorFragment.createTag((String)"emulateTerminal", (String)QuarkusBundle.message("application.run.configuration.emulate.terminal", new Object[0]), (String)ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), QsApplicationRunConfiguration::emulateTerminal$intellij_quarkus, QsApplicationRunConfiguration::setEmulateTerminal$intellij_quarkus);
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditorFragment, (String)"createTag(...)");
        return settingsEditorFragment;
    }

    private final SettingsEditorFragment<QsApplicationRunConfiguration, ClassEditorField> createMainClassFragment(ModulesCombo modulesCombo) {
        Project project = this.getProject();
        ConfigurationModuleSelector moduleSelector2 = new ConfigurationModuleSelector(modulesCombo, project){

            public boolean isModuleAccepted(Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return QuarkusUtils.INSTANCE.hasQuarkusLibrary(module);
            }
        };
        JavaCodeFragment.VisibilityChecker visibilityChecker = QsApplicationSettingsEditor::createMainClassFragment$lambda$0;
        ClassBrowser.AppClassBrowser classBrowser = new ClassBrowser.AppClassBrowser(this.getProject(), moduleSelector2);
        ClassEditorField classEditorField = ClassEditorField.createClassField((Project)this.getProject(), null, (JavaCodeFragment.VisibilityChecker)visibilityChecker, (BrowseModuleValueActionListener)((BrowseModuleValueActionListener)classBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)classEditorField, (String)"createClassField(...)");
        ClassEditorField mainClass = classEditorField;
        mainClass.setBackground(UIUtil.getTextFieldBackground());
        mainClass.setShowPlaceholderWhenFocused(true);
        CommonParameterFragments.setMonospaced((Component)((Component)mainClass));
        String string = ExecutionBundle.message((String)"application.configuration.main.class.placeholder", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String placeholder = string;
        mainClass.setPlaceholder((CharSequence)placeholder);
        mainClass.getAccessibleContext().setAccessibleName(placeholder);
        CommandLinePanel.setMinimumWidth((Component)((Component)mainClass), (int)300);
        SettingsEditorFragment mainClassFragment = new SettingsEditorFragment("mainClass", ExecutionBundle.message((String)"application.configuration.main.class", (Object[])new Object[0]), null, (JComponent)mainClass, 20, (arg_0, arg_1) -> QsApplicationSettingsEditor.createMainClassFragment$lambda$2(QsApplicationSettingsEditor::createMainClassFragment$lambda$1, arg_0, arg_1), (arg_0, arg_1) -> QsApplicationSettingsEditor.createMainClassFragment$lambda$4(QsApplicationSettingsEditor::createMainClassFragment$lambda$3, arg_0, arg_1), arg_0 -> QsApplicationSettingsEditor.createMainClassFragment$lambda$6(QsApplicationSettingsEditor::createMainClassFragment$lambda$5, arg_0));
        mainClassFragment.setRemovable(false);
        mainClassFragment.setEditorGetter(arg_0 -> QsApplicationSettingsEditor.createMainClassFragment$lambda$8(QsApplicationSettingsEditor::createMainClassFragment$lambda$7, arg_0));
        mainClassFragment.setValidation(arg_0 -> QsApplicationSettingsEditor.createMainClassFragment$lambda$10(arg_0 -> QsApplicationSettingsEditor.createMainClassFragment$lambda$9(mainClass, arg_0), arg_0));
        mainClass.addDocumentListener(new DocumentListener(this, mainClass, moduleSelector2, modulesCombo){
            final /* synthetic */ QsApplicationSettingsEditor this$0;
            final /* synthetic */ ClassEditorField $mainClass;
            final /* synthetic */ createMainClassFragment.moduleSelector.1 $moduleSelector;
            final /* synthetic */ ModulesCombo $modulesCombo;
            {
                this.this$0 = $receiver;
                this.$mainClass = $mainClass;
                this.$moduleSelector = $moduleSelector;
                this.$modulesCombo = $modulesCombo;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = QsApplicationSettingsEditor.access$getProject(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getProject(...)");
                if (DumbService.Companion.getInstance(project).isDumb()) {
                    return;
                }
                String string = this.$mainClass.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = string;
                if (this.$moduleSelector.getModule() != null && this.$moduleSelector.findClass(text) != null) {
                    return;
                }
                JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(QsApplicationSettingsEditor.access$getProject(this.this$0), false);
                PsiClass psiClass = configurationModule.findClass(text);
                if (psiClass == null) {
                    return;
                }
                PsiClass psiClass2 = psiClass;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass2));
                if (module != null && this.$moduleSelector.isModuleAccepted(module)) {
                    this.$modulesCombo.setSelectedModule(module);
                }
            }
        });
        return mainClassFragment;
    }

    private static final boolean createIncludeProvidedDependenciesFragment$lambda$0(QsApplicationRunConfiguration it) {
        return it.isProvidedScopeIncluded();
    }

    private static final void createIncludeProvidedDependenciesFragment$lambda$1(QsApplicationRunConfiguration configuration, Boolean value) {
        Intrinsics.checkNotNull((Object)value);
        configuration.setIncludeProvidedScope(value);
    }

    private static final void createMainClassFragment$lambda$9$0(QsApplicationRunConfiguration $it) {
        $it.checkClass();
    }

    private static final JavaCodeFragment.VisibilityChecker.Visibility createMainClassFragment$lambda$0(PsiElement declaration, PsiElement psiElement) {
        if (declaration instanceof PsiClass && PsiMethodUtil.hasMainMethod((PsiClass)((PsiClass)declaration))) {
            return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
        }
        return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
    }

    private static final Unit createMainClassFragment$lambda$1(QsApplicationRunConfiguration configuration, ClassEditorField component) {
        component.setClassName(configuration.getMainClassName());
        return Unit.INSTANCE;
    }

    private static final void createMainClassFragment$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createMainClassFragment$lambda$3(QsApplicationRunConfiguration configuration, ClassEditorField component) {
        configuration.setMainClassName(component.getText());
        return Unit.INSTANCE;
    }

    private static final void createMainClassFragment$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean createMainClassFragment$lambda$5(QsApplicationRunConfiguration it) {
        return true;
    }

    private static final boolean createMainClassFragment$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final JComponent createMainClassFragment$lambda$7(ClassEditorField it) {
        Object object = it.getEditor();
        if (object == null || (object = object.getContentComponent()) == null) {
            object = (JComponent)it;
        }
        return object;
    }

    private static final JComponent createMainClassFragment$lambda$8(Function1 $tmp0, Object p0) {
        return (JComponent)$tmp0.invoke(p0);
    }

    private static final List createMainClassFragment$lambda$9(ClassEditorField $mainClass, QsApplicationRunConfiguration it) {
        return CollectionsKt.listOf((Object)RuntimeConfigurationException.validate((JComponent)((JComponent)$mainClass), () -> QsApplicationSettingsEditor.createMainClassFragment$lambda$9$0(it)));
    }

    private static final List createMainClassFragment$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject(QsApplicationSettingsEditor $this) {
        return $this.getProject();
    }
}

