/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.inspections.fixes;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELSelectExpression;
import com.intellij.javaee.el.psi.ELSliceExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DeclareELVarFix
implements LocalQuickFix {
    protected String myVarId;

    protected DeclareELVarFix(String varId) {
        this.myVarId = varId;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaeeJspBundle.message("el.declare.variable.intention.family", new Object[0]);
        if (string == null) {
            DeclareELVarFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement holderParent;
        Editor editor;
        if (project == null) {
            DeclareELVarFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DeclareELVarFix.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile file = psiElement.getContainingFile();
        Editor editor2 = editor = IntentionPreviewUtils.isIntentionPreviewActive() ? IntentionPreviewUtils.getPreviewEditor() : FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file.getVirtualFile()), false);
        if (editor == null) {
            return;
        }
        ELExpressionHolder holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ELExpressionHolder.class);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        Set<String> guess = DeclareELVarFix.findAcceptableClassNames(psiElement, holder);
        MacroCallNode selectClassExpression = guess.isEmpty() ? new MacroCallNode(MacroFactory.createMacro((String)"complete")) : new ConstantNode(ApplicationManager.getApplication().isUnitTestMode() && guess.contains("java.lang.String") ? "java.lang.String" : guess.iterator().next()).withLookupStrings(guess);
        PsiElement psiElement2 = holderParent = holder == null ? psiElement : holder.getParent();
        int templateStartOffset = holderParent instanceof XmlAttributeValue ? holderParent.getParent().getParent().getTextOffset() : (holderParent instanceof XmlTag ? ((XmlTag)holderParent).getValue().getTextRange().getStartOffset() : (holder == null ? psiElement.getTextOffset() : holder.getTextOffset()));
        this.buildPresentationTemplate(editor, templateStartOffset, template, (Expression)selectClassExpression);
        editor.getCaretModel().moveToOffset(templateStartOffset);
        manager.startTemplate(editor, template);
    }

    protected abstract void buildPresentationTemplate(Editor var1, int var2, Template var3, Expression var4);

    @NotNull
    private static Set<String> findAcceptableClassNames(PsiElement context, ELExpressionHolder holder) {
        ELVariable variable;
        PsiElement xmlAttr;
        PsiElement parentElement = context.getParent();
        if (parentElement instanceof ELExpressionHolder && parentElement.getParent() instanceof XmlAttributeValue && (xmlAttr = parentElement.getParent().getParent()) instanceof XmlAttribute && "items".equals(((XmlAttribute)xmlAttr).getName())) {
            return new LinkedHashSet<String>(Collections.singletonList("java.util.List"));
        }
        if (parentElement instanceof ELSliceExpression) {
            return new LinkedHashSet<String>(Arrays.asList("java.util.List", "java.util.Map"));
        }
        boolean parentIsSelect = parentElement instanceof ELSelectExpression;
        if (!parentIsSelect && !(parentElement instanceof ELMethodCallExpression)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DeclareELVarFix.$$$reportNull$$$0(3);
            }
            return set;
        }
        ELVariable eLVariable = variable = parentIsSelect ? ((ELSelectExpression)parentElement).getField() : ((ELMethodCallExpression)parentElement).getMethod();
        if (variable == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DeclareELVarFix.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<String> possibleClassNames = new HashSet<String>();
        boolean isMethodReference = holder.isJSFELHolder() && (parentElement.getParent() instanceof ELMethodCallExpression || parentElement.getParent() instanceof ELExpressionHolder);
        @NonNls String getterName = "get" + StringUtil.capitalize((String)variable.getText());
        Object nameToLookFor = isMethodReference ? variable.getText() : getterName;
        Runnable process = () -> DeclareELVarFix.lambda$findAcceptableClassNames$0(context, (String)nameToLookFor, possibleClassNames, isMethodReference, getterName);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(process, JavaeeJspBundle.message("el.declare.variable.find.acceptable.class", new Object[0]), false, context.getProject());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = ArrayUtilRt.toStringArray(possibleClassNames);
            Arrays.sort(strings);
            return new LinkedHashSet<Object>(Arrays.asList(strings));
        }
        HashSet<String> hashSet = possibleClassNames;
        if (hashSet == null) {
            DeclareELVarFix.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void lambda$findAcceptableClassNames$0(PsiElement context, String nameToLookFor, Set possibleClassNames, boolean isMethodReference, String getterName) {
        PsiFile file = context.getContainingFile();
        CreateFromUsageUtils.addClassesWithMember((String)nameToLookFor, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)false, (boolean)false);
        CreateFromUsageUtils.addClassesWithMember((String)nameToLookFor, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)true, (boolean)false);
        if (isMethodReference) {
            CreateFromUsageUtils.addClassesWithMember((String)getterName, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)false, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)getterName, (PsiFile)file, (Set)possibleClassNames, (boolean)true, (boolean)true, (boolean)false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/fixes/DeclareELVarFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/fixes/DeclareELVarFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAcceptableClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

