/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/onlinecompletion/ProjectModulesCompletionProvider;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fulltextSearch", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "searchString", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestPrefix", "groupId", "artifactId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocal", "isLocal", "", "cacheKey", "getCacheKey", "()Ljava/lang/String;", "intellij.maven"})
public final class ProjectModulesCompletionProvider
implements DependencySearchProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String cacheKey;

    public ProjectModulesCompletionProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.cacheKey = "ProjectModulesCompletionProvider";
    }

    @Nullable
    public Object fulltextSearch(@NotNull String searchString, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.getLocal();
    }

    @Nullable
    public Object suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.getLocal();
    }

    private final List<RepositoryArtifactData> getLocal() {
        MavenLog.LOG.debug("Project: get local maven artifacts started");
        List<MavenProject> list = MavenProjectsManager.getInstance(this.myProject).getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
        List result = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), ProjectModulesCompletionProvider::getLocal$lambda$0), ProjectModulesCompletionProvider::getLocal$lambda$1), ProjectModulesCompletionProvider::getLocal$lambda$2));
        MavenLog.LOG.debug("Project: get local maven artifacts finished: " + result.size());
        return result;
    }

    public boolean isLocal() {
        return true;
    }

    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    private static final MavenDependencyCompletionItem getLocal$lambda$0(MavenProject it) {
        return new MavenDependencyCompletionItem(it.getMavenId().getKey());
    }

    private static final boolean getLocal$lambda$1(MavenDependencyCompletionItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGroupId() != null && it.getArtifactId() != null;
    }

    private static final MavenRepositoryArtifactInfo getLocal$lambda$2(MavenDependencyCompletionItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getGroupId();
        Intrinsics.checkNotNull((Object)string);
        String string2 = it.getArtifactId();
        Intrinsics.checkNotNull((Object)string2);
        MavenDependencyCompletionItem[] mavenDependencyCompletionItemArray = new MavenDependencyCompletionItem[]{it};
        return new MavenRepositoryArtifactInfo(string, string2, mavenDependencyCompletionItemArray);
    }
}

