/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUIUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenIgnoredFilesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final char SEPARATOR = ',';
    private final MavenProjectsManager myManager;
    private Collection<String> myOriginallyIgnoredFilesPaths;
    private String myOriginallyIgnoredFilesPatterns;
    private JPanel myMainPanel;
    private ElementsChooser<String> myIgnoredFilesPathsChooser;
    private JTextArea myIgnoredFilesPattersEditor;
    private JPanel myIgnoredFilesPatternsPanel;
    private JPanel myIgnoredFilesPanel;

    public MavenIgnoredFilesConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myManager = MavenProjectsManager.getInstance(project);
        this.myIgnoredFilesPatternsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)MavenConfigurableBundle.message("maven.settings.ignored.tooltip", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myIgnoredFilesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)MavenConfigurableBundle.message("maven.settings.ignored.title", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
    }

    private void createUIComponents() {
        this.myIgnoredFilesPathsChooser = new ElementsChooser(true);
        this.myIgnoredFilesPathsChooser.getEmptyText().setText(MavenConfigurableBundle.message("maven.settings.ignored.no.file", new Object[0]));
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !MavenUtil.equalAsSets(this.myOriginallyIgnoredFilesPaths, this.myIgnoredFilesPathsChooser.getMarkedElements()) || !this.myOriginallyIgnoredFilesPatterns.equals(this.myIgnoredFilesPattersEditor.getText());
    }

    public void apply() throws ConfigurationException {
        this.myManager.setIgnoredFilesPaths(this.myIgnoredFilesPathsChooser.getMarkedElements());
        this.myManager.setIgnoredFilesPatterns(Strings.tokenize(this.myIgnoredFilesPattersEditor.getText(), " \t\n\r\f,"));
    }

    public void reset() {
        this.myOriginallyIgnoredFilesPaths = this.myManager.getIgnoredFilesPaths();
        this.myOriginallyIgnoredFilesPatterns = Strings.detokenize(this.myManager.getIgnoredFilesPatterns(), ',');
        List projectsFiles = this.myManager.isInitialized() ? this.myManager.getProjectsFiles() : Collections.emptyList();
        MavenUIUtil.setElements(this.myIgnoredFilesPathsChooser, MavenUtil.collectPaths(projectsFiles), this.myOriginallyIgnoredFilesPaths, (o1, o2) -> FileUtil.comparePaths((String)o1, (String)o2));
        this.myIgnoredFilesPattersEditor.setText(this.myOriginallyIgnoredFilesPatterns);
    }

    @Nls
    public String getDisplayName() {
        return MavenConfigurableBundle.message("maven.settings.ignored.title", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.maven.ignored.files";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MavenIgnoredFilesConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenIgnoredFilesConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextArea jTextArea;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIgnoredFilesPatternsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 40), null));
        this.myIgnoredFilesPattersEditor = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        this.myIgnoredFilesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        ElementsChooser<String> elementsChooser = this.myIgnoredFilesPathsChooser;
        jPanel.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

