/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.structure.ArtifactNode;
import org.jetbrains.idea.maven.navigator.structure.MavenNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectNode;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ViewDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "Lorg/jetbrains/idea/maven/navigator/structure/MavenNode;", "<init>", "()V", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getSelectedData", "getModule", "Lcom/intellij/openapi/module/Module;", "selectedData", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getDependencyScope", "", "intellij.maven"})
public final class ViewDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction<MavenNode> {
    @NotNull
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return MavenUtil.SYSTEM_ID;
    }

    @Nullable
    public MavenNode getSelectedData(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component data = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        SimpleTree simpleTree = data instanceof SimpleTree ? (SimpleTree)data : null;
        SimpleNode simpleNode = simpleTree != null ? simpleTree.getSelectedNode() : null;
        return simpleNode instanceof MavenNode ? (MavenNode)simpleNode : null;
    }

    @Nullable
    public Module getModule(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        MavenProjectNode mavenProjectNode = selectedData.findProjectNode();
        if (mavenProjectNode == null) {
            return null;
        }
        MavenProjectNode projectNode = mavenProjectNode;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        return mavenProjectsManager.findModule(projectNode.getMavenProject());
    }

    @Nullable
    public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        DependencyAnalyzerDependency.Data data;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        MavenNode mavenNode = selectedData;
        if (mavenNode instanceof ArtifactNode) {
            String string = ((ArtifactNode)((Object)selectedData)).getArtifact().getGroupId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupId(...)");
            String string2 = ((ArtifactNode)((Object)selectedData)).getArtifact().getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
            String string3 = ((ArtifactNode)((Object)selectedData)).getArtifact().getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            data = (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
        } else {
            data = mavenNode instanceof MavenProjectNode ? (DependencyAnalyzerDependency.Data)new DAModule(((MavenProjectNode)((Object)selectedData)).getMavenProject().getDisplayName()) : null;
        }
        return data;
    }

    @Nullable
    public String getDependencyScope(@NotNull AnActionEvent e, @NotNull MavenNode selectedData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
        if (selectedData instanceof ArtifactNode) {
            return ((ArtifactNode)((Object)selectedData)).getArtifact().getScope();
        }
        return null;
    }
}

