/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.Idle;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.server.ssl.State;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/WaitEndAndExecute;", "Lorg/jetbrains/idea/maven/server/ssl/State;", "machine", "Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "key", "", "authType", "", "certificates", "Ljava/util/ArrayList;", "Ljava/security/cert/X509Certificate;", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;ILjava/lang/String;Ljava/util/ArrayList;)V", "getMachine", "()Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "getKey", "()I", "getAuthType", "()Ljava/lang/String;", "getCertificates", "()Ljava/util/ArrayList;", "addLine", "text", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nSslDelegateHandlerStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslDelegateHandlerStateMachine.kt\norg/jetbrains/idea/maven/server/ssl/WaitEndAndExecute\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,143:1\n37#2,2:144\n*S KotlinDebug\n*F\n+ 1 SslDelegateHandlerStateMachine.kt\norg/jetbrains/idea/maven/server/ssl/WaitEndAndExecute\n*L\n121#1:144,2\n*E\n"})
public final class WaitEndAndExecute
extends State {
    @NotNull
    private final SslDelegateHandlerStateMachine machine;
    private final int key;
    @NotNull
    private final String authType;
    @NotNull
    private final ArrayList<X509Certificate> certificates;

    public WaitEndAndExecute(@NotNull SslDelegateHandlerStateMachine machine, int key, @NotNull String authType, @NotNull ArrayList<X509Certificate> certificates) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        super(null);
        this.machine = machine;
        this.key = key;
        this.authType = authType;
        this.certificates = certificates;
    }

    @NotNull
    public final SslDelegateHandlerStateMachine getMachine() {
        return this.machine;
    }

    public final int getKey() {
        return this.key;
    }

    @NotNull
    public final String getAuthType() {
        return this.authType;
    }

    @NotNull
    public final ArrayList<X509Certificate> getCertificates() {
        return this.certificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public State addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)text, (Object)"----------checkServerTrusted----------")) {
            Collection $this$toTypedArray$iv = this.certificates;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            boolean trusted = this.machine.getChecker().checkCertificates(thisCollection$iv.toArray(new X509Certificate[0]), this.authType);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Closeable closeable = new PrintStream((OutputStream)os, true, "UTF-8");
            Throwable throwable = null;
            try {
                PrintStream ps = (PrintStream)closeable;
                boolean bl = false;
                ps.println("----------IdeDelegateTrustManager----------");
                ps.println("----------RESPONSE----------");
                ps.println(this.key);
                if (trusted) {
                    ps.println("----------OK----------");
                } else {
                    ps.println("----------ERROR----------");
                }
                SslDelegateHandlerStateMachine sslDelegateHandlerStateMachine = this.machine;
                synchronized (sslDelegateHandlerStateMachine) {
                    boolean bl2 = false;
                    this.machine.getOutput().write(os.toByteArray());
                    this.machine.getOutput().flush();
                    Unit unit = Unit.INSTANCE;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return new Idle(this.machine);
    }
}

